/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus;

import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.menus.InventoryMenu;
import ua.mcchickenstudio.opencreative.menus.Menus;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;

public abstract class AbstractMenu
implements InventoryMenu {
    private int rows;
    private String title;
    private boolean rightToLeft;
    protected final int[] allowedSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
    protected final long creationTime;
    protected final ItemStack AIR_ITEM = new ItemStack(Material.AIR);
    protected final ItemStack NO_PERMS_ITEM = ItemUtils.createItem(Material.RED_STAINED_GLASS, 1);
    protected final ItemStack DISABLED_ITEM = ItemUtils.createItem(Material.RED_STAINED_GLASS, 1, "items.disabled");
    protected final ItemStack DECORATION_ITEM = ItemUtils.createItem(Material.LIGHT_GRAY_STAINED_GLASS, 1);
    protected final ItemStack DECORATION_PANE_ITEM = ItemUtils.createItem(Material.GRAY_STAINED_GLASS_PANE, 1);
    protected Inventory inventory;

    public AbstractMenu(int rows, String title) {
        this.rows = rows;
        this.title = title;
        this.creationTime = System.currentTimeMillis();
    }

    public void setItem(int slot, ItemStack item) {
        slot = Math.clamp(0L, slot, this.getSize());
        if (item == null) {
            item = ItemStack.empty();
        }
        this.getInventory().setItem(slot, item);
    }

    public void setItem(ItemStack item, int ... slots) {
        for (int slot : slots) {
            this.setItem(slot, item);
        }
    }

    @NotNull
    public ItemStack getItem(int slot) {
        if (slot < 0 || slot >= this.getInventory().getSize()) {
            ItemStack itemStack = this.AIR_ITEM.clone();
            if (itemStack == null) {
                AbstractMenu.$$$reportNull$$$0(0);
            }
            return itemStack;
        }
        ItemStack item = this.getInventory().getItem(slot);
        ItemStack itemStack = item == null ? this.AIR_ITEM.clone() : item;
        if (itemStack == null) {
            AbstractMenu.$$$reportNull$$$0(1);
        }
        return itemStack;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @NotNull
    public Inventory getInventory() {
        this.rows = Math.clamp(1L, this.rows, 6);
        if (this.inventory == null || this.inventory.getSize() != this.rows * 9) {
            this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(this.rows * 9), (Component)Component.text((String)this.title));
        }
        Inventory inventory = this.inventory;
        if (inventory == null) {
            AbstractMenu.$$$reportNull$$$0(2);
        }
        return inventory;
    }

    @Override
    public void open(@NotNull Player player) {
        if (player == null) {
            AbstractMenu.$$$reportNull$$$0(3);
        }
        Menus.addMenu(this);
        try {
            this.inventory = this.getInventory();
            this.fillItems(player);
            player.openInventory(this.inventory);
        }
        catch (Exception e) {
            ErrorUtils.sendPlayerErrorMessage(player, "Failed to open AbstractMenu with title " + this.title + ". ", e);
        }
    }

    public abstract void fillItems(Player var1);

    @Override
    public abstract void onClick(@NotNull InventoryClickEvent var1);

    @Override
    public abstract void onOpen(@NotNull InventoryOpenEvent var1);

    protected final boolean isClickedInMenuSlots(InventoryClickEvent event) {
        if (event.getClickedInventory() == null) {
            return false;
        }
        if (event.getInventory().getHolder() == null) {
            return false;
        }
        return event.getInventory().getHolder().equals((Object)event.getClickedInventory().getHolder());
    }

    protected final boolean isPlayerClicked(InventoryClickEvent event) {
        return event.getWhoClicked() instanceof Player;
    }

    public int getSize() {
        return this.rows * 9;
    }

    public int getRows() {
        return this.rows;
    }

    protected void setRows(int rows) {
        this.rows = rows;
        if (this.inventory != null) {
            ItemStack[] oldItems = this.inventory.getContents();
            this.inventory = Bukkit.createInventory((InventoryHolder)this, (int)(rows * 9), (Component)Component.text((String)this.title));
            for (int slot = 0; slot < oldItems.length && slot < this.inventory.getSize(); ++slot) {
                this.inventory.setItem(slot, oldItems[slot]);
            }
        }
    }

    protected int reverse(int slot) {
        while (slot > 8) {
            slot -= 9;
        }
        return 8 - slot;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    protected boolean isNotEmpty(ItemStack item) {
        return item != null && item.getType() != Material.AIR;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/menus/AbstractMenu";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getItem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInventory";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/menus/AbstractMenu";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "open";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

