/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus;

import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;

public final class ConfirmationMenu
extends AbstractMenu {
    private final Material infoMaterial;
    private final String infoName;
    private final List<String> infoLore;
    private final BukkitRunnable yesRunnable;

    public ConfirmationMenu(String title, Material infoMaterial, String infoName, List<String> infoLore, BukkitRunnable yesRunnable) {
        super(6, title);
        this.infoMaterial = infoMaterial;
        this.infoName = infoName;
        this.infoLore = infoLore;
        this.yesRunnable = yesRunnable;
    }

    @Override
    public void fillItems(Player player) {
        ItemStack info = ItemUtils.createItem(this.infoMaterial, 1);
        ItemUtils.setDisplayName(info, this.infoName);
        ItemUtils.setLore(info, this.infoLore);
        this.setItem(13, info);
        this.setItem(37, ItemUtils.createItem(Material.RED_STAINED_GLASS, 1, "menus.confirmation.items.cancel"));
        player.setCooldown(Material.LIME_SHULKER_BOX, 60);
        this.setItem(43, ItemUtils.createItem(Material.LIME_SHULKER_BOX, 1, "menus.confirmation.items.confirm"));
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            ConfirmationMenu.$$$reportNull$$$0(0);
        }
        event.setCancelled(true);
        if (!this.isPlayerClicked(event) || !this.isClickedInMenuSlots(event)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (event.getSlot() == 43) {
            event.getClickedInventory().setItem(43, this.AIR_ITEM);
            player.closeInventory();
            this.yesRunnable.run();
        } else if (event.getSlot() == 37) {
            player.closeInventory();
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        HumanEntity humanEntity;
        if (event == null) {
            ConfirmationMenu.$$$reportNull$$$0(1);
        }
        if ((humanEntity = event.getPlayer()) instanceof Player) {
            Player player = (Player)humanEntity;
            Sounds.MENU_OPEN_CONFIRMATION.play((Audience)player);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "ua/mcchickenstudio/opencreative/menus/ConfirmationMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

