/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus;

import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public final class CreativeMenu
extends AbstractMenu {
    private final ItemStack RELOAD_ITEM = ItemUtils.createItem(Material.STRUCTURE_VOID, 1, "menus.creative.items.reload", "reload");
    private final ItemStack RESET_LOCALE_ITEM = ItemUtils.createItem(Material.KNOWLEDGE_BOOK, 1, "menus.creative.items.reset-locale", "reset-locale");
    private final ItemStack CHECK_UPDATES = ItemUtils.createItem(Material.ENDER_EYE, 1, "menus.creative.items.check-updates", "check-updates");
    private final ItemStack LIST_CORRUPTED = ItemUtils.createItem(Material.TNT_MINECART, 1, "menus.creative.items.list-corrupted", "list-corrupted");
    private final ItemStack LIST_DEPRECATED = ItemUtils.createItem(Material.HOPPER_MINECART, 1, "menus.creative.items.list-deprecated", "list-deprecated");
    private final ItemStack LIST_LOADED = ItemUtils.createItem(Material.CHEST_MINECART, 1, "menus.creative.items.list-loaded", "list-loaded");
    private final ItemStack MAINTENANCE_START = ItemUtils.createItem(Material.OBSERVER, 1, "menus.creative.items.maintenance-start", "maintenance-start");
    private final ItemStack MAINTENANCE_END = ItemUtils.createItem(Material.DROPPER, 1, "menus.creative.items.maintenance-end", "maintenance-end");
    private final ItemStack DEBUG_ENABLE = ItemUtils.createItem(Material.REDSTONE_TORCH, 1, "menus.creative.items.debug-enable", "debug-enable");
    private final ItemStack DEBUG_DISABLE = ItemUtils.createItem(Material.SOUL_TORCH, 1, "menus.creative.items.debug-disable", "debug-disable");

    public CreativeMenu() {
        super(6, MessageUtils.getLocaleMessage("menus.creative.title", false).replace("%version%", OpenCreative.getVersion()).replace("%codename%", OpenCreative.getCodename()));
    }

    @Override
    public void fillItems(Player player) {
        this.setItem(49, ItemUtils.createItem(Material.BEACON, 1, "menus.creative.items.info"));
        this.setItem(ItemUtils.createItem(Material.LIGHT_BLUE_STAINED_GLASS_PANE, 1), 47, 51);
        this.setItem(this.DECORATION_PANE_ITEM, 45, 46, 52, 53);
        this.setItem(10, player.hasPermission("opencreative.reload") ? this.RELOAD_ITEM : this.DECORATION_ITEM);
        this.setItem(12, player.hasPermission("opencreative.resetlocale") ? this.RESET_LOCALE_ITEM : this.DECORATION_ITEM);
        this.setItem(14, player.hasPermission("opencreative.updates.check") ? this.CHECK_UPDATES : this.DECORATION_ITEM);
        this.setItem(16, player.hasPermission("opencreative.maintenance") ? (OpenCreative.getSettings().isMaintenance() ? this.MAINTENANCE_END : this.MAINTENANCE_START) : this.DECORATION_ITEM);
        this.setItem(28, player.hasPermission("opencreative.list.loaded") ? this.LIST_LOADED : this.DECORATION_ITEM);
        this.setItem(30, player.hasPermission("opencreative.list.corrupted") ? this.LIST_CORRUPTED : this.DECORATION_ITEM);
        this.setItem(32, player.hasPermission("opencreative.list.deprecated") ? this.LIST_DEPRECATED : this.DECORATION_ITEM);
        this.setItem(34, player.hasPermission("opencreative.debug") ? (OpenCreative.getSettings().isDebug() ? this.DEBUG_DISABLE : this.DEBUG_ENABLE) : this.DECORATION_ITEM);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            CreativeMenu.$$$reportNull$$$0(0);
        }
        ItemStack clickedItem = event.getCurrentItem();
        event.setCancelled(true);
        if (!this.isClickedInMenuSlots(event)) {
            return;
        }
        if (clickedItem == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String type = ItemUtils.getItemType(clickedItem);
        if (!type.isEmpty()) {
            player.closeInventory();
        }
        switch (type) {
            case "reload": {
                player.performCommand("creative reload");
                break;
            }
            case "reset-locale": {
                player.performCommand("creative resetlocale");
                break;
            }
            case "check-updates": {
                player.performCommand("creative update");
                break;
            }
            case "maintenance-start": {
                player.performCommand("creative maintenance start");
                break;
            }
            case "maintenance-end": {
                player.performCommand("creative maintenance end");
                break;
            }
            case "debug-enable": {
                player.performCommand("creative debug enable");
                break;
            }
            case "debug-disable": {
                player.performCommand("creative debug disable");
                break;
            }
            case "list-loaded": {
                player.performCommand("creative list");
                break;
            }
            case "list-deprecated": {
                player.performCommand("creative deprecated");
                break;
            }
            case "list-corrupted": {
                player.performCommand("creative corrupted");
            }
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            CreativeMenu.$$$reportNull$$$0(1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "ua/mcchickenstudio/opencreative/menus/CreativeMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

