/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus;

import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.menus.AbstractListMenu;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;

public abstract class ListBrowserMenu<T>
extends AbstractListMenu<T> {
    private final int previousPageButtonSlot;
    private final int nextPageButtonSlot;
    private final int noElementsPageButtonSlot;

    public ListBrowserMenu(Player player, String title) {
        this(player, title, PlacementLayout.LEFT_CHARMS_BAR);
    }

    public ListBrowserMenu(Player player, String title, PlacementLayout layout) {
        this(player, title, layout.getElementsSlots(), layout.getCharmsBarSlots(), layout.getDecorationSlots(), layout.getNoElementsSlot(), layout.getPreviousPageSlot(), layout.getNextPageSlot());
    }

    public ListBrowserMenu(Player player, String title, PlacementLayout layout, int[] charmsBarSlots, int[] decorationSlots) {
        this(player, title, layout.getElementsSlots(), charmsBarSlots, decorationSlots, layout.getNoElementsSlot(), layout.getPreviousPageSlot(), layout.getNextPageSlot());
    }

    public ListBrowserMenu(Player player, String title, int[] elementsSlots, int[] charmsBarSlots, int[] decorationSlots, int noElementsPageButtonSlot, int previousPageButtonSlot, int nextPageButtonSlot) {
        super(player, title, elementsSlots, charmsBarSlots, decorationSlots);
        this.noElementsPageButtonSlot = noElementsPageButtonSlot;
        this.previousPageButtonSlot = previousPageButtonSlot;
        this.nextPageButtonSlot = nextPageButtonSlot;
    }

    @Override
    protected abstract ItemStack getElementIcon(T var1);

    @Override
    protected abstract void fillOtherItems();

    @Override
    protected abstract void onCharmsBarClick(InventoryClickEvent var1);

    @Override
    protected abstract void onElementClick(InventoryClickEvent var1);

    @Override
    public abstract List<T> getElements();

    protected abstract ItemStack getNextPageButton();

    protected abstract ItemStack getPreviousPageButton();

    protected abstract ItemStack getNoElementsButton();

    protected ItemStack getNextPageEmptyButton() {
        return ItemStack.empty();
    }

    protected ItemStack getPreviousPageEmptyButton() {
        return ItemStack.empty();
    }

    protected void fillArrowsItems(int currentPage) {
        if (this.elements.isEmpty()) {
            this.setItem(this.noElementsPageButtonSlot, this.getNoElementsButton());
        } else {
            int maxPagesAmount = this.getPages();
            if (currentPage > maxPagesAmount || currentPage < 1) {
                currentPage = 1;
            }
            if (currentPage > 1) {
                this.setItem(this.previousPageButtonSlot, this.getPreviousPageButton());
            }
            if (currentPage < maxPagesAmount) {
                this.setItem(this.nextPageButtonSlot, this.getNextPageButton());
            }
        }
    }

    @Override
    protected void fillElements(int page) {
        this.fillEmpty();
        if (this.elements.isEmpty()) {
            this.setItem(this.noElementsPageButtonSlot, this.getNoElementsButton());
        } else {
            List content = this.getElementsFromPage(page);
            int slot = 0;
            for (Object object : content) {
                this.setItem(this.getElementsSlots()[slot], this.getElementIcon(object));
                ++slot;
            }
        }
    }

    @Override
    protected void fillEmpty() {
        for (int slot : this.getElementsSlots()) {
            this.setItem(slot, this.AIR_ITEM);
        }
        this.setItem(this.nextPageButtonSlot, this.getNextPageEmptyButton());
        this.setItem(this.previousPageButtonSlot, this.getPreviousPageEmptyButton());
    }

    @Override
    public void fillItems(Player player) {
        this.elements.addAll(this.getElements());
        this.fillDecorationItems();
        this.fillElements(this.getCurrentPage());
        this.fillArrowsItems(this.getCurrentPage());
        this.fillOtherItems();
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            ListBrowserMenu.$$$reportNull$$$0(0);
        }
        if (!this.isPlayerClicked(event) || !this.isClickedInMenuSlots(event)) {
            event.setCancelled(true);
            return;
        }
        if (this.isElementClicked(event.getSlot()) && this.isNotEmpty(event.getCurrentItem()) && !ItemUtils.itemEquals(event.getCurrentItem(), this.getNoElementsButton())) {
            this.onElementClick(event);
        } else if (ItemUtils.itemEquals(event.getCurrentItem(), this.DECORATION_ITEM) || ItemUtils.itemEquals(event.getCurrentItem(), this.DECORATION_PANE_ITEM)) {
            event.setCancelled(true);
        } else if (ItemUtils.itemEquals(event.getCurrentItem(), this.getNextPageButton())) {
            Sounds.MENU_NEXT_PAGE.play((Audience)event.getWhoClicked());
            this.nextPage();
            event.setCancelled(true);
        } else if (ItemUtils.itemEquals(event.getCurrentItem(), this.getPreviousPageButton())) {
            Sounds.MENU_PREVIOUS_PAGE.play((Audience)event.getWhoClicked());
            this.previousPage();
            event.setCancelled(true);
        } else if (this.isCharmsBarClicked(event.getSlot()) && this.isNotEmpty(event.getCurrentItem()) && !event.getCurrentItem().equals((Object)this.DECORATION_ITEM)) {
            this.onCharmsBarClick(event);
        } else {
            event.setCancelled(true);
        }
    }

    @Override
    public ItemStack getElementIcon(int index) {
        if (index < 0 || index >= this.elements.size()) {
            return this.AIR_ITEM.clone();
        }
        return this.getElementIcon(this.elements.get(index));
    }

    public void updateElements() {
        this.elements.clear();
        this.elements.addAll(this.getElements());
    }

    public List<T> getCurrentElements() {
        return this.elements;
    }

    @Override
    protected void nextPage() {
        this.setCurrentPage(this.getNextPage());
        this.fillElements(this.getCurrentPage());
        this.fillArrowsItems(this.getCurrentPage());
    }

    @Override
    protected void previousPage() {
        this.setCurrentPage(this.getPreviousPage());
        this.fillElements(this.getCurrentPage());
        this.fillArrowsItems(this.getCurrentPage());
    }

    private boolean isCharmsBarClicked(int clickedSlot) {
        for (int itemSlot : this.getCharmsBarSlots()) {
            if (itemSlot != clickedSlot) continue;
            return true;
        }
        return false;
    }

    private boolean isElementClicked(int clickedSlot) {
        for (int itemSlot : this.getElementsSlots()) {
            if (itemSlot != clickedSlot) continue;
            return true;
        }
        return false;
    }

    protected int getNextPageButtonSlot() {
        return this.nextPageButtonSlot;
    }

    protected int getPreviousPageButtonSlot() {
        return this.previousPageButtonSlot;
    }

    protected int getNoElementsPageButtonSlot() {
        return this.noElementsPageButtonSlot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "ua/mcchickenstudio/opencreative/menus/ListBrowserMenu", "onClick"));
    }

    public static enum PlacementLayout {
        LEFT_CHARMS_BAR(new int[]{12, 13, 14, 15, 16, 21, 22, 23, 24, 25, 30, 31, 32, 33, 34, 39, 40, 41, 42, 43}, new int[]{0, 9, 18, 27, 36, 45}, new int[]{1, 10, 19, 28, 37, 46}, 23, 47, 53),
        BOTTOM_CHARMS_BAR(new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34}, new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53}, new int[]{36, 37, 38, 39, 40, 41, 42, 43, 44}, 13, 36, 44),
        BOTTOM_NO_DECORATION(new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34}, new int[]{45, 46, 47, 48, 49, 50, 51, 52, 53}, new int[0], 13, 45, 53),
        LOCATION_CHOOSER(new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43}, new int[0], new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 45, 46, 47, 48, 49, 50, 51, 52, 53}, 13, 45, 53),
        VALUE_CHOOSER(new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43}, new int[0], new int[0], 13, 45, 53);

        private final int[] elementsSlots;
        private final int[] charmsBarSlots;
        private final int[] decorationSlots;
        private final int noElementsSlot;
        private final int previousPageSlot;
        private final int nextPageSlot;

        private PlacementLayout(int[] elementsSlots, int[] charmsBarSlots, int[] decorationSlots, int noElementsSlot, int previousPageSlot, int nextPageSlot) {
            this.elementsSlots = elementsSlots;
            this.charmsBarSlots = charmsBarSlots;
            this.decorationSlots = decorationSlots;
            this.noElementsSlot = noElementsSlot;
            this.previousPageSlot = previousPageSlot;
            this.nextPageSlot = nextPageSlot;
        }

        private int[] getCharmsBarSlots() {
            return this.charmsBarSlots;
        }

        private int[] getElementsSlots() {
            return this.elementsSlots;
        }

        private int[] getDecorationSlots() {
            return this.decorationSlots;
        }

        private int getNextPageSlot() {
            return this.nextPageSlot;
        }

        private int getPreviousPageSlot() {
            return this.previousPageSlot;
        }

        private int getNoElementsSlot() {
            return this.noElementsSlot;
        }
    }
}

