/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.buttons;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class ParameterButton {
    private final ItemStack item;
    private Object currentValue;
    private int currentChoice;
    private final String turnedPath;
    private final String localizationPath;
    private final List<String> originalLore;
    private final List<Object> valueList = new ArrayList<Object>();
    private final List<Material> materialList = new ArrayList<Material>();

    public ParameterButton(Object currentValue, List<Object> values, String name, String turnedPath, String itemPath, List<Material> materials) {
        this.turnedPath = turnedPath;
        this.localizationPath = itemPath;
        this.materialList.addAll(materials);
        this.valueList.addAll(values);
        if (this.currentChoice == this.materialList.size() || this.currentChoice == this.valueList.size()) {
            this.currentChoice = 1;
        }
        if (this.currentChoice == 0) {
            this.currentChoice = 1;
        }
        for (int i = 0; i < this.valueList.size(); ++i) {
            if (!currentValue.equals(this.valueList.get(i))) continue;
            this.currentChoice = i + 1;
            break;
        }
        this.currentValue = currentValue;
        ItemStack itemStack = this.item = this.materialList.size() == this.currentChoice - 1 ? ItemUtils.createItem(Material.BARRIER, 1, this.localizationPath) : ItemUtils.createItem(this.materialList.get(this.currentChoice - 1), 1, this.localizationPath);
        if (!MessageUtils.messageExists(this.localizationPath + ".name")) {
            ItemMeta meta = this.item.getItemMeta();
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)("&fParameter: &6" + name)));
            this.item.setItemMeta(meta);
        }
        if (!MessageUtils.messageExists(this.localizationPath + ".lore")) {
            ItemMeta meta = this.item.getItemMeta();
            ArrayList<Object> notFoundLore = new ArrayList<Object>();
            notFoundLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6This parameter was not filled in localization,"));
            notFoundLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6please tell administration to fill line."));
            notFoundLore.add(" ");
            notFoundLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7" + this.localizationPath)));
            notFoundLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&fValues:"));
            for (int i = 1; i < this.valueList.size() + 1; ++i) {
                notFoundLore.add("%" + i + "%");
            }
            meta.setLore(notFoundLore);
            this.item.setItemMeta(meta);
        }
        this.originalLore = this.item.getItemMeta().getLore();
        this.updateLore();
    }

    public ParameterButton(Object currentValue, List<Object> values, String name, String turnedPath, String itemPath, Material material) {
        this.turnedPath = turnedPath;
        this.localizationPath = itemPath;
        this.materialList.add(material);
        this.valueList.addAll(values);
        if (this.currentChoice == this.materialList.size() || this.currentChoice == this.valueList.size()) {
            this.currentChoice = 1;
        }
        if (this.currentChoice == 0) {
            this.currentChoice = 1;
        }
        for (int i = 0; i < this.valueList.size(); ++i) {
            if (!currentValue.equals(this.valueList.get(i))) continue;
            this.currentChoice = i + 1;
            break;
        }
        this.currentValue = currentValue;
        this.item = ItemUtils.createItem(material, 1, this.localizationPath);
        if (!MessageUtils.messageExists(this.localizationPath + ".name")) {
            ItemMeta meta = this.item.getItemMeta();
            meta.setDisplayName(ChatColor.translateAlternateColorCodes((char)'&', (String)("&fParameter: &6" + name)));
            this.item.setItemMeta(meta);
        }
        if (!MessageUtils.messageExists(this.localizationPath + ".lore")) {
            ItemMeta meta = this.item.getItemMeta();
            ArrayList<Object> notFoundLore = new ArrayList<Object>();
            notFoundLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6This parameter was not filled in localization,"));
            notFoundLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&6please tell administration to fill line."));
            notFoundLore.add(" ");
            notFoundLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)("&7" + this.localizationPath)));
            notFoundLore.add(ChatColor.translateAlternateColorCodes((char)'&', (String)"&fValues:"));
            for (int i = 1; i < this.valueList.size() + 1; ++i) {
                notFoundLore.add("%" + i + "%");
            }
            meta.setLore(notFoundLore);
            this.item.setItemMeta(meta);
        }
        this.originalLore = this.item.getItemMeta().getLore();
        this.updateLore();
    }

    public void previous() {
        this.currentChoice = this.currentChoice <= 1 ? this.valueList.size() : --this.currentChoice;
        this.currentValue = this.valueList.get(this.currentChoice - 1);
        if (this.currentChoice <= this.materialList.size()) {
            this.item.setType(this.materialList.get(this.currentChoice - 1));
        }
        this.updateLore();
    }

    public void next() {
        this.currentChoice = this.currentChoice >= this.valueList.size() ? 1 : ++this.currentChoice;
        if (this.currentChoice - 1 == this.valueList.size()) {
            return;
        }
        this.currentValue = this.valueList.get(this.currentChoice - 1);
        if (this.currentChoice <= this.materialList.size()) {
            this.item.setType(this.materialList.get(this.currentChoice - 1));
        }
        this.updateLore();
    }

    public void updateLore() {
        String turnedOn = MessageUtils.getLocaleMessage(this.turnedPath + ".turned-on");
        String turnedOff = MessageUtils.getLocaleMessage(this.turnedPath + ".turned-off");
        ArrayList<String> newLore = new ArrayList<String>();
        for (String loreLine : this.originalLore) {
            String content = loreLine;
            if (content.matches("%[0-9]+%")) {
                Object object;
                Object object2;
                int choiceNumber = Integer.parseInt(content.replace("%", ""));
                if (choiceNumber > this.valueList.size()) continue;
                String turned = choiceNumber == this.currentChoice ? turnedOn : turnedOff;
                Object value = this.valueList.get(choiceNumber - 1);
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    object2 = i;
                } else {
                    object2 = value;
                }
                String choicePath = this.localizationPath + ".choices." + object2.toString();
                if (value instanceof Integer) {
                    Integer i = (Integer)value;
                    object = i;
                } else {
                    object = value;
                }
                String choiceMessage = object.toString();
                if (MessageUtils.messageExists(choicePath)) {
                    choiceMessage = MessageUtils.getLocaleMessage(choicePath, false);
                }
                content = content.replace("%" + choiceNumber + "%", turned + choiceMessage);
            }
            newLore.add(content);
        }
        ItemMeta meta = this.item.getItemMeta();
        meta.setLore(newLore);
        this.item.setItemMeta(meta);
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemStack getItem(boolean withoutFlags) {
        ItemStack itemStack = this.item.clone();
        for (ItemFlag flag : itemStack.getItemFlags()) {
            itemStack.removeItemFlags(new ItemFlag[]{flag});
        }
        return itemStack;
    }

    public int getCurrentChoice() {
        return this.currentChoice;
    }

    public Object getCurrentValue() {
        return this.valueList.get(this.currentChoice - 1);
    }
}

