/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.world;

import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.commands.world.AdvertisementCommand;
import ua.mcchickenstudio.opencreative.events.planet.PlanetAdvertisementEvent;
import ua.mcchickenstudio.opencreative.events.planet.PlanetModeChangeEvent;
import ua.mcchickenstudio.opencreative.events.planet.PlanetSharingChangeEvent;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.menus.ConfirmationMenu;
import ua.mcchickenstudio.opencreative.menus.world.WorldMenu;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.CooldownUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public final class WorldAccessMenu
extends AbstractMenu
implements WorldMenu {
    private final Planet planet;
    private final ItemStack CONNECT = ItemUtils.createItem(Material.NETHER_STAR, 1, "menus.world-access.items.connect", "connect");
    private final ItemStack PLAY_MODE = ItemUtils.createItem(Material.DIAMOND_BLOCK, 1, "menus.world-access.items.play-mode", "play");
    private final ItemStack BUILD_MODE = ItemUtils.createItem(Material.BRICKS, 1, "menus.world-access.items.build-mode", "build");
    private final ItemStack ADVERTISEMENT = ItemUtils.createItem(Material.BEACON, 1, "menus.world-access.items.advertisement", "ad");
    private final ItemStack OPENED = ItemUtils.createItem(Material.LIME_STAINED_GLASS, 1, "menus.world-access.items.opened", "close");
    private final ItemStack CLOSED = ItemUtils.createItem(Material.RED_STAINED_GLASS, 1, "menus.world-access.items.closed", "open");
    private final ItemStack DELETE = ItemUtils.createItem(Material.TNT_MINECART, 1, "menus.world-access.items.delete", "delete");

    public WorldAccessMenu(Planet planet) {
        super(4, MessageUtils.getLocaleMessage("menus.world-access.title", false).replace("%name%", MessageUtils.substring(ChatColor.stripColor((String)planet.getInformation().getDisplayName()), 25)));
        this.planet = planet;
    }

    @Override
    public void fillItems(Player player) {
        if (CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.GENERIC_COMMAND) > 0) {
            if (!player.hasCooldown(this.PLAY_MODE.getType())) {
                player.setCooldown(this.PLAY_MODE.getType(), CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.GENERIC_COMMAND) * 20);
            }
            if (!player.hasCooldown(this.BUILD_MODE.getType())) {
                player.setCooldown(this.BUILD_MODE.getType(), CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.GENERIC_COMMAND) * 20);
            }
            if (!player.hasCooldown(this.CLOSED.getType())) {
                player.setCooldown(this.CLOSED.getType(), CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.GENERIC_COMMAND) * 20);
            }
            if (!player.hasCooldown(this.OPENED.getType())) {
                player.setCooldown(this.OPENED.getType(), CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.GENERIC_COMMAND) * 20);
            }
        }
        if (CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.ADVERTISEMENT_COMMAND) > 0 && !player.hasCooldown(this.ADVERTISEMENT.getType())) {
            player.setCooldown(this.ADVERTISEMENT.getType(), CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.ADVERTISEMENT_COMMAND) * 20);
        }
        this.setItem(this.DECORATION_PANE_ITEM, 28, 34);
        this.setItem(ItemUtils.createItem(Material.BLUE_STAINED_GLASS_PANE, 1), 29, 33);
        this.setItem(31, ItemUtils.setPersistentData(this.planet.getInformation().getIcon().clone(), ItemUtils.getItemTypeKey(), "connect"));
        this.setItem(13, this.CONNECT);
        this.CONNECT.setAmount(Math.clamp(1L, this.planet.getOnline(), 64));
        this.setItem(10, this.planet.getMode() == Planet.Mode.PLAYING ? this.PLAY_MODE : this.BUILD_MODE);
        this.setItem(27, this.ADVERTISEMENT);
        this.setItem(16, this.planet.getSharing() == Planet.Sharing.PUBLIC ? this.OPENED : this.CLOSED);
        this.setItem(35, this.DELETE);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            WorldAccessMenu.$$$reportNull$$$0(0);
        }
        event.setCancelled(true);
        if (!this.isPlayerClicked(event) || !this.isClickedInMenuSlots(event)) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        final Player player = (Player)event.getWhoClicked();
        switch (ItemUtils.getItemType(item)) {
            case "connect": {
                player.closeInventory();
                if (this.planet.equals(OpenCreative.getPlanetsManager().getPlanetByPlayer(player))) {
                    player.sendMessage(MessageUtils.getPlayerLocaleMessage("same-world", (OfflinePlayer)player));
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                this.planet.connectPlayer(player);
                break;
            }
            case "play": {
                if (player.hasCooldown(item.getType()) || CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.GENERIC_COMMAND) > 0) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                player.setCooldown(this.BUILD_MODE.getType(), OpenCreative.getSettings().getGroups().getGroup(player).getGenericCommandCooldown() * 20);
                PlanetModeChangeEvent planetEvent = new PlanetModeChangeEvent(this.planet, this.planet.getMode(), Planet.Mode.BUILD);
                planetEvent.callEvent();
                if (planetEvent.isCancelled()) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                Sounds.WORLD_MODE_BUILD.play((Audience)player);
                this.planet.setMode(Planet.Mode.BUILD);
                this.fillItems(player);
                break;
            }
            case "build": {
                if (player.hasCooldown(item.getType()) || CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.GENERIC_COMMAND) > 0) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                player.setCooldown(this.PLAY_MODE.getType(), OpenCreative.getSettings().getGroups().getGroup(player).getGenericCommandCooldown() * 20);
                PlanetModeChangeEvent planetEvent = new PlanetModeChangeEvent(this.planet, this.planet.getMode(), Planet.Mode.PLAYING);
                planetEvent.callEvent();
                if (planetEvent.isCancelled()) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                Sounds.WORLD_MODE_BUILD.play((Audience)player);
                this.planet.setMode(Planet.Mode.PLAYING);
                this.fillItems(player);
                break;
            }
            case "ad": {
                double advertisementPrice;
                double playerBalance;
                if (player.hasCooldown(item.getType()) || CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.ADVERTISEMENT_COMMAND) > 0) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                if (this.planet.getSharing() != Planet.Sharing.PUBLIC) {
                    player.sendMessage(MessageUtils.getLocaleMessage("advertisement.closed-world"));
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    player.setCooldown(item.getType(), OpenCreative.getSettings().getGroups().getGroup(player).getGenericCommandCooldown() * 20);
                    return;
                }
                PlanetAdvertisementEvent planetEvent = new PlanetAdvertisementEvent(this.planet, player);
                planetEvent.callEvent();
                if (planetEvent.isCancelled()) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                if (OpenCreative.getEconomy().isEnabled() && (playerBalance = OpenCreative.getEconomy().getBalance((OfflinePlayer)player).doubleValue()) < (advertisementPrice = OpenCreative.getSettings().getGroups().getGroup(player).getAdvertisementPrice())) {
                    player.sendMessage(MessageUtils.getPlayerLocaleMessage("advertisement.no-money", (OfflinePlayer)player).replace("%money%", String.valueOf(Math.round(advertisementPrice - playerBalance))));
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    player.setCooldown(item.getType(), OpenCreative.getSettings().getGroups().getGroup(player).getGenericCommandCooldown() * 20);
                    return;
                }
                player.setCooldown(item.getType(), OpenCreative.getSettings().getGroups().getGroup(player).getAdvertisementCooldown() * 20);
                AdvertisementCommand.handlePlanetAdvertisement(player, this.planet);
                break;
            }
            case "open": {
                if (player.hasCooldown(item.getType()) || CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.GENERIC_COMMAND) > 0) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                player.setCooldown(this.OPENED.getType(), OpenCreative.getSettings().getGroups().getGroup(player).getGenericCommandCooldown() * 20);
                PlanetSharingChangeEvent planetEvent = new PlanetSharingChangeEvent(this.planet, this.planet.getSharing(), Planet.Sharing.PUBLIC);
                planetEvent.callEvent();
                if (planetEvent.isCancelled()) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                Sounds.WORLD_SETTINGS_SHARING_PUBLIC.play((Audience)player);
                this.planet.setSharing(Planet.Sharing.PUBLIC);
                this.fillItems(player);
                break;
            }
            case "close": {
                if (player.hasCooldown(item.getType()) || CooldownUtils.getCooldown(player, CooldownUtils.CooldownType.GENERIC_COMMAND) > 0) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                player.setCooldown(this.CLOSED.getType(), OpenCreative.getSettings().getGroups().getGroup(player).getGenericCommandCooldown() * 20);
                PlanetSharingChangeEvent planetEvent = new PlanetSharingChangeEvent(this.planet, this.planet.getSharing(), Planet.Sharing.PRIVATE);
                planetEvent.callEvent();
                if (planetEvent.isCancelled()) {
                    Sounds.PLAYER_FAIL.play((Audience)player);
                    return;
                }
                Sounds.WORLD_SETTINGS_SHARING_PRIVATE.play((Audience)player);
                this.planet.setSharing(Planet.Sharing.PRIVATE);
                this.fillItems(player);
                break;
            }
            case "delete": {
                player.closeInventory();
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)OpenCreative.getPlugin(), () -> new ConfirmationMenu(MessageUtils.getLocaleMessage("menus.confirmation.delete-world", false).replace("%name%", MessageUtils.substring(ChatColor.stripColor((String)this.planet.getInformation().getDisplayName()), 20)), Material.TNT, MessageUtils.getLocaleItemName("menus.confirmation.items.delete-world.name"), MessageUtils.getLocaleItemDescription("menus.confirmation.items.delete-world.lore"), new BukkitRunnable(){

                    public void run() {
                        player.closeInventory();
                        if (!OpenCreative.getPlanetsManager().getPlanets().contains(WorldAccessMenu.this.planet)) {
                            this.cancel();
                            return;
                        }
                        if (!WorldAccessMenu.this.planet.isOwner(player)) {
                            this.cancel();
                            return;
                        }
                        Sounds.WORLD_DELETION.play((Audience)player);
                        OpenCreative.getPlanetsManager().deletePlanet(WorldAccessMenu.this.planet);
                        Bukkit.getServer().getScheduler().runTaskLater((Plugin)OpenCreative.getPlugin(), () -> player.sendMessage(MessageUtils.getLocaleMessage("deleting-world.message")), 60L);
                    }
                }).open(player), 5L);
            }
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            WorldAccessMenu.$$$reportNull$$$0(1);
        }
        Sounds.MENU_OPEN_WORLD_ACCESS.play((Audience)event.getPlayer());
    }

    @Override
    public Planet getPlanet() {
        return this.planet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "ua/mcchickenstudio/opencreative/menus/world/WorldAccessMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

