/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.world;

import java.util.List;
import java.util.Random;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.menus.buttons.ParameterButton;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;
import ua.mcchickenstudio.opencreative.utils.world.generators.EnvironmentCapable;
import ua.mcchickenstudio.opencreative.utils.world.generators.StructuresCapable;
import ua.mcchickenstudio.opencreative.utils.world.generators.WorldGenerator;
import ua.mcchickenstudio.opencreative.utils.world.generators.WorldGenerators;
import ua.mcchickenstudio.opencreative.utils.world.generators.WorldTemplate;

public final class WorldGenerationMenu
extends AbstractMenu {
    private final Player player;
    private final ParameterButton generatorButton;
    private final ParameterButton environmentButton;
    private final ParameterButton generateStructures;
    private final ItemStack createButton = ItemUtils.createItem(Material.PUFFERFISH_BUCKET, 1, "menus.world-creation.items.create");

    public WorldGenerationMenu(Player player, String generator, String environment, boolean generateStructures) {
        super(3, MessageUtils.getLocaleMessage("menus.world-creation.title", false));
        this.player = player;
        this.generatorButton = new ParameterButton((Object)generator, WorldGenerators.getInstance().getGeneratorsIDs(), "type", "menus.world-creation", "menus.world-creation.items.type", WorldGenerators.getInstance().getGeneratorsMaterials());
        this.environmentButton = new ParameterButton((Object)environment, List.of("normal", "nether", "the_end"), "environment", "menus.world-creation", "menus.world-creation.items.environment", List.of(Material.GRASS_BLOCK, Material.NETHERRACK, Material.END_STONE));
        this.generateStructures = new ParameterButton((Object)generateStructures, List.of(Boolean.valueOf(false), Boolean.valueOf(true)), "generate-structures", "menus.world-creation", "menus.world-creation.items.generate-structures", List.of(Material.DECORATED_POT, Material.BOOKSHELF));
    }

    public WorldGenerationMenu(Player player) {
        this(player, "flat", "normal", true);
    }

    @Override
    public void fillItems(Player player) {
        this.setItem(10, this.generatorButton.getItem());
        this.setItem(11, this.environmentButton.getItem());
        this.setItem(12, this.generateStructures.getItem());
        this.setItem(7, ItemUtils.createItem(Material.LIME_STAINED_GLASS_PANE, 1));
        this.setItem(16, this.createButton);
        this.setItem(25, ItemUtils.createItem(Material.LIME_STAINED_GLASS_PANE, 1));
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            WorldGenerationMenu.$$$reportNull$$$0(0);
        }
        if (!this.isPlayerClicked(event) || !this.isClickedInMenuSlots(event)) {
            return;
        }
        if (ItemUtils.itemEquals(this.DECORATION_ITEM, event.getCurrentItem())) {
            event.setCancelled(true);
            return;
        }
        event.setCancelled(true);
        switch (event.getRawSlot()) {
            case 10: {
                this.generatorButton.next();
                this.setItem(event.getRawSlot(), this.generatorButton.getItem());
                WorldGenerator generator = WorldGenerators.getInstance().getById(this.generatorButton.getCurrentValue().toString());
                if (generator != null) {
                    this.setItem(11, generator instanceof EnvironmentCapable ? this.environmentButton.getItem() : this.DECORATION_ITEM);
                    this.setItem(12, generator instanceof StructuresCapable ? this.generateStructures.getItem() : this.DECORATION_ITEM);
                }
                Sounds.MENU_GENERATION_CHANGE.play((Audience)this.player);
                break;
            }
            case 11: {
                this.environmentButton.next();
                this.setItem(event.getRawSlot(), this.environmentButton.getItem());
                Sounds.MENU_ENVIRONMENT_CHANGE.play((Audience)this.player);
                break;
            }
            case 12: {
                this.generateStructures.next();
                this.setItem(event.getRawSlot(), this.generateStructures.getItem());
                Sounds.MENU_GENERATE_STRUCTURES_CHANGE.play((Audience)this.player);
                break;
            }
            case 16: {
                boolean notReachedWorldsLimit;
                this.player.closeInventory();
                if (!OpenCreative.getStability().isFine()) {
                    this.player.sendMessage(MessageUtils.getLocaleMessage("creative.stability.cannot"));
                    Sounds.PLAYER_FAIL.play((Audience)this.player);
                    return;
                }
                boolean bl = notReachedWorldsLimit = OpenCreative.getPlanetsManager().getPlanetsByOwner(this.player).size() < OpenCreative.getSettings().getGroups().getGroup(this.player).getWorldsLimit();
                if (!notReachedWorldsLimit) break;
                Sounds.WORLD_GENERATION.play((Audience)this.player);
                this.player.closeInventory();
                WorldGenerator generator = WorldGenerators.getInstance().getById(this.generatorButton.getCurrentValue().toString());
                if (generator == null) {
                    return;
                }
                if (generator instanceof WorldTemplate) {
                    WorldTemplate template = (WorldTemplate)generator;
                    OpenCreative.getPlanetsManager().createPlanet(this.player, WorldUtils.generateWorldID(), template);
                    break;
                }
                World.Environment environment = World.Environment.valueOf((String)this.environmentButton.getCurrentValue().toString().toUpperCase());
                int seed = new Random().nextInt();
                boolean generateStructure = Boolean.parseBoolean(this.generateStructures.getCurrentValue().toString());
                OpenCreative.getPlanetsManager().createPlanet(this.player, WorldUtils.generateWorldID(), generator, environment, seed, generateStructure);
            }
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            WorldGenerationMenu.$$$reportNull$$$0(1);
        }
        Sounds.MENU_OPEN_GENERATION.play((Audience)this.player);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "ua/mcchickenstudio/opencreative/menus/world/WorldGenerationMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

