/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.world.browsers;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.Title;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.listeners.player.ChatListener;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.menus.world.browsers.OwnWorldsBrowserMenu;
import ua.mcchickenstudio.opencreative.menus.world.browsers.WorldsBrowserMenu;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerConfirmation;

public final class RecommendedWorldsMenu
extends AbstractMenu {
    private final int[] featuredWorldsSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
    private final ItemStack OWN_WORLDS = ItemUtils.createItem(Material.REPEATING_COMMAND_BLOCK, 1, "menus.all-worlds.items.own-worlds");
    private final ItemStack DECORATION_OWN_WORLDS = ItemUtils.createItem(Material.PURPLE_STAINED_GLASS_PANE, 1);
    private final ItemStack SEARCH = ItemUtils.createItem(Material.SPYGLASS, 1, "menus.all-worlds.items.search");
    private final ItemStack ALL_WORLDS = ItemUtils.createItem(Material.SPECTRAL_ARROW, 1, "menus.recommended-worlds.items.all-worlds");

    public RecommendedWorldsMenu() {
        super(6, MessageUtils.getLocaleMessage("menus.recommended-worlds.title", false));
    }

    @Override
    public void fillItems(Player player) {
        this.setItem(45, this.SEARCH);
        this.setItem(46, this.DECORATION_PANE_ITEM);
        this.setItem(47, this.DECORATION_OWN_WORLDS);
        this.setItem(49, this.OWN_WORLDS);
        this.setItem(51, this.DECORATION_OWN_WORLDS);
        this.setItem(52, this.DECORATION_PANE_ITEM);
        this.setItem(53, this.ALL_WORLDS);
        List<Planet> featuredPlanets = OpenCreative.getPlanetsManager().getRecommendedPlanets();
        if (featuredPlanets.isEmpty()) {
            for (int slot : this.featuredWorldsSlots) {
                this.setItem(slot, this.DECORATION_ITEM);
            }
            return;
        }
        Collections.shuffle(featuredPlanets);
        int index = 0;
        for (int slot : this.featuredWorldsSlots) {
            if (index < featuredPlanets.size()) {
                this.setItem(slot, featuredPlanets.get(index).getInformation().getIcon());
                ++index;
                continue;
            }
            this.setItem(slot, this.DECORATION_ITEM);
        }
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            RecommendedWorldsMenu.$$$reportNull$$$0(0);
        }
        if (!this.isClickedInMenuSlots(event) || !this.isPlayerClicked(event)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        ItemStack currentItem = event.getCurrentItem();
        event.setCancelled(true);
        if (currentItem == null) {
            return;
        }
        if (ItemUtils.itemEquals(currentItem, this.SEARCH)) {
            PlayerConfirmation request;
            switch (event.getClick()) {
                case LEFT: {
                    PlayerConfirmation playerConfirmation = PlayerConfirmation.FIND_PLANETS_BY_NAME;
                    break;
                }
                case RIGHT: 
                case SHIFT_RIGHT: {
                    PlayerConfirmation playerConfirmation = PlayerConfirmation.FIND_PLANETS_BY_ID;
                    break;
                }
                case SHIFT_LEFT: {
                    PlayerConfirmation playerConfirmation = PlayerConfirmation.FIND_PLANETS_BY_OWNER;
                    break;
                }
                default: {
                    PlayerConfirmation playerConfirmation = request = null;
                }
            }
            if (request == null) {
                return;
            }
            player.closeInventory();
            player.updateInventory();
            String searchQuery = request == PlayerConfirmation.FIND_PLANETS_BY_NAME ? "world-name" : (request == PlayerConfirmation.FIND_PLANETS_BY_ID ? "id" : "owner");
            player.showTitle(Title.title((Component)Component.text((String)MessageUtils.getLocaleMessage("menus.all-worlds.items.search.title").replace("%search%", MessageUtils.getLocaleMessage("menus.all-worlds.items.search." + searchQuery))), (Component)Component.text((String)MessageUtils.getLocaleMessage("menus.all-worlds.items.search.subtitle").replace("%search%", MessageUtils.getLocaleMessage("menus.all-worlds.items.search." + searchQuery))), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(750L), (Duration)Duration.ofSeconds(20L), (Duration)Duration.ofMillis(750L))));
            player.sendMessage(MessageUtils.getPlayerLocaleMessage("menus.all-worlds.items.search.usage", (OfflinePlayer)player).replace("%search%", MessageUtils.getLocaleMessage("menus.all-worlds.items.search." + searchQuery)));
            Sounds.MENU_WORLD_SEARCH.play((Audience)player);
            ChatListener.confirmation.put(player, request);
        } else if (ItemUtils.itemEquals(currentItem, this.ALL_WORLDS)) {
            new WorldsBrowserMenu(player, OpenCreative.getPlanetsManager().getPlanets()).open(player);
        } else if (ItemUtils.itemEquals(currentItem, this.OWN_WORLDS)) {
            new OwnWorldsBrowserMenu(player).open(player);
        } else if (!ItemUtils.itemEquals(currentItem, this.DECORATION_ITEM) && Arrays.stream(this.featuredWorldsSlots).anyMatch(i -> i == event.getRawSlot())) {
            String worldID = ItemUtils.getPersistentData(currentItem, ItemUtils.getItemIdKey());
            if (worldID.isEmpty()) {
                return;
            }
            Planet planet = OpenCreative.getPlanetsManager().getPlanetByCustomID(worldID);
            if (planet != null) {
                player.closeInventory();
                planet.connectPlayer(player);
            }
        }
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            RecommendedWorldsMenu.$$$reportNull$$$0(1);
        }
        Sounds.MENU_OPEN_RECOMMENDATIONS.play((Audience)event.getPlayer());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "ua/mcchickenstudio/opencreative/menus/world/browsers/RecommendedWorldsMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

