/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.world.browsers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.menus.ListBrowserMenu;
import ua.mcchickenstudio.opencreative.menus.buttons.ParameterButton;
import ua.mcchickenstudio.opencreative.menus.world.WorldModerationMenu;
import ua.mcchickenstudio.opencreative.menus.world.browsers.RecommendedWorldsMenu;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public class WorldsBrowserMenu
extends ListBrowserMenu<Planet> {
    private final List<Planet> planets;
    private final List<ParameterButton> buttons = new ArrayList<ParameterButton>();
    private final ItemStack RECOMMENDED;
    private int sortType = 1;

    public WorldsBrowserMenu(Player player, Set<Planet> planets) {
        super(player, MessageUtils.getLocaleMessage("menus.all-worlds.title", false), ListBrowserMenu.PlacementLayout.BOTTOM_NO_DECORATION, new int[]{45, 48, 50}, new int[]{45, 46, 52, 53});
        this.planets = new ArrayList<Planet>(planets);
        Comparator sortByOnline = (planet1, planet2) -> Integer.compare(planet2.getOnline(), planet1.getOnline());
        this.planets.sort(sortByOnline);
        this.RECOMMENDED = ItemUtils.createItem(Material.WIND_CHARGE, 1, "menus.all-worlds.items.recommended");
    }

    public WorldsBrowserMenu(Player player, Set<Planet> planets, boolean withRecommendedButton) {
        super(player, MessageUtils.getLocaleMessage("menus.all-worlds.title", false), ListBrowserMenu.PlacementLayout.BOTTOM_NO_DECORATION, new int[]{45, 48, 50}, new int[]{45, 46, 52, 53});
        this.planets = new ArrayList<Planet>(planets);
        Comparator sortByOnline = (planet1, planet2) -> Integer.compare(planet2.getOnline(), planet1.getOnline());
        this.planets.sort(sortByOnline);
        this.RECOMMENDED = withRecommendedButton ? ItemUtils.createItem(Material.WIND_CHARGE, 1, "menus.all-worlds.items.recommended") : this.DECORATION_ITEM;
    }

    @Override
    protected ItemStack getElementIcon(Planet planet) {
        return planet.getInformation().getIcon();
    }

    @Override
    protected void fillOtherItems() {
        ParameterButton sort = new ParameterButton((Object)"online", List.of("online", "likes", "last"), "sort", "menus.all-worlds", "menus.all-worlds.items.sort", List.of(Material.HOPPER, Material.GOLDEN_APPLE, Material.CLOCK));
        ParameterButton category = new ParameterButton((Object)"online", List.of("all", "sandbox", "adventure", "arcade", "roleplay", "simulator", "experiment", "story", "strategy"), "category", "menus.all-worlds", "menus.all-worlds.items.category", List.of(Material.CHERRY_CHEST_BOAT, Material.SANDSTONE, Material.DARK_PRISMARINE_STAIRS, Material.TARGET, Material.AXOLOTL_BUCKET, Material.CAMPFIRE, Material.TNT, Material.WRITABLE_BOOK, Material.CROSSBOW));
        this.buttons.add(sort);
        this.buttons.add(category);
        this.setItem(45, this.RECOMMENDED);
        this.setItem(47, ItemUtils.createItem(Material.CYAN_STAINED_GLASS_PANE, 1));
        this.setItem(48, category.getItem());
        this.setItem(50, sort.getItem());
        this.setItem(51, ItemUtils.createItem(Material.CYAN_STAINED_GLASS_PANE, 1));
    }

    @Override
    protected void onCharmsBarClick(InventoryClickEvent event) {
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        for (ParameterButton button : this.buttons) {
            if (!ItemUtils.itemEquals(item, button.getItem(true))) continue;
            if (event.getRawSlot() == 50) {
                button.next();
                this.sortType = button.getCurrentChoice();
                this.sortElements();
                this.fillElements(this.getCurrentPage());
                this.fillArrowsItems(this.getCurrentPage());
                this.setItem(50, button.getItem());
                Sounds.MENU_WORLDS_BROWSER_SORT.play((Audience)this.getPlayer());
                continue;
            }
            if (event.getRawSlot() != 48) continue;
            button.next();
            this.elements.clear();
            if (button.getCurrentValue().equals("all")) {
                this.elements.addAll(this.getElements());
            } else {
                this.elements.addAll(new ArrayList<Planet>(this.planets).stream().filter(planet -> planet.getInformation().getCategory().name().equalsIgnoreCase(button.getCurrentValue().toString())).toList());
            }
            this.sortElements();
            this.fillElements(this.getCurrentPage());
            this.fillArrowsItems(this.getCurrentPage());
            this.setItem(48, button.getItem());
            Sounds.MENU_WORLDS_BROWSER_CATEGORY.play((Audience)this.getPlayer());
        }
        if (ItemUtils.itemEquals(item, this.RECOMMENDED)) {
            new RecommendedWorldsMenu().open(this.getPlayer());
        }
    }

    @Override
    protected void onElementClick(InventoryClickEvent event) {
        ItemStack currentItem = event.getCurrentItem();
        event.setCancelled(true);
        if (currentItem == null) {
            return;
        }
        String worldID = ItemUtils.getPersistentData(currentItem, ItemUtils.getItemIdKey());
        if (worldID.isEmpty()) {
            return;
        }
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByCustomID(worldID);
        if (planet != null) {
            if (event.getClick() == ClickType.SHIFT_LEFT) {
                if (!this.getPlayer().hasPermission("opencreative.moderation.menus")) {
                    this.onPlanetClick(this.getPlayer(), planet);
                    return;
                }
                new WorldModerationMenu(planet).open(this.getPlayer());
            } else {
                this.onPlanetClick(this.getPlayer(), planet);
            }
        }
    }

    protected void onPlanetClick(Player player, Planet planet) {
        player.closeInventory();
        planet.connectPlayer(player);
    }

    @Override
    protected void fillArrowsItems(int currentPage) {
        if (this.elements.isEmpty()) {
            this.setItem(this.getNoElementsPageButtonSlot(), this.getNoElementsButton());
            this.setItem(this.getPreviousPageButtonSlot(), this.RECOMMENDED);
            this.setItem(this.getNextPageButtonSlot(), this.DECORATION_ITEM);
        } else {
            int maxPagesAmount = this.getPages();
            if (currentPage > maxPagesAmount || currentPage < 1) {
                currentPage = 1;
            }
            this.setItem(this.getPreviousPageButtonSlot(), currentPage > 1 ? this.getPreviousPageButton() : this.RECOMMENDED);
            this.setItem(this.getNextPageButtonSlot(), currentPage < maxPagesAmount ? this.getNextPageButton() : this.DECORATION_ITEM);
        }
    }

    private void sortElements() {
        Comparator planetComparator = switch (this.sortType) {
            case 2 -> (planet1, planet2) -> Integer.compare(((Planet)planet2).getInformation().getReputation(), ((Planet)planet1).getInformation().getReputation());
            case 3 -> (planet1, planet2) -> Long.compare(((Planet)planet2).getCreationTime(), ((Planet)planet1).getCreationTime());
            default -> (planet1, planet2) -> Integer.compare(((Planet)planet2).getOnline(), ((Planet)planet1).getOnline());
        };
        this.elements.sort(planetComparator);
    }

    @Override
    public List<Planet> getElements() {
        return new ArrayList<Planet>(this.planets);
    }

    @Override
    protected ItemStack getNextPageButton() {
        return ItemUtils.replacePlaceholderInLore(ItemUtils.createItem(Material.SPECTRAL_ARROW, this.getCurrentPage() + 1, "menus.all-worlds.items.next-page"), "%page%", this.getCurrentPage() + 1);
    }

    @Override
    protected ItemStack getPreviousPageButton() {
        return ItemUtils.replacePlaceholderInLore(ItemUtils.createItem(Material.SPECTRAL_ARROW, Math.max(1, this.getCurrentPage() - 1), "menus.all-worlds.items.previous-page"), "%page%", this.getCurrentPage() - 1);
    }

    @Override
    protected ItemStack getNoElementsButton() {
        return ItemUtils.createItem(Material.BARRIER, 1, "menus.all-worlds.items.no-worlds");
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            WorldsBrowserMenu.$$$reportNull$$$0(0);
        }
        Sounds.MENU_OPEN_WORLDS_BROWSER.play((Audience)event.getPlayer());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "ua/mcchickenstudio/opencreative/menus/world/browsers/WorldsBrowserMenu", "onOpen"));
    }
}

