/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.world.browsers;

import java.io.File;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.menus.world.browsers.WorldsBrowserMenu;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;

public final class WorldsPickerMenu
extends WorldsBrowserMenu {
    public WorldsPickerMenu(Player player, Set<Planet> planets) {
        super(player, planets, false);
    }

    @Override
    protected void onPlanetClick(Player player, Planet downloadablePlanet) {
        if (downloadablePlanet.getInformation().isDownloadable()) {
            int id = WorldUtils.generateWorldID();
            FileUtils.copyFilesToDirectory(FileUtils.getPlanetFolder(downloadablePlanet), new File(Bukkit.getWorldContainer().getPath() + File.separator + "planets" + File.separator + "planet" + id));
            if (downloadablePlanet.getDevPlanet().exists()) {
                FileUtils.copyFilesToDirectory(FileUtils.getDevPlanetFolder(downloadablePlanet.getDevPlanet()), new File(Bukkit.getWorldContainer().getPath() + File.separator + "planets" + File.separator + "planet" + id + "dev"));
            }
            Planet newPlanet = new Planet(id);
            FileUtils.setPlanetConfigParameter(newPlanet, "creation-time", System.currentTimeMillis());
            newPlanet.setOwner(player.getName());
            newPlanet.getInformation().setCustomID(String.valueOf(id));
            newPlanet.getInformation().setDownloadable(false);
            newPlanet.getWorldPlayers().purgeData();
            OpenCreative.getPlanetsManager().registerPlanet(newPlanet);
            FileUtils.deleteFolder(new File(FileUtils.getPlanetFolder(newPlanet).getPath() + File.separator + "playersData"));
            FileUtils.deleteUnnecessaryWorldFiles(FileUtils.getPlanetFolder(newPlanet));
            newPlanet.connectPlayer(player);
        }
    }
}

