/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.world.settings;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.menus.ListBrowserMenu;
import ua.mcchickenstudio.opencreative.menus.buttons.ParameterButton;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldSettingsMenu;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class EntitiesBrowserMenu
extends ListBrowserMenu<Entity> {
    private final Planet planet;
    private final List<ParameterButton> buttons = new ArrayList<ParameterButton>();
    private final ItemStack REMOVE_ALL = ItemUtils.createItem(Material.BARRIER, 1, "menus.entities-browser.items.remove-all");
    private final ItemStack BACK_TO_SETTINGS = ItemUtils.createItem(Material.SPECTRAL_ARROW, 1, "menus.entities-browser.items.back");

    public EntitiesBrowserMenu(Player player, Planet planet) {
        super(player, MessageUtils.getLocaleMessage("menus.entities-browser.title", false), ListBrowserMenu.PlacementLayout.BOTTOM_NO_DECORATION, new int[]{45, 48, 50}, new int[]{46, 52});
        this.planet = planet;
    }

    @Override
    protected ItemStack getElementIcon(Entity object) {
        if (object instanceof Entity) {
            Entity entity = object;
            return this.createEntityItem(entity);
        }
        return null;
    }

    private ItemStack createEntityItem(Entity entity) {
        ItemStack item = ItemUtils.createItem(this.getEntityMaterial(entity), 1, "menus.entities-browser.items.entity");
        ItemUtils.replacePlaceholderInLore(item, "%name%", entity.getName().substring(0, Math.min(20, entity.getName().length())));
        ItemUtils.replacePlaceholderInLore(item, "%type%", WordUtils.capitalize((String)entity.getType().name().toLowerCase().replace('_', ' ')));
        ItemUtils.replacePlaceholderInLore(item, "%x%", entity.getLocation().getBlockX());
        ItemUtils.replacePlaceholderInLore(item, "%y%", entity.getLocation().getBlockY());
        ItemUtils.replacePlaceholderInLore(item, "%z%", entity.getLocation().getBlockZ());
        ItemUtils.setPersistentData(item, ItemUtils.getItemTypeKey(), entity.getUniqueId().toString());
        return item;
    }

    private Material getEntityMaterial(Entity entity) {
        Material material = Material.getMaterial((String)entity.getType().name());
        if (material == null && entity.getType().isAlive()) {
            material = Material.getMaterial((String)(entity.getType().name() + "_SPAWN_EGG"));
        } else {
            if (entity instanceof Item) {
                Item item = (Item)entity;
                return item.getItemStack().getType();
            }
            if (entity instanceof ItemDisplay) {
                ItemDisplay item = (ItemDisplay)entity;
                return item.getItemStack().getType();
            }
        }
        return material != null ? material : Material.HEAVY_CORE;
    }

    @Override
    protected void fillOtherItems() {
        ParameterButton type = new ParameterButton((Object)"all", List.of("all", "friendly", "monsters", "items", "transport", "decoration", "not-living"), "type", "menus.all-worlds", "menus.entities-browser.items.type", List.of(Material.HOPPER, Material.PIGLIN_HEAD, Material.ZOMBIE_HEAD, Material.POISONOUS_POTATO, Material.BIRCH_CHEST_BOAT, Material.PAINTING, Material.PUMPKIN_SEEDS));
        this.buttons.add(type);
        this.setItem(47, ItemUtils.createItem(Material.RED_STAINED_GLASS_PANE, 1));
        this.setItem(48, type.getItem());
        this.setItem(50, this.REMOVE_ALL);
        this.setItem(51, ItemUtils.createItem(Material.RED_STAINED_GLASS_PANE, 1));
    }

    @Override
    protected void onCharmsBarClick(InventoryClickEvent event) {
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (item == null) {
            return;
        }
        for (ParameterButton button : this.buttons) {
            if (!ItemUtils.itemEquals(item, button.getItem(true)) || event.getRawSlot() != 48) continue;
            button.next();
            this.elements.clear();
            switch (button.getCurrentChoice()) {
                case 2: {
                    this.elements.addAll(new ArrayList<Entity>(this.getElements()).stream().filter(entity -> entity instanceof LivingEntity && !(entity instanceof Monster)).toList());
                    break;
                }
                case 3: {
                    this.elements.addAll(new ArrayList<Entity>(this.getElements()).stream().filter(entity -> entity instanceof Enemy).toList());
                    break;
                }
                case 4: {
                    this.elements.addAll(new ArrayList<Entity>(this.getElements()).stream().filter(entity -> entity instanceof Item).toList());
                    break;
                }
                case 5: {
                    this.elements.addAll(new ArrayList<Entity>(this.getElements()).stream().filter(entity -> entity instanceof Vehicle).toList());
                    break;
                }
                case 6: {
                    this.elements.addAll(new ArrayList<Entity>(this.getElements()).stream().filter(entity -> entity instanceof Painting || entity instanceof ArmorStand || entity instanceof TextDisplay || entity instanceof ItemDisplay || entity instanceof BlockDisplay || entity instanceof ItemFrame).toList());
                    break;
                }
                case 7: {
                    this.elements.addAll(new ArrayList<Entity>(this.getElements()).stream().filter(entity -> !(entity instanceof LivingEntity)).toList());
                    break;
                }
                default: {
                    this.elements.addAll(this.getElements());
                }
            }
            this.fillElements(this.getCurrentPage());
            this.fillArrowsItems(this.getCurrentPage());
            this.setItem(48, button.getItem());
            Sounds.MENU_ENTITIES_BROWSER_SORT.play((Audience)this.getPlayer());
            return;
        }
        if (ItemUtils.itemEquals(item, this.BACK_TO_SETTINGS) && this.planet.isOwner(this.getPlayer())) {
            new WorldSettingsMenu(this.planet, this.getPlayer()).open(this.getPlayer());
        } else if (ItemUtils.itemEquals(item, this.REMOVE_ALL)) {
            if (this.elements.isEmpty()) {
                return;
            }
            int count = this.elements.size();
            for (Entity element : new ArrayList(this.elements)) {
                if (!(element instanceof Entity)) continue;
                Entity entity2 = element;
                this.elements.remove(entity2);
                entity2.remove();
            }
            for (Player p : this.planet.getPlayers()) {
                if (!this.planet.getWorldPlayers().canBuild(p)) continue;
                p.sendMessage(MessageUtils.getPlayerLocaleMessage("menus.entities-browser.removed-all", (OfflinePlayer)this.getPlayer()).replace("%count%", String.valueOf(count)));
            }
            this.elements.removeIf(Entity::isDead);
            this.fillElements(this.getCurrentPage());
            this.fillArrowsItems(this.getCurrentPage());
        }
    }

    @Override
    protected void onElementClick(InventoryClickEvent event) {
        ItemStack currentItem = event.getCurrentItem();
        event.setCancelled(true);
        if (currentItem == null) {
            return;
        }
        if (!this.planet.isLoaded() || !this.planet.getWorldPlayers().canBuild(this.getPlayer())) {
            this.getPlayer().closeInventory();
            return;
        }
        String uuidString = ItemUtils.getItemType(currentItem);
        if (uuidString.isEmpty()) {
            return;
        }
        UUID uuid = UUID.fromString(uuidString);
        Entity entity = Bukkit.getEntity((UUID)uuid);
        if (entity == null) {
            this.elements.removeIf(e -> e.getUniqueId().equals(uuid));
            this.elements.removeIf(Entity::isDead);
            this.fillElements(this.getCurrentPage());
            this.fillArrowsItems(this.getCurrentPage());
            return;
        }
        switch (event.getClick()) {
            case LEFT: {
                if (PlayerUtils.isEntityInDevPlanet((Entity)this.getPlayer())) {
                    Sounds.PLAYER_FAIL.play((Audience)this.getPlayer());
                    return;
                }
                this.getPlayer().closeInventory();
                Sounds.WORLD_TELEPORT_TO_ENTITY.play((Audience)this.getPlayer());
                this.getPlayer().teleport(entity.getLocation());
                break;
            }
            case RIGHT: {
                if (PlayerUtils.isEntityInDevPlanet((Entity)this.getPlayer())) {
                    Sounds.PLAYER_FAIL.play((Audience)this.getPlayer());
                    return;
                }
                Sounds.WORLD_TELEPORT_ENTITY_TO_ME.play((Audience)this.getPlayer());
                entity.teleport(this.getPlayer().getLocation());
                if (!this.elements.removeIf(Entity::isDead)) break;
                this.fillElements(this.getCurrentPage());
                this.fillArrowsItems(this.getCurrentPage());
                break;
            }
            case SHIFT_LEFT: {
                for (Player p : this.planet.getPlayers()) {
                    if (!this.planet.getWorldPlayers().canBuild(p)) continue;
                    p.sendMessage(MessageUtils.getPlayerLocaleMessage("menus.entities-browser.removed", (OfflinePlayer)this.getPlayer()).replace("%name%", entity.getName().substring(0, Math.min(20, entity.getName().length()))).replace("%x%", String.valueOf(entity.getLocation().getBlockX())).replace("%y%", String.valueOf(entity.getLocation().getBlockY())).replace("%z%", String.valueOf(entity.getLocation().getBlockZ())));
                }
                Sounds.WORLD_REMOVE_ENTITY.play((Audience)this.getPlayer());
                this.elements.remove(entity);
                entity.remove();
                this.elements.removeIf(Entity::isDead);
                this.fillElements(this.getCurrentPage());
                this.fillArrowsItems(this.getCurrentPage());
                this.getPlayer().updateInventory();
            }
        }
    }

    @Override
    protected void fillArrowsItems(int currentPage) {
        if (this.elements.isEmpty()) {
            this.setItem(this.getNoElementsPageButtonSlot(), this.getNoElementsButton());
            this.setItem(this.getPreviousPageButtonSlot(), this.planet.isOwner(this.getPlayer()) ? this.BACK_TO_SETTINGS : this.DECORATION_ITEM);
            this.setItem(this.getNextPageButtonSlot(), this.DECORATION_ITEM);
            this.setItem(50, this.DECORATION_ITEM);
        } else {
            int maxPagesAmount = this.getPages();
            if (currentPage > maxPagesAmount || currentPage < 1) {
                this.setCurrentPage(1);
            }
            this.setItem(this.getPreviousPageButtonSlot(), currentPage > 1 ? this.getPreviousPageButton() : (this.planet.isOwner(this.getPlayer()) ? this.BACK_TO_SETTINGS : this.DECORATION_ITEM));
            this.setItem(this.getNextPageButtonSlot(), currentPage < maxPagesAmount ? this.getNextPageButton() : this.DECORATION_ITEM);
            this.setItem(50, this.REMOVE_ALL);
        }
    }

    @Override
    public List<Entity> getElements() {
        if (!this.planet.isLoaded()) {
            return List.of();
        }
        ArrayList<Entity> entities = new ArrayList<Entity>(this.planet.getTerritory().getWorld().getEntities().stream().filter(e -> !(e instanceof Player)).toList());
        entities.sort(Comparator.comparingInt(Entity::getTicksLived).reversed());
        return new ArrayList<Entity>(entities);
    }

    @Override
    protected ItemStack getNextPageButton() {
        return ItemUtils.replacePlaceholderInLore(ItemUtils.createItem(Material.ARROW, this.getCurrentPage() + 1, "menus.entities-browser.items.next-page"), "%page%", this.getCurrentPage() + 1);
    }

    @Override
    protected ItemStack getPreviousPageButton() {
        return ItemUtils.replacePlaceholderInLore(ItemUtils.createItem(Material.SPECTRAL_ARROW, Math.max(1, this.getCurrentPage() - 1), "menus.entities-browser.items.previous-page"), "%page%", this.getCurrentPage() - 1);
    }

    @Override
    protected ItemStack getNoElementsButton() {
        return ItemUtils.createItem(Material.BARRIER, 1, "menus.entities-browser.items.no-entities");
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            EntitiesBrowserMenu.$$$reportNull$$$0(0);
        }
        Sounds.MENU_OPEN_ENTITIES_BROWSER.play((Audience)this.getPlayer());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "ua/mcchickenstudio/opencreative/menus/world/settings/EntitiesBrowserMenu", "onOpen"));
    }
}

