/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.world.settings;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.menus.AbstractListMenu;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldEnvironmentMenu;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.DevPlatform;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public final class WorldEnvironmentColorMenu
extends AbstractListMenu<Material> {
    private final Set<Material> materials = new HashSet<Material>();
    private final String type;
    private final Material currentMaterial;
    private final DevPlanet devPlanet;
    private final DevPlatform platform;

    public WorldEnvironmentColorMenu(Player player, DevPlanet devPlanet, DevPlatform devPlatform, String type) {
        super(player, MessageUtils.getLocaleMessage("menus.developer.environment.colors.title"), new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25}, new int[]{36}, new int[]{37, 38, 42, 43, 44});
        this.devPlanet = devPlanet;
        this.platform = devPlatform;
        this.type = type;
        this.setRows(5);
        this.materials.add(Material.RED_STAINED_GLASS);
        this.materials.add(Material.ORANGE_STAINED_GLASS);
        this.materials.add(Material.YELLOW_STAINED_GLASS);
        this.materials.add(Material.LIME_STAINED_GLASS);
        this.materials.add(Material.GREEN_STAINED_GLASS);
        this.materials.add(Material.PURPLE_STAINED_GLASS);
        this.materials.add(Material.MAGENTA_STAINED_GLASS);
        this.materials.add(Material.PINK_STAINED_GLASS);
        this.materials.add(Material.BLUE_STAINED_GLASS);
        this.materials.add(Material.CYAN_STAINED_GLASS);
        this.materials.add(Material.LIGHT_BLUE_STAINED_GLASS);
        this.materials.add(Material.BLACK_STAINED_GLASS);
        this.materials.add(Material.GRAY_STAINED_GLASS);
        this.materials.add(Material.LIGHT_GRAY_STAINED_GLASS);
        this.materials.add(Material.WHITE_STAINED_GLASS);
        this.materials.add(Material.GLASS);
        this.materials.add(Material.BARRIER);
        if (devPlatform == null) {
            devPlatform = new DevPlatform(devPlanet, 1, 1);
        }
        switch (type.toLowerCase()) {
            case "floor": {
                this.currentMaterial = devPlatform.getFloorMaterial();
                this.materials.remove(devPlatform.getActionMaterial());
                this.materials.remove(devPlatform.getEventMaterial());
                break;
            }
            case "event": {
                this.currentMaterial = devPlatform.getEventMaterial();
                this.materials.remove(devPlatform.getActionMaterial());
                this.materials.remove(devPlatform.getFloorMaterial());
                break;
            }
            default: {
                this.currentMaterial = devPlatform.getActionMaterial();
                this.materials.remove(devPlatform.getEventMaterial());
                this.materials.remove(devPlatform.getFloorMaterial());
            }
        }
        this.materials.remove(this.currentMaterial);
    }

    @Override
    protected ItemStack getElementIcon(Material material) {
        return new ItemStack(material, 1);
    }

    @Override
    protected void fillOtherItems() {
        this.setItem(36, ItemUtils.createItem(Material.ARROW, 1, "menus.developer.environment.items.back"));
        this.setItem(40, ItemUtils.createItem(this.currentMaterial, 1));
    }

    @Override
    protected void onCharmsBarClick(InventoryClickEvent event) {
        new WorldEnvironmentMenu(this.getPlayer(), this.devPlanet).open(this.getPlayer());
    }

    @Override
    protected void onElementClick(InventoryClickEvent event) {
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem == null) {
            return;
        }
        Material material = currentItem.getType();
        if (this.devPlanet != null && this.devPlanet.isLoaded() && this.devPlanet.getPlanet().getWorldPlayers().canDevelop(this.getPlayer())) {
            switch (this.type.toLowerCase()) {
                case "floor": {
                    if (this.platform == null) {
                        for (DevPlatform p : this.devPlanet.getPlatforms()) {
                            p.setFloorMaterial(material);
                        }
                    } else {
                        this.platform.setFloorMaterial(material);
                    }
                    Sounds.DEV_PLATFORM_COLOR.play((Audience)this.getPlayer());
                    break;
                }
                case "event": {
                    if (this.platform == null) {
                        for (DevPlatform p : this.devPlanet.getPlatforms()) {
                            p.setEventMaterial(material);
                        }
                    } else {
                        this.platform.setEventMaterial(material);
                    }
                    Sounds.DEV_PLATFORM_COLOR.play((Audience)this.getPlayer());
                    break;
                }
                case "action": {
                    if (this.platform == null) {
                        for (DevPlatform p : this.devPlanet.getPlatforms()) {
                            p.setActionMaterial(material);
                        }
                    } else {
                        this.platform.setActionMaterial(material);
                    }
                    Sounds.DEV_PLATFORM_COLOR.play((Audience)this.getPlayer());
                }
            }
        }
        this.getPlayer().closeInventory();
    }

    @Override
    protected List<Material> getElements() {
        return new ArrayList<Material>(this.materials);
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            WorldEnvironmentColorMenu.$$$reportNull$$$0(0);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "ua/mcchickenstudio/opencreative/menus/world/settings/WorldEnvironmentColorMenu", "onOpen"));
    }
}

