/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.world.settings;

import net.kyori.adventure.audience.Audience;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.menus.AbstractMenu;
import ua.mcchickenstudio.opencreative.menus.world.settings.WorldSettingsMenu;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.planets.PlanetInfo;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public final class WorldSettingsCategoryMenu
extends AbstractMenu {
    private final PlanetInfo.Category currentCategory;
    private final ItemStack BACK_ITEM = ItemUtils.createItem(Material.SPECTRAL_ARROW, 1, "menus.world-settings-categories.items.back");

    public WorldSettingsCategoryMenu(PlanetInfo.Category currentCategory) {
        super(6, MessageUtils.getLocaleMessage("menus.world-settings.title"));
        this.currentCategory = currentCategory;
    }

    @Override
    public void fillItems(Player player) {
        this.setItem(10, this.createButton(PlanetInfo.Category.SANDBOX));
        this.setItem(12, this.createButton(PlanetInfo.Category.ADVENTURE));
        this.setItem(14, this.createButton(PlanetInfo.Category.STRATEGY));
        this.setItem(16, this.createButton(PlanetInfo.Category.ARCADE));
        this.setItem(28, this.createButton(PlanetInfo.Category.ROLEPLAY));
        this.setItem(30, this.createButton(PlanetInfo.Category.STORY));
        this.setItem(32, this.createButton(PlanetInfo.Category.SIMULATOR));
        this.setItem(34, this.createButton(PlanetInfo.Category.EXPERIMENT));
        this.setItem(45, this.BACK_ITEM);
        this.setItem(46, this.DECORATION_PANE_ITEM);
        this.setItem(47, ItemUtils.createItem(Material.GREEN_STAINED_GLASS_PANE, 1));
        this.setItem(49, ItemUtils.setPersistentData(ItemUtils.createItem(this.currentCategory.getMaterial(), 1, "menus.world-settings-categories.items." + this.currentCategory.name().toLowerCase()), ItemUtils.getItemTypeKey(), this.currentCategory.name()));
        this.setItem(51, ItemUtils.createItem(Material.GREEN_STAINED_GLASS_PANE, 1));
        this.setItem(52, this.DECORATION_PANE_ITEM);
        this.setItem(53, this.DECORATION_PANE_ITEM);
    }

    @Override
    public void onClick(@NotNull InventoryClickEvent event) {
        if (event == null) {
            WorldSettingsCategoryMenu.$$$reportNull$$$0(0);
        }
        event.setCancelled(true);
        if (!this.isPlayerClicked(event)) {
            return;
        }
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer((Player)event.getWhoClicked());
        if (planet == null) {
            return;
        }
        if (!planet.isOwner(event.getWhoClicked().getName())) {
            return;
        }
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (!ItemUtils.itemEquals(event.getCurrentItem(), this.BACK_ITEM)) {
            String categoryString = ItemUtils.getPersistentData(event.getCurrentItem(), ItemUtils.getItemTypeKey());
            if (categoryString.isEmpty()) {
                return;
            }
            try {
                PlanetInfo.Category category = PlanetInfo.Category.valueOf(categoryString);
                planet.getInformation().setCategory(category);
                event.getWhoClicked().sendMessage(MessageUtils.getLocaleMessage("settings.world-category.changed").replace("%category%", category.getLocaleName()));
            }
            catch (IllegalArgumentException ignored) {
                return;
            }
            event.getWhoClicked().closeInventory();
            Sounds.WORLD_SETTINGS_CATEGORY_SET.play((Audience)event.getWhoClicked());
        } else {
            new WorldSettingsMenu(planet, (Player)event.getWhoClicked()).open((Player)event.getWhoClicked());
        }
    }

    private ItemStack createButton(PlanetInfo.Category category) {
        if (category == this.currentCategory) {
            return this.DECORATION_ITEM;
        }
        return ItemUtils.setPersistentData(ItemUtils.createItem(category.getMaterial(), 1, "menus.world-settings-categories.items." + category.name().toLowerCase()), ItemUtils.getItemTypeKey(), category.name());
    }

    @Override
    public void onOpen(@NotNull InventoryOpenEvent event) {
        if (event == null) {
            WorldSettingsCategoryMenu.$$$reportNull$$$0(1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "event";
        objectArray2[1] = "ua/mcchickenstudio/opencreative/menus/world/settings/WorldSettingsCategoryMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onClick";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onOpen";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

