/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.menus.world.settings;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.menus.LegacyMenu;
import ua.mcchickenstudio.opencreative.menus.buttons.RadioButton;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public final class WorldSettingsPlayersMenu
extends LegacyMenu {
    private final Player player;
    public static final Map<Player, String> playersSelected = new HashMap<Player, String>();
    public static final Map<Player, Integer> openedPage = new HashMap<Player, Integer>();
    public static final Map<Player, List<String>> currentPlayersList = new HashMap<Player, List<String>>();
    public final int[] decorationSlots = new int[]{18, 19, 20, 21, 22, 23, 24, 25, 26};
    public static final int[] playerSlots = new int[]{29, 30, 31, 32, 33, 38, 39, 40, 41, 42};

    public WorldSettingsPlayersMenu(Player player, int page) {
        super(6, MessageUtils.getLocaleMessage("menus.world-settings-players.title"));
        this.player = player;
        HashMap<Integer, ItemStack> items = new HashMap<Integer, ItemStack>();
        Planet planet = OpenCreative.getPlanetsManager().getPlanetByPlayer(player);
        for (int slot : this.decorationSlots) {
            ItemStack decorationItem = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
            ItemMeta meta = decorationItem.getItemMeta();
            meta.setDisplayName(" ");
            decorationItem.setItemMeta(meta);
            items.put(slot, decorationItem);
        }
        items.put(10, this.getPlayerButton(planet));
        items.put(12, this.getFlyButton(planet));
        items.put(13, this.getBuildButton(planet));
        items.put(14, this.getDevButton(planet));
        items.put(15, this.getKickButton(planet));
        items.put(16, this.getBanButton(planet));
        items.put(5, this.getWhiteListButton(planet));
        items.put(6, this.getTransferOwnershipButton(planet));
        Set<String> playersList = planet.getWorldPlayers().getAllPlayersFromConfig();
        if (playersList == null || playersList.isEmpty()) {
            ItemStack noPlayersButton = this.getNoPlayersButton();
            items.put(31, noPlayersButton);
        } else {
            int slot;
            List<List<String>> allPages = WorldSettingsPlayersMenu.getPagesForPlayers(playersList);
            int pageToOpen = page;
            if (page > allPages.size() || page < 1) {
                pageToOpen = 1;
            }
            if (pageToOpen > 1) {
                items.put(46, WorldSettingsPlayersMenu.getPreviousPageButton(page));
            }
            if (pageToOpen < allPages.size()) {
                items.put(52, WorldSettingsPlayersMenu.getNextPageButton(page));
            }
            slot = 0;
            for (String planetPlayer : allPages.get(pageToOpen - 1)) {
                Material material = Material.PLAYER_HEAD;
                ItemStack item = new ItemStack(material);
                ItemMeta meta = item.getItemMeta();
                SkullMeta skullMeta = (SkullMeta)meta;
                skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)planetPlayer));
                skullMeta.setDisplayName(MessageUtils.getLocaleItemName("menus.world-settings-players.items.player.name").replace("%player%", planetPlayer));
                ArrayList<String> lore = new ArrayList<String>();
                for (String loreLine : MessageUtils.getLocaleItemDescription("menus.world-settings-players.items.player.lore")) {
                    String build = MessageUtils.getLocaleMessage("menus.world-settings-players.items.build.choices.1");
                    String dev = MessageUtils.getLocaleMessage("menus.world-settings-players.items.dev.choices.1");
                    String fly = MessageUtils.getLocaleMessage("menus.world-settings-players.items.fly.choices.1");
                    String online = MessageUtils.getLocaleMessage("menus.world-settings-players.not-in-world");
                    if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.BUILDERS_TRUSTED).contains(planetPlayer)) {
                        build = MessageUtils.getLocaleMessage("menus.world-settings-players.items.build.choices.3");
                    } else if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.BUILDERS_NOT_TRUSTED).contains(planetPlayer)) {
                        build = MessageUtils.getLocaleMessage("menus.world-settings-players.items.build.choices.2");
                    }
                    if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.DEVELOPERS_TRUSTED).contains(planetPlayer)) {
                        dev = MessageUtils.getLocaleMessage("menus.world-settings-players.items.dev.choices.3");
                    } else if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.DEVELOPERS_NOT_TRUSTED).contains(planetPlayer)) {
                        dev = MessageUtils.getLocaleMessage("menus.world-settings-players.items.dev.choices.2");
                    }
                    Player planetPlayer_ = Bukkit.getPlayer((String)planetPlayer);
                    if (planetPlayer_ != null) {
                        if (OpenCreative.getPlanetsManager().getPlanetByPlayer(planetPlayer_) == planet) {
                            online = MessageUtils.getLocaleMessage("menus.world-settings-players.in-world");
                        }
                        if (planetPlayer_.isFlying()) {
                            fly = MessageUtils.getLocaleMessage("menus.world-settings-players.items.fly.choices.2");
                        }
                    }
                    if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.DEVELOPERS_TRUSTED).contains(planetPlayer)) {
                        dev = MessageUtils.getLocaleMessage("menus.world-settings-players.items.dev.choices.3");
                    } else if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.DEVELOPERS_NOT_TRUSTED).contains(planetPlayer)) {
                        dev = MessageUtils.getLocaleMessage("menus.world-settings-players.items.dev.choices.2");
                    }
                    lore.add(MessageUtils.parsePAPI(Bukkit.getOfflinePlayer((String)planetPlayer), loreLine).replace("%build%", build).replace("%dev%", dev).replace("%fly%", fly).replace("%online%", online));
                }
                skullMeta.setLore(lore);
                item.setItemMeta((ItemMeta)skullMeta);
                items.put(playerSlots[slot], item);
                ++slot;
            }
            if (pageToOpen > 1) {
                this.setTitle(MessageUtils.getLocaleMessage("menus.all-worlds.title-pages", false).replace("%page%", String.valueOf(pageToOpen)).replace("%pages%", String.valueOf(allPages.size())));
            }
            openedPage.put(player, pageToOpen);
            currentPlayersList.put(player, new ArrayList<String>(playersList));
        }
        this.setItems(items);
    }

    public static void openInventory(Player player) {
        player.closeInventory();
        player.openInventory(new WorldSettingsPlayersMenu(player, 1).getInventory());
    }

    public static void openInventory(Player player, int page) {
        player.closeInventory();
        player.openInventory(new WorldSettingsPlayersMenu(player, page).getInventory());
    }

    public static ItemStack getNextPageButton(int page) {
        ItemStack item = new ItemStack(Material.SPECTRAL_ARROW);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(MessageUtils.getLocaleItemName("menus.world-settings-players.items.next-page.name").replace("%page%", String.valueOf(page)));
        meta.setLore(MessageUtils.getLocaleItemDescription("menus.world-settings-players.items.next-page.lore"));
        item.setAmount(page);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack getPreviousPageButton(int page) {
        ItemStack item = new ItemStack(Material.ARROW);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(MessageUtils.getLocaleItemName("menus.world-settings-players.items.previous-page.name").replace("%page%", String.valueOf(page - 1)));
        meta.setLore(MessageUtils.getLocaleItemDescription("menus.world-settings-players.items.previous-page.lore"));
        item.setAmount(page - 1);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack getNoPlayersButton() {
        ItemStack item = new ItemStack(Material.BARRIER);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(MessageUtils.getLocaleItemName("menus.world-settings-players.items.no-players.name"));
        meta.setLore(MessageUtils.getLocaleItemDescription("menus.world-settings-players.items.no-players.lore"));
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        item.setItemMeta(meta);
        item.addUnsafeEnchantment(Enchantment.LURE, 1);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack getBanButton(Planet planet) {
        ItemStack item;
        if (playersSelected.get(this.player) == null) {
            return null;
        }
        String planetPlayer = playersSelected.get(this.player);
        if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.BLACKLISTED).contains(planetPlayer)) {
            item = new ItemStack(Material.STRUCTURE_VOID);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(MessageUtils.getLocaleItemName("menus.world-settings-players.items.unban.name"));
            meta.setLore(MessageUtils.getLocaleItemDescription("menus.world-settings-players.items.unban.lore"));
            item.setItemMeta(meta);
        } else {
            item = new ItemStack(Material.BARRIER);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(MessageUtils.getLocaleItemName("menus.world-settings-players.items.ban.name"));
            meta.setLore(MessageUtils.getLocaleItemDescription("menus.world-settings-players.items.ban.lore"));
            item.setItemMeta(meta);
        }
        return item;
    }

    public ItemStack getWhiteListButton(Planet planet) {
        ItemStack item;
        if (playersSelected.get(this.player) == null) {
            return null;
        }
        String planetPlayer = playersSelected.get(this.player);
        if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.WHITELISTED).contains(planetPlayer)) {
            item = new ItemStack(Material.FILLED_MAP);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(MessageUtils.getLocaleItemName("menus.world-settings-players.items.whitelist-remove.name"));
            meta.setLore(MessageUtils.getLocaleItemDescription("menus.world-settings-players.items.whitelist-remove.lore"));
            item.setItemMeta(meta);
        } else {
            item = new ItemStack(Material.PAPER);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(MessageUtils.getLocaleItemName("menus.world-settings-players.items.whitelist.name"));
            meta.setLore(MessageUtils.getLocaleItemDescription("menus.world-settings-players.items.whitelist.lore"));
            item.setItemMeta(meta);
        }
        return item;
    }

    public ItemStack getKickButton(Planet planet) {
        if (playersSelected.get(this.player) == null) {
            return null;
        }
        String nickname = playersSelected.get(this.player);
        Player player = Bukkit.getPlayer((String)nickname);
        if (player != null && OpenCreative.getPlanetsManager().getPlanetByPlayer(player) == planet) {
            ItemStack item = new ItemStack(Material.STRUCTURE_VOID);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(MessageUtils.getLocaleItemName("menus.world-settings-players.items.kick.name"));
            meta.setLore(MessageUtils.getLocaleItemDescription("menus.world-settings-players.items.kick.lore"));
            item.setItemMeta(meta);
            return item;
        }
        return null;
    }

    public ItemStack getTransferOwnershipButton(Planet planet) {
        if (playersSelected.get(this.player) == null) {
            return null;
        }
        String planetPlayer = playersSelected.get(this.player);
        if (Bukkit.getPlayer((String)planetPlayer) == null) {
            return null;
        }
        if (planet.getPlayers().contains(Bukkit.getPlayer((String)planetPlayer)) && FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.BUILDERS_TRUSTED).contains(planetPlayer) && FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.DEVELOPERS_TRUSTED).contains(planetPlayer) && !planet.isChangingOwner()) {
            return ItemUtils.createItem(Material.ENCHANTED_GOLDEN_APPLE, 1, "menus.world-settings-players.items.transfer-ownership");
        }
        return null;
    }

    public ItemStack getFlyButton(Planet planet) {
        if (playersSelected.get(this.player) == null) {
            return null;
        }
        String nickname = playersSelected.get(this.player);
        Player player = Bukkit.getPlayer((String)nickname);
        if (player != null && OpenCreative.getPlanetsManager().getPlanetByPlayer(player) == planet) {
            ArrayList<Runnable> actions = new ArrayList<Runnable>();
            actions.add(() -> {
                player.setAllowFlight(false);
                player.setFlying(false);
            });
            actions.add(() -> {
                player.setAllowFlight(true);
                player.setFlying(true);
            });
            int isFlying = player.isFlying() ? 2 : 1;
            RadioButton radioButton = new RadioButton(Material.FEATHER, MessageUtils.getLocaleItemName("menus.world-settings-players.items.fly.name"), MessageUtils.getLocaleItemDescription("menus.world-settings-players.items.fly.lore"), isFlying, 2, actions, "menus.world-settings-players.items.fly.choices", "menus.world-settings-players");
            return radioButton.getButtonItem();
        }
        return null;
    }

    public ItemStack getDevButton(Planet planet) {
        if (playersSelected.get(this.player) == null) {
            return null;
        }
        String nickname = playersSelected.get(this.player);
        List<Runnable> actions = this.getRunnableList(planet, nickname);
        int canDev = 1;
        if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.DEVELOPERS_GUESTS).contains(nickname)) {
            canDev = 2;
        } else if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.DEVELOPERS_NOT_TRUSTED).contains(nickname)) {
            canDev = 3;
        } else if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.DEVELOPERS_TRUSTED).contains(nickname)) {
            canDev = 4;
        }
        RadioButton radioButton = new RadioButton(Material.COMMAND_BLOCK, MessageUtils.getLocaleItemName("menus.world-settings-players.items.dev.name"), MessageUtils.getLocaleItemDescription("menus.world-settings-players.items.dev.lore"), canDev, 4, actions, "menus.world-settings-players.items.dev.choices", "menus.world-settings-players");
        return radioButton.getButtonItem();
    }

    private List<Runnable> getRunnableList(Planet planet, String nickname) {
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        actions.add(() -> {
            this.player.sendMessage(MessageUtils.getLocaleMessage("world.players.developers.removed").replace("%player%", nickname));
            planet.getWorldPlayers().removeDeveloper(nickname);
        });
        actions.add(() -> {
            int limit = planet.getLimits().getDevelopersLimit();
            if (planet.getWorldPlayers().getAllDevelopers().size() > limit) {
                this.player.sendMessage(MessageUtils.getLocaleMessage("world.players.developers.limit").replace("%limit%", String.valueOf(limit)));
                return;
            }
            this.player.sendMessage(MessageUtils.getLocaleMessage("world.players.developers.guest").replace("%player%", nickname));
            planet.getWorldPlayers().addDeveloperGuest(nickname);
        });
        actions.add(() -> {
            this.player.sendMessage(MessageUtils.getLocaleMessage("world.players.developers.added").replace("%player%", nickname));
            planet.getWorldPlayers().addDeveloper(nickname, false);
        });
        actions.add(() -> {
            this.player.sendMessage(MessageUtils.getLocaleMessage("world.players.developers.trusted").replace("%player%", nickname));
            planet.getWorldPlayers().addDeveloper(nickname, true);
        });
        return actions;
    }

    public ItemStack getBuildButton(Planet planet) {
        if (playersSelected.get(this.player) == null) {
            return null;
        }
        String nickname = playersSelected.get(this.player);
        List<Runnable> actions = this.getRunnables(planet, nickname);
        int canBuild = 1;
        if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.BUILDERS_NOT_TRUSTED).contains(nickname)) {
            canBuild = 2;
        } else if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.BUILDERS_TRUSTED).contains(nickname)) {
            canBuild = 3;
        }
        RadioButton radioButton = new RadioButton(Material.BRICKS, MessageUtils.getLocaleItemName("menus.world-settings-players.items.build.name"), MessageUtils.getLocaleItemDescription("menus.world-settings-players.items.build.lore"), canBuild, 3, actions, "menus.world-settings-players.items.build.choices", "menus.world-settings-players");
        return radioButton.getButtonItem();
    }

    private List<Runnable> getRunnables(Planet planet, String nickname) {
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        actions.add(() -> {
            this.player.sendMessage(MessageUtils.getLocaleMessage("world.players.builders.removed").replace("%player%", nickname));
            planet.getWorldPlayers().removeBuilder(nickname);
        });
        actions.add(() -> {
            int limit = planet.getLimits().getBuildersLimit();
            if (planet.getWorldPlayers().getAllBuilders().size() > limit) {
                this.player.sendMessage(MessageUtils.getLocaleMessage("world.players.builders.limit").replace("%limit%", String.valueOf(limit)));
                return;
            }
            this.player.sendMessage(MessageUtils.getLocaleMessage("world.players.builders.added").replace("%player%", nickname));
            planet.getWorldPlayers().addBuilder(nickname, false);
        });
        actions.add(() -> {
            this.player.sendMessage(MessageUtils.getLocaleMessage("world.players.builders.trusted").replace("%player%", nickname));
            planet.getWorldPlayers().addBuilder(nickname, true);
        });
        return actions;
    }

    public ItemStack getPlayerButton(Planet planet) {
        if (playersSelected.get(this.player) == null) {
            return null;
        }
        String planetPlayer = playersSelected.get(this.player);
        ItemStack item = new ItemStack(Material.PLAYER_HEAD);
        ItemMeta meta = item.getItemMeta();
        SkullMeta skullMeta = (SkullMeta)meta;
        skullMeta.setOwningPlayer(Bukkit.getOfflinePlayer((String)planetPlayer));
        skullMeta.setDisplayName(MessageUtils.getLocaleItemName("menus.world-settings-players.items.selected-player.name").replace("%player%", planetPlayer));
        ArrayList<String> lore = new ArrayList<String>();
        for (String loreLine : MessageUtils.getLocaleItemDescription("menus.world-settings-players.items.player.lore")) {
            String build = MessageUtils.getLocaleMessage("menus.world-settings-players.items.build.choices.1");
            String dev = MessageUtils.getLocaleMessage("menus.world-settings-players.items.dev.choices.1");
            String fly = MessageUtils.getLocaleMessage("menus.world-settings-players.items.fly.choices.1");
            String online = MessageUtils.getLocaleMessage("menus.world-settings-players.not-in-world");
            if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.BUILDERS_TRUSTED).contains(planetPlayer)) {
                build = MessageUtils.getLocaleMessage("menus.world-settings-players.items.build.choices.3");
            } else if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.BUILDERS_NOT_TRUSTED).contains(planetPlayer)) {
                build = MessageUtils.getLocaleMessage("menus.world-settings-players.items.build.choices.2");
            }
            if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.DEVELOPERS_TRUSTED).contains(planetPlayer)) {
                dev = MessageUtils.getLocaleMessage("menus.world-settings-players.items.dev.choices.3");
            } else if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.DEVELOPERS_NOT_TRUSTED).contains(planetPlayer)) {
                dev = MessageUtils.getLocaleMessage("menus.world-settings-players.items.dev.choices.2");
            }
            Player planetPlayer_ = Bukkit.getPlayer((String)planetPlayer);
            if (planetPlayer_ != null) {
                if (OpenCreative.getPlanetsManager().getPlanetByPlayer(planetPlayer_) == planet) {
                    online = MessageUtils.getLocaleMessage("menus.world-settings-players.in-world");
                }
                if (planetPlayer_.isFlying()) {
                    fly = MessageUtils.getLocaleMessage("menus.world-settings-players.items.fly.choices.2");
                }
            }
            if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.DEVELOPERS_TRUSTED).contains(planetPlayer)) {
                dev = MessageUtils.getLocaleMessage("menus.world-settings-players.items.dev.choices.3");
            } else if (FileUtils.getPlayersFromPlanetList(planet, Planet.PlayersType.DEVELOPERS_NOT_TRUSTED).contains(planetPlayer)) {
                dev = MessageUtils.getLocaleMessage("menus.world-settings-players.items.dev.choices.2");
            }
            lore.add(MessageUtils.parsePAPI(Bukkit.getOfflinePlayer((String)planetPlayer), loreLine).replace("%build%", build).replace("%dev%", dev).replace("%fly%", fly).replace("%online%", online));
        }
        skullMeta.setLore(lore);
        item.setItemMeta((ItemMeta)skullMeta);
        return item;
    }

    private static List<List<String>> getPagesForPlayers(Set<String> playerList) {
        ArrayList<List<String>> pages = new ArrayList<List<String>>();
        int pageSize = 10;
        int pageCount = (int)Math.ceil((double)playerList.size() / (double)pageSize);
        for (int i = 0; i < pageCount; ++i) {
            int fromIndex = i * pageSize;
            int toIndex = Math.min((i + 1) * pageSize, playerList.size());
            List<String> sublist = new ArrayList<String>(playerList).subList(fromIndex, toIndex);
            ArrayList<String> page = new ArrayList<String>(sublist);
            pages.add(page);
        }
        return pages;
    }
}

