/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.planets;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.WorldBorder;
import org.bukkit.entity.Player;
import ua.mcchickenstudio.opencreative.planets.Planet;

public class PlanetExperiments {
    private final Planet planet;

    public PlanetExperiments(Planet planet) {
        this.planet = planet;
    }

    public void handle(Player player, String[] args) {
        switch (args[0].toLowerCase()) {
            case "downloadable": {
                this.planet.getInformation().setDownloadable(!this.planet.getInformation().isDownloadable());
                this.announce("Now world " + (this.planet.getInformation().isDownloadable() ? "can be downloaded" : "can't be downloaded"));
                break;
            }
            case "border": {
                if (!player.hasPermission("opencreative.test")) {
                    return;
                }
                if (args.length == 1) {
                    return;
                }
                WorldBorder border = Bukkit.createWorldBorder();
                border.setSize(player.getWorld().getWorldBorder().getSize());
                if ("green".equalsIgnoreCase(args[1])) {
                    border.setSize(border.getSize() + 0.1, 3600L);
                } else if ("red".equalsIgnoreCase(args[1])) {
                    border.setSize(border.getSize() - 0.1, 3600L);
                }
                player.setWorldBorder(border);
            }
        }
    }

    private void announce(String message) {
        this.planet.getAudience().sendMessage(((TextComponent)Component.text((String)("[Experiment: " + message + "]")).decorate(TextDecoration.ITALIC)).color(TextColor.color((int)170, (int)170, (int)170)));
    }
}

