/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.planets;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.GameRule;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.FileUtils;

public class PlanetFlags {
    private final Planet planet;
    private final Map<PlanetFlag, Byte> flags = new HashMap<PlanetFlag, Byte>();

    public PlanetFlags(Planet planet) {
        this.planet = planet;
    }

    public void clear() {
        this.flags.clear();
    }

    public void setFlag(PlanetFlag planetFlag, byte value) {
        this.flags.put(planetFlag, value);
        FileUtils.setPlanetConfigParameter(this.planet, planetFlag.getConfigPath(), value);
    }

    public void loadFlags() {
        FileConfiguration configuration = FileUtils.getPlanetConfig(this.planet);
        for (PlanetFlag flag : PlanetFlag.values()) {
            String configValue = configuration.getString(flag.getConfigPath());
            if (configValue == null || configValue.isEmpty()) {
                this.flags.put(flag, flag.getDefaultValue());
                continue;
            }
            byte value = flag.getDefaultValue();
            try {
                value = Byte.parseByte(configValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (value < 1 || value > 10) {
                value = 1;
            }
            this.flags.put(flag, value);
        }
    }

    public byte getFlagValue(PlanetFlag flag) {
        if (this.flags.containsKey((Object)flag)) {
            return this.flags.get((Object)flag);
        }
        this.setFlag(flag, flag.getDefaultValue());
        return flag.getDefaultValue();
    }

    public Map<PlanetFlag, Byte> getFlags() {
        return this.flags;
    }

    public static enum PlanetFlag {
        PLAYER_DAMAGE("player-damage", Material.TOTEM_OF_UNDYING, 1, 5),
        DAY_CYCLE("day-cycle", Material.CLOCK, 1, 4, GameRule.DO_DAYLIGHT_CYCLE),
        JOIN_MESSAGES("join-messages", Material.OAK_SIGN, 1, 2),
        FIRE_SPREAD("fire-spread", Material.CAMPFIRE, 1, 2, GameRule.DO_FIRE_TICK),
        WEATHER("weather", Material.WATER_BUCKET, 1, 3, GameRule.DO_WEATHER_CYCLE),
        BLOCK_INTERACT("block-interact", Material.CHEST, 1, 5),
        MOB_INTERACT("mob-interact", Material.VILLAGER_SPAWN_EGG, 1, 3),
        MOB_LOOT("mob-loot", Material.FEATHER, 1, 2, GameRule.DO_MOB_LOOT),
        MOB_SPAWN("mob-spawn", Material.PIG_SPAWN_EGG, 1, 5, GameRule.DO_MOB_SPAWNING),
        NATURAL_REGENERATION("natural-regeneration", Material.POTION, 1, 2, GameRule.NATURAL_REGENERATION),
        BLOCK_CHANGING("block-changing", Material.ICE, 1, 2),
        BLOCK_EXPLOSION("block-explosion", Material.TNT, 1, 2, GameRule.MOB_GRIEFING),
        LIKE_MESSAGES("like-messages", Material.KNOWLEDGE_BOOK, 1, 2),
        DEATH_MESSAGES("death-messages", Material.WITHER_SKELETON_SKULL, 1, 2),
        KEEP_INVENTORY("keep-inventory", Material.CHEST_MINECART, 1, 2, GameRule.KEEP_INVENTORY),
        IMMEDIATE_RESPAWN("immediate-respawn", Material.SKELETON_SKULL, 1, 2, GameRule.DO_IMMEDIATE_RESPAWN),
        WORLD_BORDERS("world-borders", Material.LIGHT_BLUE_STAINED_GLASS, 1, 4);

        private final String configPath;
        private final byte defaultValue;
        private final byte maxChoices;
        private final GameRule<?> gameRule;
        private final Material material;

        private PlanetFlag(String configPath, Material icon, byte defaultValue, byte maxChoices) {
            this.configPath = configPath;
            this.defaultValue = defaultValue;
            this.maxChoices = maxChoices;
            this.gameRule = null;
            this.material = icon;
        }

        private PlanetFlag(String configPath, Material icon, byte defaultValue, byte maxChoices, GameRule<?> gameRule) {
            this.configPath = configPath;
            this.defaultValue = defaultValue;
            this.maxChoices = maxChoices;
            this.gameRule = gameRule;
            this.material = icon;
        }

        public String getConfigPath() {
            return "flags." + this.configPath;
        }

        public byte getDefaultValue() {
            return this.defaultValue;
        }

        public byte getMaxChoices() {
            return this.maxChoices;
        }

        public GameRule<?> getGameRule() {
            return this.gameRule;
        }

        public Material getMaterial() {
            return this.material;
        }
    }
}

