/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.planets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.util.TriState;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Scoreboard;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.CodeScript;
import ua.mcchickenstudio.opencreative.coding.blocks.events.player.world.QuitEvent;
import ua.mcchickenstudio.opencreative.events.planet.PlanetLoadEvent;
import ua.mcchickenstudio.opencreative.events.planet.PlanetUnloadEvent;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.planets.PlanetFlags;
import ua.mcchickenstudio.opencreative.planets.PlanetRunnable;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;
import ua.mcchickenstudio.opencreative.utils.world.generators.EnvironmentCapable;
import ua.mcchickenstudio.opencreative.utils.world.generators.StructuresCapable;
import ua.mcchickenstudio.opencreative.utils.world.generators.WorldGenerator;
import ua.mcchickenstudio.opencreative.utils.world.generators.WorldGenerators;

public class PlanetTerritory {
    private final Planet planet;
    private final PlanetFlags flags;
    private final Map<String, BossBar> bossBars = new HashMap<String, BossBar>();
    private final Map<String, Scoreboard> scoreboards = new HashMap<String, Scoreboard>();
    private final List<BukkitRunnable> runningBukkitRunnables = new ArrayList<BukkitRunnable>();
    private final CodeScript script;
    private String generator = "";
    private int worldSize = 25;
    private World.Environment environment;
    private boolean autoSave = true;

    public PlanetTerritory(Planet planet) {
        this.planet = planet;
        this.flags = new PlanetFlags(planet);
        this.script = new CodeScript(planet);
        this.loadInformation();
    }

    public void setAutoSave(boolean autoSave) {
        if (this.autoSave == autoSave) {
            return;
        }
        this.autoSave = autoSave;
        for (Player planetPlayer : this.planet.getPlayers()) {
            planetPlayer.sendMessage(MessageUtils.getLocaleMessage("settings.autosave." + (autoSave ? "enabled" : "disabled")));
        }
        if (this.getWorld() != null) {
            this.getWorld().setAutoSave(autoSave);
        }
        FileUtils.setPlanetConfigParameter(this.planet, "autosave", !autoSave ? Boolean.valueOf(false) : null);
    }

    private void loadInformation() {
        this.worldSize = OpenCreative.getSettings().getGroups().getGroup(this.planet.getOwnerGroup()).getWorldSize();
        FileConfiguration config = FileUtils.getPlanetConfig(this.planet);
        World.Environment environment = World.Environment.NORMAL;
        if (config.getString("environment") != null) {
            try {
                environment = World.Environment.valueOf((String)config.getString("environment"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.autoSave = config.getBoolean("autosave", true);
        this.generator = config.getString("generator", "");
        this.environment = environment;
    }

    public synchronized void load() {
        World world;
        long startTime = System.currentTimeMillis();
        this.loadInformation();
        this.flags.loadFlags();
        this.planet.getWorldPlayers().loadPlayers();
        WorldGenerator worldGenerator = WorldGenerators.getInstance().getById(this.generator);
        WorldCreator creator = new WorldCreator(this.planet.getWorldName()).environment(this.planet.getTerritory().getEnvironment()).keepSpawnLoaded(TriState.FALSE);
        if (worldGenerator != null) {
            worldGenerator.modifyWorldCreator(creator);
        }
        if ((world = creator.createWorld()) == null) {
            return;
        }
        world.setAutoSave(this.autoSave);
        world.setGameRule(GameRule.SPAWN_CHUNK_RADIUS, (Object)1);
        world.setGameRule(GameRule.GLOBAL_SOUND_EVENTS, (Object)false);
        if (world.getEnvironment() == World.Environment.THE_END) {
            if (world.getEnderDragonBattle() != null) {
                world.getEnderDragonBattle().setPreviouslyKilled(true);
                world.getEnderDragonBattle().getBossBar().setVisible(false);
            }
            new BukkitRunnable(this){

                public void run() {
                    for (Entity entity : world.getEntities()) {
                        if (!(entity instanceof EnderDragon)) continue;
                        EnderDragon dragon = (EnderDragon)entity;
                        dragon.setHealth(0.0);
                    }
                }
            }.runTaskLater((Plugin)OpenCreative.getPlugin(), 10L);
        }
        this.planet.setLastActivityTime(System.currentTimeMillis());
        world.setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
        world.getWorldBorder().setSize((double)this.worldSize);
        this.planet.getVariables().load();
        new PlanetLoadEvent(this.planet).callEvent();
        long endTime = System.currentTimeMillis();
        OpenCreative.getPlugin().getLogger().info("Planet " + this.planet.getId() + " loaded in " + (endTime - startTime) + " ms");
    }

    public synchronized void unload() {
        long startTime = System.currentTimeMillis();
        if (!this.planet.isLoaded()) {
            if (this.planet.getDevPlanet().isLoaded()) {
                this.planet.getDevPlanet().unload();
                long endTime = System.currentTimeMillis();
                OpenCreative.getPlugin().getLogger().info("Planet " + this.planet.getId() + " unloaded only dev in " + (endTime - startTime) + " ms");
            }
            return;
        }
        World world = this.getWorld();
        if (world != null) {
            for (Entity entity : world.getEntitiesByClass(Item.class)) {
                if (!(entity instanceof Item)) continue;
                Item item = (Item)entity;
                item.setItemStack(ItemUtils.fixItem(item.getItemStack()));
            }
        }
        for (Player player : this.planet.getPlayers()) {
            new QuitEvent(player).callEvent();
        }
        this.planet.setLastActivityTime(System.currentTimeMillis());
        FileUtils.setPlanetConfigParameter(this.planet, "environment", this.planet.getTerritory().getEnvironment().name());
        this.planet.getVariables().save();
        for (Player player : this.planet.getPlayers()) {
            PlayerUtils.teleportToLobby(player);
        }
        this.clearData();
        Bukkit.unloadWorld((String)this.planet.getWorldName(), (boolean)this.autoSave);
        if (this.planet.getDevPlanet().isLoaded()) {
            this.planet.getDevPlanet().unload();
        }
        new PlanetUnloadEvent(this.planet).callEvent();
        long endTime = System.currentTimeMillis();
        OpenCreative.getPlugin().getLogger().info("Planet " + this.planet.getId() + " unloaded in " + (endTime - startTime) + " ms");
    }

    public void clearData() {
        this.stopBukkitRunnables();
        this.bossBars.clear();
        this.scoreboards.clear();
        this.flags.clear();
        this.script.getExecutors().clear();
        this.planet.getVariables().clearVariables();
        this.planet.getWorldPlayers().clear();
        this.planet.getLimits().clear();
        this.script.unload();
        MessageUtils.clearOnceMessages(this.planet);
    }

    public void addBukkitRunnable(BukkitRunnable runnable) {
        this.runningBukkitRunnables.add(runnable);
    }

    public void scheduleRunnable(PlanetRunnable runnable, long delay) {
        this.runningBukkitRunnables.add(runnable);
        runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), delay);
    }

    public void scheduleAsyncRunnable(PlanetRunnable runnable, long delay) {
        this.runningBukkitRunnables.add(runnable);
        runnable.runTaskLaterAsynchronously((Plugin)OpenCreative.getPlugin(), delay);
    }

    public void removeBukkitRunnable(BukkitRunnable runnable) {
        this.runningBukkitRunnables.remove(runnable);
    }

    public void stopBukkitRunnables() {
        for (BukkitRunnable runnable : this.runningBukkitRunnables) {
            try {
                if (runnable == null) continue;
                runnable.cancel();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.runningBukkitRunnables.clear();
    }

    public PlanetFlags getFlags() {
        return this.flags;
    }

    public Map<String, Scoreboard> getScoreboards() {
        return this.scoreboards;
    }

    public Map<String, BossBar> getBossBars() {
        return this.bossBars;
    }

    public World.Environment getEnvironment() {
        return this.environment;
    }

    public World getWorld() {
        return Bukkit.getWorld((String)this.planet.getWorldName());
    }

    public int getWorldSize() {
        return this.worldSize;
    }

    public CodeScript getScript() {
        return this.script;
    }

    @Nullable
    public World generateWorld(WorldGenerator generator, World.Environment environment, long seed, boolean generateStructures) {
        WorldCreator worldCreator = new WorldCreator(this.planet.getWorldName());
        if (generator instanceof StructuresCapable) {
            worldCreator.generateStructures(generateStructures);
        }
        worldCreator.type(WorldType.FLAT);
        if (generator instanceof EnvironmentCapable) {
            EnvironmentCapable capable = (EnvironmentCapable)((Object)generator);
            worldCreator.environment(environment);
        }
        worldCreator.seed(seed);
        generator.modifyWorldCreator(worldCreator);
        worldCreator.keepSpawnLoaded(TriState.FALSE);
        final World world = Bukkit.createWorld((WorldCreator)worldCreator);
        if (world != null) {
            world.setAutoSave(true);
            world.setGameRule(GameRule.SPAWN_CHUNK_RADIUS, (Object)1);
            world.getWorldBorder().setSize((double)this.getWorldSize());
            world.setGameRule(GameRule.DO_MOB_LOOT, (Object)true);
            world.setGameRule(GameRule.DO_MOB_SPAWNING, (Object)false);
            world.setGameRule(GameRule.DO_DAYLIGHT_CYCLE, (Object)false);
            world.setGameRule(GameRule.DO_WEATHER_CYCLE, (Object)false);
            world.setGameRule(GameRule.KEEP_INVENTORY, (Object)false);
            world.setGameRule(GameRule.MOB_GRIEFING, (Object)true);
            world.setGameRule(GameRule.NATURAL_REGENERATION, (Object)true);
            world.setGameRule(GameRule.DO_IMMEDIATE_RESPAWN, (Object)false);
            world.setGameRule(GameRule.DO_FIRE_TICK, (Object)true);
            world.setGameRule(GameRule.SHOW_DEATH_MESSAGES, (Object)false);
            world.setGameRule(GameRule.ANNOUNCE_ADVANCEMENTS, (Object)false);
            world.setGameRule(GameRule.GLOBAL_SOUND_EVENTS, (Object)false);
            world.setTime(0L);
            for (Entity entity : world.getEntities()) {
                if (entity.getType() == EntityType.PLAYER) continue;
                entity.remove();
            }
            generator.afterCreation(world);
            BukkitRunnable runnable = new BukkitRunnable(this){

                public void run() {
                    for (Entity entity : world.getEntities()) {
                        if (!(entity instanceof EnderDragon)) continue;
                        EnderDragon dragon = (EnderDragon)entity;
                        dragon.setHealth(0.0);
                    }
                }
            };
            runnable.runTaskLater((Plugin)OpenCreative.getPlugin(), 10L);
            return world;
        }
        return null;
    }

    public void showBorders(Player player) {
        if (PlayerUtils.isEntityInDevPlanet((Entity)player)) {
            return;
        }
        WorldBorder border = Bukkit.createWorldBorder();
        border.setSize(player.getWorld().getWorldBorder().getSize());
        switch (this.planet.getFlagValue(PlanetFlags.PlanetFlag.WORLD_BORDERS)) {
            case 1: {
                border.setSize(border.getSize());
                break;
            }
            case 2: {
                border.setSize(border.getSize() + 0.001, 3600L);
                break;
            }
            case 3: {
                border.setSize(border.getSize() - 0.1, 3600L);
                break;
            }
            case 4: {
                border.setSize(border.getMaxSize());
            }
        }
        player.setWorldBorder(border);
    }

    public boolean isAutoSave() {
        return this.autoSave;
    }
}

