/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.settings;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionType;
import ua.mcchickenstudio.opencreative.coding.blocks.executors.ExecutorType;
import ua.mcchickenstudio.opencreative.events.status.MaintenanceEndEvent;
import ua.mcchickenstudio.opencreative.events.status.MaintenanceStartEvent;
import ua.mcchickenstudio.opencreative.indev.Items;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.settings.Commands;
import ua.mcchickenstudio.opencreative.settings.SettingsItem;
import ua.mcchickenstudio.opencreative.settings.SettingsSound;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.settings.groups.Groups;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;
import ua.mcchickenstudio.opencreative.utils.world.generators.CustomFlatGenerator;
import ua.mcchickenstudio.opencreative.utils.world.generators.EmptyGenerator;
import ua.mcchickenstudio.opencreative.utils.world.generators.FlatGenerator;
import ua.mcchickenstudio.opencreative.utils.world.generators.LargeBiomesGenerator;
import ua.mcchickenstudio.opencreative.utils.world.generators.OceanGenerator;
import ua.mcchickenstudio.opencreative.utils.world.generators.SurvivalGenerator;
import ua.mcchickenstudio.opencreative.utils.world.generators.WorldGenerator;
import ua.mcchickenstudio.opencreative.utils.world.generators.WorldGenerators;
import ua.mcchickenstudio.opencreative.utils.world.generators.WorldTemplate;
import ua.mcchickenstudio.opencreative.utils.world.platforms.DevPlatformer;
import ua.mcchickenstudio.opencreative.utils.world.platforms.DevPlatformers;
import ua.mcchickenstudio.opencreative.utils.world.platforms.HorizontalPlatformer;

public final class Settings {
    private boolean debug = false;
    private boolean maintenance = false;
    private boolean creativeChatEnabled = true;
    private boolean consoleCriticalErrors = true;
    private boolean consoleNotFoundMessage = false;
    private boolean consoleWarnings = true;
    private boolean itemFixerEnabled = true;
    private int itemsMaxEnchantLevel = 10;
    private int itemsEntitiesMaxAmount = 3;
    private int itemsMaxBookPagesAmount = 50;
    private int itemsMaxEntityNameLength = 48;
    private int itemsContainerBigItemsLimit = 3;
    private int itemsMaxPersistentDataSize = 2048;
    private int itemsDisplayNameMaxLength = 64;
    private int itemsLoreLineMaxLength = 100;
    private int itemsLoreLinesMaxAmount = 25;
    private boolean itemsRemoveAttributes = true;
    private boolean itemsRemoveBossSpawnEggs = true;
    private boolean itemsRemoveCustomSpawnEggs = true;
    private boolean itemsRemoveClickableBooks = true;
    private boolean itemsClearCommandBlocksData = true;
    private boolean lobbyClearInventory = true;
    private boolean lobbyDisallowPlacingBlocks = true;
    private boolean lobbyDisallowDestroyingBlocks = true;
    private boolean lobbyDisallowSpawningMobs = true;
    private boolean lobbyDisallowDamagingMobs = true;
    private boolean lobbyDisallowWorldEdit = true;
    private boolean lobbyDisableExplosions = true;
    private boolean legacySelectionMenu = false;
    private BukkitRunnable announcer;
    private PlayerListChanger listChanger = PlayerListChanger.FULL;
    private int worldCreationMinSeconds = 30;
    private int worldReputationMinSeconds = 300;
    private String customIdPattern = "^[a-zA-Z\u0430-\u044f\u0410-\u042f0-9_]+$";
    private int customIdMinLength = 2;
    private int customIdMaxLength = 16;
    private int worldNameMinLength = 4;
    private int worldNameMaxLength = 30;
    private int worldDescriptionMinLength = 4;
    private int worldDescriptionMaxLength = 256;
    private int moduleNameMinLength = 4;
    private int moduleNameMaxLength = 30;
    private int moduleDescriptionMinLength = 4;
    private int moduleDescriptionMaxLength = 256;
    private final Groups groups;
    private final Commands commands;
    private final Set<Integer> recommendedWorldsIDs = new HashSet<Integer>();
    private final Set<String> allowedResourcePackLinks = new HashSet<String>();
    private boolean enabledCoding = true;
    private final Set<String> disabledEvents = new HashSet<String>();
    private final Set<String> disabledActions = new HashSet<String>();
    private final Set<String> disabledConditions = new HashSet<String>();
    private final Map<Sounds, SettingsSound> sounds = new HashMap<Sounds, SettingsSound>();
    private final Map<Items, SettingsItem> items = new HashMap<Items, SettingsItem>();

    public Settings() {
        this.groups = new Groups();
        this.commands = new Commands();
    }

    public void load(FileConfiguration config) {
        this.allowedResourcePackLinks.clear();
        this.recommendedWorldsIDs.clear();
        this.sounds.clear();
        this.listChanger = PlayerListChanger.fromString(config.getString("hide-from-tab", "full"));
        this.recommendedWorldsIDs.addAll(config.getIntegerList("recommended-worlds"));
        this.allowedResourcePackLinks.addAll(config.getStringList("allowed-links.resource-pack"));
        this.debug = config.getBoolean("debug", false);
        this.maintenance = config.getBoolean("maintenance", false);
        this.consoleCriticalErrors = config.getBoolean("messages.critical-errors", true);
        this.consoleNotFoundMessage = config.getBoolean("messages.not-found", false);
        this.consoleWarnings = config.getBoolean("messages.warnings", true);
        this.lobbyClearInventory = config.getBoolean("lobby.clear-inventory", true);
        this.lobbyDisableExplosions = config.getBoolean("lobby.disable-explosions", true);
        this.lobbyDisallowWorldEdit = config.getBoolean("lobby.disallow-world-edit", true);
        this.lobbyDisallowDamagingMobs = config.getBoolean("lobby.disallow-damaging-mobs", true);
        this.lobbyDisallowSpawningMobs = config.getBoolean("lobby.disallow-spawning-mobs", true);
        this.lobbyDisallowPlacingBlocks = config.getBoolean("lobby.disallow-placing-blocks", true);
        this.lobbyDisallowDestroyingBlocks = config.getBoolean("lobby.disallow-destroying-blocks", true);
        this.legacySelectionMenu = config.getBoolean("coding.old-selection-menu", false);
        this.enabledCoding = config.getBoolean("coding.enabled", true);
        this.worldCreationMinSeconds = config.getInt("requirements.world-creation.played-seconds", 30);
        this.worldReputationMinSeconds = config.getInt("requirements.world-reputation.creation-seconds", 300);
        this.customIdPattern = config.getString("requirements.world-custom-id.pattern", "^[a-zA-Z\u0430-\u044f\u0410-\u042f0-9_]+$");
        this.customIdMinLength = config.getInt("requirements.world-custom-id.min-length", 2);
        this.customIdMaxLength = config.getInt("requirements.world-custom-id.max-length", 16);
        this.worldNameMinLength = config.getInt("requirements.world-name.min-length", 2);
        this.worldNameMaxLength = config.getInt("requirements.world-name.max-length", 16);
        this.worldDescriptionMinLength = config.getInt("requirements.world-description.min-length", 2);
        this.worldDescriptionMaxLength = config.getInt("requirements.world-description.max-length", 256);
        this.moduleNameMinLength = config.getInt("requirements.module-name.min-length", 2);
        this.moduleNameMaxLength = config.getInt("requirements.module-name.max-length", 16);
        this.moduleDescriptionMinLength = config.getInt("requirements.module-description.min-length", 2);
        this.moduleDescriptionMaxLength = config.getInt("requirements.module-description.max-length", 256);
        this.itemFixerEnabled = config.getBoolean("item-fixer.enabled", true);
        this.itemsRemoveAttributes = config.getBoolean("item-fixer.remove-attribute-modifiers", true);
        this.itemsRemoveClickableBooks = config.getBoolean("item-fixer.remove-clickable-in-books", true);
        this.itemsRemoveCustomSpawnEggs = config.getBoolean("item-fixer.remove-custom-spawn-eggs", true);
        this.itemsRemoveBossSpawnEggs = config.getBoolean("item-fixer.remove-boss-spawn-eggs", true);
        this.itemsClearCommandBlocksData = config.getBoolean("item-fixer.clear-command-blocks-data", true);
        this.itemsMaxEnchantLevel = config.getInt("item-fixer.max-enchantment-level", 10);
        this.itemsMaxEntityNameLength = config.getInt("item-fixer.entity-name-max-length", 48);
        this.itemsMaxPersistentDataSize = config.getInt("item-fixer.persistent-data-max-size", 2048);
        this.itemsEntitiesMaxAmount = config.getInt("item-fixer.entities-max-amount", 3);
        this.itemsMaxBookPagesAmount = config.getInt("item-fixer.books-pages-max-amount", 50);
        this.itemsContainerBigItemsLimit = config.getInt("item-fixer.container-big-items-max-amount", 3);
        this.itemsDisplayNameMaxLength = config.getInt("item-fixer.display-name-max-length", 64);
        this.itemsLoreLineMaxLength = config.getInt("item-fixer.lore-line-max-length", 100);
        this.itemsLoreLinesMaxAmount = config.getInt("item-fixer.container-lore-lines-max-amount", 25);
        this.groups.load();
        this.commands.load();
        String soundsTheme = config.getString("sounds.theme", "default");
        this.loadSounds(config, soundsTheme);
        this.loadItems(config);
        this.loadDisabledBlocks(config);
        this.loadWorldGenerators(config);
        if (this.maintenance) {
            OpenCreative.getPlugin().getLogger().warning("Maintenance mode is still enabled in config.yml, to disable: /maintenance end");
        }
        if (this.debug) {
            OpenCreative.getPlugin().getLogger().warning("Debug Mode is enabled in config.yml, some logs will appear in console.");
        }
        String platformsGeneratorId = config.getString("coding.platforms-generator", "horizontal");
        DevPlatformer platformer = DevPlatformers.getInstance().getById(platformsGeneratorId);
        if (platformer == null) {
            ErrorUtils.sendWarningErrorMessage("[PLATFORMERS] Unknown coding platform generator: " + platformsGeneratorId + ", using the default horizontal.");
            platformer = new HorizontalPlatformer();
        }
        OpenCreative.setDevPlatformer(platformer);
        this.checkDebugAnnouncer();
    }

    private void loadWorldGenerators(FileConfiguration config) {
        int registeredGenerators;
        ConfigurationSection templatesSection;
        ConfigurationSection customFlatsSection;
        WorldGenerators instance = WorldGenerators.getInstance();
        instance.clearWorldGenerators();
        if (config.getBoolean("generators.flat", true)) {
            instance.registerWorldGenerator((WorldGenerator)new FlatGenerator());
        }
        if (config.getBoolean("generators.empty", true)) {
            instance.registerWorldGenerator((WorldGenerator)new EmptyGenerator());
        }
        if (config.getBoolean("generators.water", true)) {
            instance.registerWorldGenerator((WorldGenerator)new OceanGenerator());
        }
        if (config.getBoolean("generators.survival", true)) {
            instance.registerWorldGenerator((WorldGenerator)new SurvivalGenerator());
        }
        if (config.getBoolean("generators.large-biomes", true)) {
            instance.registerWorldGenerator((WorldGenerator)new LargeBiomesGenerator());
        }
        if ((customFlatsSection = config.getConfigurationSection("generators.custom-flats")) != null) {
            for (Object customFlatId : customFlatsSection.getKeys(false)) {
                String generation = customFlatsSection.getString((String)customFlatId + ".generation");
                if (generation == null) continue;
                String iconMaterial = customFlatsSection.getString((String)customFlatId + ".icon", "GRASS_BLOCK");
                Material material = Material.getMaterial((String)iconMaterial.toUpperCase());
                if (material == null || !material.isItem()) {
                    material = Material.GRASS_BLOCK;
                }
                boolean generateTrees = customFlatsSection.getBoolean((String)customFlatId + ".generate-trees", true);
                instance.registerWorldGenerator((WorldGenerator)new CustomFlatGenerator((String)customFlatId, new ItemStack(material), generation, generateTrees));
            }
        }
        if ((templatesSection = config.getConfigurationSection("generators.templates")) != null) {
            for (String templateId : templatesSection.getKeys(false)) {
                String folderName;
                boolean enabled = templatesSection.getBoolean(templateId + ".enabled", true);
                if (!enabled || (folderName = templatesSection.getString(templateId + ".folder")) == null) continue;
                File template = new File(String.valueOf(OpenCreative.getPlugin().getDataPath()) + File.separator + "templates" + File.separator + folderName);
                if (!template.exists() || !template.isDirectory()) {
                    ErrorUtils.sendWarningErrorMessage("Can't register template world " + templateId + " because it's folder " + folderName + " doesn't exists.");
                    continue;
                }
                String iconMaterial = templatesSection.getString(templateId + ".icon", "GRASS_BLOCK");
                Material material = Material.getMaterial((String)iconMaterial.toUpperCase());
                if (material == null || !material.isItem()) {
                    material = Material.GRASS_BLOCK;
                }
                instance.registerWorldGenerator((WorldGenerator)new WorldTemplate(templateId, new ItemStack(material), folderName));
            }
        }
        if ((registeredGenerators = instance.getWorldGenerators().size()) != 5) {
            OpenCreative.getPlugin().getLogger().info("Registered " + registeredGenerators + " world generators");
        }
    }

    public boolean isWorldGenerationUnavailable() {
        return WorldGenerators.getInstance().getWorldGenerators().isEmpty();
    }

    private void loadDisabledBlocks(FileConfiguration config) {
        Enum type;
        this.disabledEvents.clear();
        this.disabledConditions.clear();
        this.disabledActions.clear();
        int count = 0;
        ArrayList<String> unknownBlocks = new ArrayList<String>();
        for (String disabled : config.getStringList("coding.disabled-actions")) {
            try {
                disabled = disabled.toUpperCase().replace("-", "_");
                type = ActionType.valueOf(disabled);
                this.disabledActions.add(type.name());
                ++count;
            }
            catch (Exception ignored) {
                unknownBlocks.add(disabled);
            }
        }
        for (String disabled : config.getStringList("coding.disabled-conditions")) {
            try {
                disabled = disabled.toUpperCase().replace("-", "_");
                type = ActionType.valueOf(disabled);
                this.disabledConditions.add(type.name());
                ++count;
            }
            catch (Exception ignored) {
                unknownBlocks.add(disabled);
            }
        }
        for (String disabled : config.getStringList("coding.disabled-events")) {
            try {
                disabled = disabled.toUpperCase().replace("-", "_");
                type = ExecutorType.valueOf(disabled);
                this.disabledEvents.add(type.name());
                ++count;
            }
            catch (Exception ignored) {
                unknownBlocks.add(disabled);
            }
        }
        if (count >= 1) {
            OpenCreative.getPlugin().getLogger().info("Disabled " + count + " coding blocks!");
        }
        if (!unknownBlocks.isEmpty()) {
            ErrorUtils.sendWarningErrorMessage("Can't recognize these coding blocks in disabled list, do they exist? " + String.valueOf(unknownBlocks));
        }
    }

    private void loadSounds(FileConfiguration config, String soundsTheme) {
        this.sounds.clear();
        ConfigurationSection soundsSection = config.getConfigurationSection("sounds." + soundsTheme);
        if (soundsSection != null) {
            for (String key : soundsSection.getKeys(false)) {
                try {
                    Sounds type = Sounds.valueOf(key.toUpperCase().replace("-", "_"));
                    String sound = soundsSection.getString(key + ".name", "");
                    float pitch = (float)soundsSection.getDouble(key + ".name", 1.0);
                    this.sounds.put(type, new SettingsSound(sound, pitch));
                }
                catch (Exception ignored) {
                    ErrorUtils.sendWarningErrorMessage("Sound " + key.toLowerCase() + " doesn't exists.");
                }
            }
        }
        if (!this.sounds.isEmpty()) {
            OpenCreative.getPlugin().getLogger().info("Added " + this.sounds.size() + " custom sounds");
        }
    }

    private void loadItems(FileConfiguration config) {
        this.items.clear();
        ConfigurationSection itemsSection = config.getConfigurationSection("items");
        if (itemsSection != null) {
            for (String key : itemsSection.getKeys(false)) {
                try {
                    Items type = Items.valueOf(key.toUpperCase().replace("-", "_"));
                    ItemStack item = null;
                    if (itemsSection.isString(key)) {
                        Material material = Material.getMaterial((String)itemsSection.getString(key, "").toUpperCase());
                        if (material != null) {
                            item = new ItemStack(material);
                        }
                    } else {
                        item = itemsSection.getItemStack(key);
                    }
                    if (item == null) continue;
                    this.items.put(type, new SettingsItem(item));
                }
                catch (Exception ignored) {
                    ErrorUtils.sendWarningErrorMessage("Item " + key.toLowerCase() + " doesn't exists.");
                }
            }
        }
        if (!this.items.isEmpty()) {
            OpenCreative.getPlugin().getLogger().info("Added " + this.items.size() + " custom items");
        }
    }

    public boolean setSoundsTheme(String theme) {
        FileConfiguration config = OpenCreative.getPlugin().getConfig();
        if (config.getConfigurationSection("sounds." + theme) == null) {
            return false;
        }
        this.loadSounds(config, theme);
        OpenCreative.getPlugin().getConfig().set("sounds.theme", (Object)theme);
        OpenCreative.getPlugin().saveConfig();
        return true;
    }

    public boolean setCustomItem(Items type, ItemStack item) {
        FileConfiguration config = OpenCreative.getPlugin().getConfig();
        OpenCreative.getPlugin().getConfig().set("items." + type.name().toLowerCase().replace("_", "-"), (Object)item.serialize());
        OpenCreative.getPlugin().saveConfig();
        this.loadItems(config);
        return true;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        if (this.debug == debug) {
            return;
        }
        this.debug = debug;
        OpenCreative.getPlugin().getConfig().set("debug", (Object)debug);
        OpenCreative.getPlugin().saveConfig();
        OpenCreative.getPlugin().getLogger().info("Debug mode is " + (debug ? "enabled." : "disabled."));
        this.checkDebugAnnouncer();
    }

    public boolean isMaintenance() {
        return this.maintenance;
    }

    public boolean isLobbyClearInventory() {
        return this.lobbyClearInventory;
    }

    public void setMaintenance(boolean maintenance) {
        this.setMaintenance(maintenance, null);
    }

    public void setMaintenance(boolean maintenance, @Nullable CommandSender sender) {
        if (this.maintenance == maintenance) {
            return;
        }
        this.maintenance = maintenance;
        try {
            OpenCreative.getPlugin().getConfig().set("maintenance", (Object)maintenance);
            OpenCreative.getPlugin().saveConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (maintenance) {
            OpenCreative.getPlugin().getLogger().info("Maintenance mode started! Unloading planets, please wait...");
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                Sounds.MAINTENANCE_START.play((Audience)onlinePlayer);
                onlinePlayer.sendMessage(MessageUtils.getLocaleMessage("creative.maintenance.started"));
                for (Planet planet : OpenCreative.getPlanetsManager().getPlanets()) {
                    if (!planet.isLoaded()) continue;
                    for (Player player : planet.getPlayers()) {
                        PlayerUtils.teleportToLobby(player);
                    }
                }
            }
            new MaintenanceStartEvent(sender).callEvent();
        } else {
            OpenCreative.getPlugin().getLogger().info("Maintenance mode ended, now players can play in worlds.");
            for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                Sounds.MAINTENANCE_END.play((Audience)onlinePlayer);
                onlinePlayer.sendMessage(MessageUtils.getLocaleMessage("creative.maintenance.ended"));
            }
            new MaintenanceEndEvent(sender).callEvent();
        }
    }

    private void checkDebugAnnouncer() {
        if (this.announcer != null) {
            this.announcer.cancel();
        }
        if (this.debug) {
            this.announcer = new BukkitRunnable(this){

                public void run() {
                    Bukkit.getServer().sendActionBar((Component)Component.text((String)("\u00a7fOpen\u00a77Creative\u00a7b+ \u00a73" + OpenCreative.getVersion() + "\u00a77 Debug Mode. \u00a7fShhh, let's not leak our hard work...")));
                }
            };
            this.announcer.runTaskTimer((Plugin)OpenCreative.getPlugin(), 20L, 20L);
        } else {
            this.announcer = null;
        }
    }

    public Set<String> getAllowedResourcePackLinks() {
        return this.allowedResourcePackLinks;
    }

    public Set<Integer> getRecommendedWorldsIDs() {
        return this.recommendedWorldsIDs;
    }

    public void setCreativeChatEnabled(boolean creativeChatEnabled) {
        this.creativeChatEnabled = creativeChatEnabled;
    }

    public boolean isCreativeChatEnabled() {
        return this.creativeChatEnabled;
    }

    public PlayerListChanger getListChanger() {
        return this.listChanger;
    }

    public boolean isDisabledEvent(@NotNull ExecutorType event) {
        if (event == null) {
            Settings.$$$reportNull$$$0(0);
        }
        return this.disabledEvents.contains(event.name());
    }

    public boolean isDisabledAction(@NotNull ActionType action) {
        if (action == null) {
            Settings.$$$reportNull$$$0(1);
        }
        return this.disabledActions.contains(action.name());
    }

    public boolean isDisabledCondition(@NotNull ActionType condition) {
        if (condition == null) {
            Settings.$$$reportNull$$$0(2);
        }
        return this.disabledConditions.contains(condition.name());
    }

    public Groups getGroups() {
        return this.groups;
    }

    public Commands getCommands() {
        return this.commands;
    }

    public boolean isConsoleCriticalErrors() {
        return this.consoleCriticalErrors;
    }

    public boolean isConsoleWarnings() {
        return this.consoleWarnings;
    }

    public boolean isConsoleNotFoundMessage() {
        return this.consoleNotFoundMessage;
    }

    public String getCustomIdPattern() {
        return this.customIdPattern;
    }

    public int getCustomIdMaxLength() {
        return this.customIdMaxLength;
    }

    public int getCustomIdMinLength() {
        return this.customIdMinLength;
    }

    public int getWorldDescriptionMaxLength() {
        return this.worldDescriptionMaxLength;
    }

    public int getWorldDescriptionMinLength() {
        return this.worldDescriptionMinLength;
    }

    public int getWorldNameMaxLength() {
        return this.worldNameMaxLength;
    }

    public int getWorldNameMinLength() {
        return this.worldNameMinLength;
    }

    public int getWorldCreationMinSeconds() {
        return this.worldCreationMinSeconds;
    }

    public int getWorldReputationMinSeconds() {
        return this.worldReputationMinSeconds;
    }

    public Map<Sounds, SettingsSound> getSounds() {
        return this.sounds;
    }

    public Map<Items, SettingsItem> getItems() {
        return this.items;
    }

    public int getItemsContainerBigItemsLimit() {
        return this.itemsContainerBigItemsLimit;
    }

    public int getItemsMaxBookPagesAmount() {
        return this.itemsMaxBookPagesAmount;
    }

    public int getItemsMaxEnchantLevel() {
        return this.itemsMaxEnchantLevel;
    }

    public boolean isItemsRemoveAttributes() {
        return this.itemsRemoveAttributes;
    }

    public boolean isItemsRemoveClickableBooks() {
        return this.itemsRemoveClickableBooks;
    }

    public boolean isItemsRemoveCustomSpawnEggs() {
        return this.itemsRemoveCustomSpawnEggs;
    }

    public boolean isItemsRemoveBossSpawnEggs() {
        return this.itemsRemoveBossSpawnEggs;
    }

    public boolean isLegacySelectionMenu() {
        return this.legacySelectionMenu;
    }

    public boolean isLobbyDisableExplosions() {
        return this.lobbyDisableExplosions;
    }

    public boolean isLobbyDisallowDamagingMobs() {
        return this.lobbyDisallowDamagingMobs;
    }

    public boolean isLobbyDisallowDestroyingBlocks() {
        return this.lobbyDisallowDestroyingBlocks;
    }

    public boolean isLobbyDisallowPlacingBlocks() {
        return this.lobbyDisallowPlacingBlocks;
    }

    public boolean isLobbyDisallowSpawningMobs() {
        return this.lobbyDisallowSpawningMobs;
    }

    public boolean isLobbyDisallowWorldEdit() {
        return this.lobbyDisallowWorldEdit;
    }

    public int getItemsMaxEntityNameLength() {
        return this.itemsMaxEntityNameLength;
    }

    public int getItemsMaxPersistentDataSize() {
        return this.itemsMaxPersistentDataSize;
    }

    public int getItemsEntitiesMaxAmount() {
        return this.itemsEntitiesMaxAmount;
    }

    public int getItemsDisplayNameMaxLength() {
        return this.itemsDisplayNameMaxLength;
    }

    public int getItemsLoreLineMaxLength() {
        return this.itemsLoreLineMaxLength;
    }

    public int getItemsLoreLinesMaxAmount() {
        return this.itemsLoreLinesMaxAmount;
    }

    public int getModuleDescriptionMaxLength() {
        return this.moduleDescriptionMaxLength;
    }

    public int getModuleDescriptionMinLength() {
        return this.moduleDescriptionMinLength;
    }

    public int getModuleNameMaxLength() {
        return this.moduleNameMaxLength;
    }

    public int getModuleNameMinLength() {
        return this.moduleNameMinLength;
    }

    public boolean isItemFixerEnabled() {
        return this.itemFixerEnabled;
    }

    public boolean isEnabledCoding() {
        return this.enabledCoding;
    }

    public boolean isItemsClearCommandBlocksData() {
        return this.itemsClearCommandBlocksData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/settings/Settings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDisabledEvent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDisabledAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDisabledCondition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum PlayerListChanger {
        SPECTATOR,
        FULL,
        NONE;


        public static PlayerListChanger fromString(String string) {
            for (PlayerListChanger changer : PlayerListChanger.values()) {
                if (!string.equalsIgnoreCase(changer.name())) continue;
                return changer;
            }
            return FULL;
        }
    }
}

