/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.settings.groups;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.settings.groups.LimitModifier;
import ua.mcchickenstudio.opencreative.settings.groups.LimitType;

public class Group {
    private final String name;
    private final String permission;
    private final int worldSize;
    private final int worldsLimit;
    private final int modulesLimit;
    private final int codingPlatformsLimit;
    private final int scriptSizeLimit;
    private final int chatCooldown;
    private final int genericCommandCooldown;
    private final int creativeChatCooldown;
    private final int advertisementCooldown;
    private final int modulesUsageCooldown;
    private final int blocksDuplicationCooldown;
    private final double likeReward;
    private final double advertisementPrice;
    private final Set<String> playPermissions = new HashSet<String>();
    private final Set<String> buildPermissions = new HashSet<String>();
    private final Set<String> devPermissions = new HashSet<String>();
    private final Set<String> lobbyPermissions = new HashSet<String>();
    private final Map<LimitType, LimitModifier> limits = new HashMap<LimitType, LimitModifier>();

    public Group(String name, FileConfiguration config) {
        this.name = name;
        String path = "groups." + name + ".";
        this.permission = config.getString(path + "permission", "default");
        this.worldsLimit = config.getInt(path + "creating-world.limit", 1);
        this.modulesLimit = config.getInt(path + "creating-module.limit", 1);
        this.worldSize = config.getInt(path + "world.size", 25);
        this.likeReward = config.getInt(path + "world.like-reward", 1);
        this.advertisementPrice = config.getInt(path + "world.advertisement-cost", 0);
        this.codingPlatformsLimit = config.getInt(path + "world.limits.coding-platforms", 1);
        this.scriptSizeLimit = config.getInt(path + "world.limits.script-size", 10);
        this.genericCommandCooldown = config.getInt(path + "cooldowns.generic-command", 5);
        this.advertisementCooldown = config.getInt(path + "cooldowns.advertisement", 120);
        this.creativeChatCooldown = config.getInt(path + "cooldowns.creative-chat", 5);
        this.modulesUsageCooldown = config.getInt(path + "cooldowns.module-usage", 7);
        this.blocksDuplicationCooldown = config.getInt(path + "cooldowns.duplication-usage", 7);
        this.chatCooldown = config.getInt(path + "cooldowns.world-chat", 2);
        this.playPermissions.addAll(config.getStringList(path + "world.play-permissions"));
        this.buildPermissions.addAll(config.getStringList(path + "world.build-permissions"));
        this.devPermissions.addAll(config.getStringList(path + "world.dev-permissions"));
        this.lobbyPermissions.addAll(config.getStringList(path + "lobby-permissions"));
        for (LimitType type : LimitType.values()) {
            this.limits.put(type, new LimitModifier(config.getInt(path + "world.limits." + type.getPath(), 0), config.getInt(path + "world.per-player-limit-modifiers." + type.getPath(), 0)));
        }
    }

    public String getName() {
        return this.name;
    }

    public int getAdvertisementCooldown() {
        return this.advertisementCooldown;
    }

    public int getChatCooldown() {
        return this.chatCooldown;
    }

    public int getCreativeChatCooldown() {
        return this.creativeChatCooldown;
    }

    public int getBlocksDuplicationCooldown() {
        return this.blocksDuplicationCooldown;
    }

    public int getModuleManipulationCooldown() {
        return this.modulesUsageCooldown;
    }

    public int getGenericCommandCooldown() {
        return this.genericCommandCooldown;
    }

    public int getWorldSize() {
        return this.worldSize;
    }

    public int getWorldsLimit() {
        return this.worldsLimit;
    }

    public int getModulesLimit() {
        return this.modulesLimit;
    }

    public Set<String> getBuildPermissions() {
        return this.buildPermissions;
    }

    public Set<String> getDevPermissions() {
        return this.devPermissions;
    }

    public Set<String> getPlayPermissions() {
        return this.playPermissions;
    }

    public Set<String> getLobbyPermissions() {
        return this.lobbyPermissions;
    }

    public String getPermission() {
        return this.permission;
    }

    @NotNull
    public LimitModifier getLimit(LimitType type) {
        for (LimitType limitType : this.limits.keySet()) {
            if (limitType != type) continue;
            LimitModifier limitModifier = this.limits.get((Object)type);
            if (limitModifier == null) {
                Group.$$$reportNull$$$0(0);
            }
            return limitModifier;
        }
        return new LimitModifier(0, 0);
    }

    public int getCodingPlatformsLimit() {
        return this.codingPlatformsLimit;
    }

    public double getAdvertisementPrice() {
        return this.advertisementPrice;
    }

    public double getLikeReward() {
        return this.likeReward;
    }

    public int getScriptSizeLimit() {
        return this.scriptSizeLimit;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "ua/mcchickenstudio/opencreative/settings/groups/Group", "getLimit"));
    }
}

