/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.settings.groups;

import java.util.LinkedHashSet;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.settings.groups.Group;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;

public final class Groups {
    private final Set<Group> groups = new LinkedHashSet<Group>();

    public void load() {
        this.groups.clear();
        FileConfiguration config = OpenCreative.getPlugin().getConfig();
        ConfigurationSection section = config.getConfigurationSection("groups");
        if (section == null) {
            ErrorUtils.sendCriticalErrorMessage("Can't load player groups, section `groups` in config.yml is empty.");
            return;
        }
        for (String group : section.getKeys(false)) {
            this.registerGroup(new Group(group, config));
        }
    }

    @NotNull
    public Group getDefaultGroup() {
        for (Group group : this.groups) {
            if (!group.getPermission().equalsIgnoreCase("default")) continue;
            Group group2 = group;
            if (group2 == null) {
                Groups.$$$reportNull$$$0(0);
            }
            return group2;
        }
        return new Group("default", OpenCreative.getPlugin().getConfig());
    }

    @NotNull
    public Group getGroup(String name) {
        for (Group group : this.groups) {
            if (!group.getName().equalsIgnoreCase(name)) continue;
            Group group2 = group;
            if (group2 == null) {
                Groups.$$$reportNull$$$0(1);
            }
            return group2;
        }
        Group group = this.getDefaultGroup();
        if (group == null) {
            Groups.$$$reportNull$$$0(2);
        }
        return group;
    }

    @NotNull
    public Group getGroup(Player player) {
        Group currentGroup = this.getDefaultGroup();
        for (Group group : this.groups) {
            if (!player.hasPermission(group.getPermission())) continue;
            currentGroup = group;
        }
        Group group = currentGroup;
        if (group == null) {
            Groups.$$$reportNull$$$0(3);
        }
        return group;
    }

    public void registerGroup(Group group) {
        OpenCreative.getPlugin().getLogger().info("Registered player group " + group.getName());
        this.groups.add(group);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "ua/mcchickenstudio/opencreative/settings/groups/Groups";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

