/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils;

import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;

public final class Advancement {
    private final Material material;
    private final AdvancementStyle style;
    private final String title;
    private final String message;
    private final NamespacedKey nameSpacedKey;

    private Advancement(@NotNull ItemStack itemStack, @NotNull AdvancementStyle style, @NotNull String title, @NotNull String message) {
        if (itemStack == null) {
            Advancement.$$$reportNull$$$0(0);
        }
        if (style == null) {
            Advancement.$$$reportNull$$$0(1);
        }
        if (title == null) {
            Advancement.$$$reportNull$$$0(2);
        }
        if (message == null) {
            Advancement.$$$reportNull$$$0(3);
        }
        this.nameSpacedKey = new NamespacedKey((Plugin)OpenCreative.getPlugin(), UUID.randomUUID().toString());
        this.material = itemStack.getType();
        this.style = style;
        this.title = title;
        this.message = message;
    }

    public static Advancement make(@NotNull ItemStack itemStack, @NotNull AdvancementStyle style, @NotNull String title, @NotNull String message) {
        if (itemStack == null) {
            Advancement.$$$reportNull$$$0(4);
        }
        if (style == null) {
            Advancement.$$$reportNull$$$0(5);
        }
        if (title == null) {
            Advancement.$$$reportNull$$$0(6);
        }
        if (message == null) {
            Advancement.$$$reportNull$$$0(7);
        }
        return new Advancement(itemStack, style, title, message);
    }

    public void show(@NotNull Player player) {
        if (player == null) {
            Advancement.$$$reportNull$$$0(8);
        }
        this.load();
        org.bukkit.advancement.Advancement advancement = Bukkit.getAdvancement((NamespacedKey)this.nameSpacedKey);
        if (advancement == null) {
            return;
        }
        player.getAdvancementProgress(advancement).awardCriteria("trigger");
        Bukkit.getScheduler().runTaskLater((Plugin)OpenCreative.getPlugin(), () -> player.getAdvancementProgress(advancement).revokeCriteria("trigger"), 10L);
    }

    private void load() {
        Bukkit.getUnsafe().loadAdvancement(this.nameSpacedKey, "{\n    \"criteria\": {\n        \"trigger\": {\n            \"trigger\": \"minecraft:impossible\"\n        }\n    },\n    \"display\": {\n        \"icon\": {\n            \"id\": \"minecraft:" + this.material.toString().toLowerCase() + "\"\n        },\n        \"title\": {\n            \"text\": \"" + this.title + "\n" + this.message + "\"\n        },\n        \"description\": {\n            \"text\": \"\"\n        },\n        \"background\": \"minecraft:textures/gui/advancements/backgrounds/adventure.png\",\n        \"frame\": \"" + this.style.toString().toLowerCase() + "\",\n        \"announce_to_chat\": false,\n        \"show_toast\": true,\n        \"hidden\": true\n    },\n    \"requirements\": [\n        [\n            \"trigger\"\n        ]\n    ]\n}");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemStack";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "style";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/utils/Advancement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "make";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "show";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum AdvancementStyle {
        GOAL,
        TASK,
        CHALLENGE;

    }
}

