/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.blocks.actions.ActionCategory;
import ua.mcchickenstudio.opencreative.planets.DevPlatform;

public final class BlockUtils {
    public static boolean setSignLine(Location location, int line, String text) {
        Block block = location.getBlock();
        if (line < 1 || line > 4) {
            return false;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof Sign)) {
            return false;
        }
        Sign sign = (Sign)blockState;
        SignSide side = sign.getSide(Side.FRONT);
        side.line(line - 1, (Component)Component.text((String)text));
        sign.update();
        return true;
    }

    public static boolean isSignLineEmpty(Location location, int line) {
        Block block = location.getBlock();
        if (line < 1 || line > 4) {
            return true;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof Sign)) {
            return true;
        }
        Sign sign = (Sign)blockState;
        SignSide side = sign.getSide(Side.FRONT);
        TextComponent textComponent = (TextComponent)side.line(line - 1);
        return textComponent.content().isEmpty();
    }

    public static String getSignLine(Location location, int line) {
        Block block = location.getBlock();
        if (line < 1 || line > 4) {
            return null;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof Sign)) {
            return null;
        }
        Sign sign = (Sign)blockState;
        SignSide side = sign.getSide(Side.FRONT);
        TextComponent textComponent = (TextComponent)side.line(line - 1);
        return textComponent.content();
    }

    public static void sendSignChange(Location location, final Player player, int lineNumber, String newLine) {
        final Block block = location.getBlock();
        BlockState blockState = block.getState();
        if (!(blockState instanceof Sign)) {
            return;
        }
        Sign sign = (Sign)blockState;
        final List newLines = sign.getSide(Side.FRONT).lines();
        newLines.set(lineNumber - 1, Component.text((String)newLine));
        new BukkitRunnable(){

            public void run() {
                player.sendSignChange(block.getLocation(), newLines);
            }
        }.runTaskLater((Plugin)OpenCreative.getPlugin(), 5L);
    }

    public static int getClosingBracketX(DevPlatform platform, Block conditionBlock) {
        Location location = conditionBlock.getLocation();
        World world = location.getWorld();
        ArrayList<CallSite> conditions = new ArrayList<CallSite>();
        try {
            for (double x = location.getX() + 2.0; x < (double)(platform.getEndCoordinate() - 4); x += 2.0) {
                Block block = world.getBlockAt(new Location(world, x, (double)location.getBlockY(), (double)location.getBlockZ()));
                ActionCategory category = ActionCategory.getByMaterial(block.getType());
                if (block.getType() == Material.AIR) {
                    if (block.getRelative(BlockFace.EAST).getType() != Material.PISTON) continue;
                    if (!conditions.isEmpty()) {
                        String last = (String)conditions.getLast();
                        conditions.remove(last);
                        continue;
                    }
                    return block.getRelative(BlockFace.EAST).getX();
                }
                if (category == null || !category.isCondition() || block.getRelative(BlockFace.EAST).getType() != Material.PISTON) continue;
                conditions.add((CallSite)((Object)("cound" + block.getX())));
            }
        }
        catch (Exception exception) {
            return -1;
        }
        return -1;
    }

    public static boolean isOutOfBorders(Location location) {
        WorldBorder border = location.getWorld().getWorldBorder();
        Location borderCenter = border.getCenter();
        double radius = border.getSize() / 2.0 + 1.0;
        double borderCenterX1 = borderCenter.getX() + radius;
        double borderCenterX2 = borderCenter.getX() - radius;
        double borderCenterZ1 = borderCenter.getZ() + radius;
        double borderCenterZ2 = borderCenter.getZ() - radius;
        double playerX = location.getX();
        double playerZ = location.getZ();
        if (!(borderCenterX1 > playerX) || !(playerX > borderCenterX2)) {
            return true;
        }
        return !(borderCenterZ1 > playerZ) || !(playerZ > borderCenterZ2);
    }

    public static void copySignData(Sign oldSign, Sign sign) {
        for (int i = 0; i < oldSign.getSide(Side.FRONT).lines().size(); i = (int)((byte)(i + 1))) {
            sign.getSide(Side.FRONT).line(i, oldSign.getSide(Side.FRONT).line(i));
        }
        sign.getSide(Side.FRONT).setGlowingText(oldSign.getSide(Side.FRONT).isGlowingText());
        sign.setBlockData(oldSign.getBlockData());
        sign.update();
    }

    public static int getBeginningBracketX(Block firstBlock) {
        Location location = firstBlock.getLocation();
        World world = location.getWorld();
        ArrayList<CallSite> conditions = new ArrayList<CallSite>();
        for (int x = location.getBlockX() - 2; x >= 6; x -= 2) {
            Block block = world.getBlockAt(new Location(world, (double)x, (double)location.getBlockY(), (double)location.getBlockZ()));
            ActionCategory category = ActionCategory.getByMaterial(block.getType());
            if (block.getType() == Material.AIR) {
                if (block.getRelative(BlockFace.WEST).getType() != Material.PISTON) continue;
                if (!conditions.isEmpty()) {
                    String last = (String)conditions.getLast();
                    conditions.remove(last);
                    continue;
                }
                return block.getRelative(BlockFace.WEST).getX();
            }
            if (category == null || !category.isCondition() || block.getRelative(BlockFace.WEST).getType() != Material.PISTON) continue;
            conditions.add((CallSite)((Object)("cound" + block.getX())));
        }
        return -1;
    }
}

