/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils;

import io.papermc.paper.persistence.PersistentDataContainerView;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.BlockState;
import org.bukkit.block.CommandBlock;
import org.bukkit.block.EntityBlockStorage;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SpawnEggMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.variables.ValueType;
import ua.mcchickenstudio.opencreative.settings.Settings;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;

public final class ItemUtils {
    private static final NamespacedKey ITEM_ID_KEY = new NamespacedKey((Plugin)OpenCreative.getPlugin(), "oc_item_id");
    private static final NamespacedKey ITEM_TYPE_KEY = new NamespacedKey((Plugin)OpenCreative.getPlugin(), "oc_item_type");
    private static final NamespacedKey CODING_VALUE_KEY = new NamespacedKey((Plugin)OpenCreative.getPlugin(), "oc_value_type");
    private static final NamespacedKey CODING_PARTICLE_TYPE_KEY = new NamespacedKey((Plugin)OpenCreative.getPlugin(), "oc_particle_type");
    private static final NamespacedKey CODING_VARIABLE_TYPE_KEY = new NamespacedKey((Plugin)OpenCreative.getPlugin(), "oc_variable_type");
    private static final NamespacedKey CODING_TARGET_TYPE_KEY = new NamespacedKey((Plugin)OpenCreative.getPlugin(), "oc_target_type");
    private static final NamespacedKey CODING_DO_NOT_DROP_ME_KEY = new NamespacedKey((Plugin)OpenCreative.getPlugin(), "oc_do_not_drop_me");
    private static final NamespacedKey CODING_LOCATION_X = new NamespacedKey((Plugin)OpenCreative.getPlugin(), "oc_loc_x");
    private static final NamespacedKey CODING_LOCATION_Y = new NamespacedKey((Plugin)OpenCreative.getPlugin(), "oc_loc_y");
    private static final NamespacedKey CODING_LOCATION_Z = new NamespacedKey((Plugin)OpenCreative.getPlugin(), "oc_loc_z");

    public static NamespacedKey getCodingValueKey() {
        return CODING_VALUE_KEY;
    }

    public static NamespacedKey getCodingVariableTypeKey() {
        return CODING_VARIABLE_TYPE_KEY;
    }

    public static NamespacedKey getCodingDoNotDropMeKey() {
        return CODING_DO_NOT_DROP_ME_KEY;
    }

    public static NamespacedKey getCodingLocationX() {
        return CODING_LOCATION_X;
    }

    public static NamespacedKey getCodingLocationY() {
        return CODING_LOCATION_Y;
    }

    public static NamespacedKey getCodingLocationZ() {
        return CODING_LOCATION_Z;
    }

    public static NamespacedKey getCodingParticleTypeKey() {
        return CODING_PARTICLE_TYPE_KEY;
    }

    public static NamespacedKey getItemTypeKey() {
        return ITEM_TYPE_KEY;
    }

    public static NamespacedKey getItemIdKey() {
        return ITEM_ID_KEY;
    }

    public static NamespacedKey getCodingTargetTypeKey() {
        return CODING_TARGET_TYPE_KEY;
    }

    public static ItemStack setPersistentData(ItemStack item, NamespacedKey key, String value) {
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(key, PersistentDataType.STRING, (Object)value);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack setPersistentData(ItemStack item, NamespacedKey key, double value) {
        ItemMeta meta = item.getItemMeta();
        PersistentDataContainer container = meta.getPersistentDataContainer();
        container.set(key, PersistentDataType.DOUBLE, (Object)value);
        item.setItemMeta(meta);
        return item;
    }

    public static ItemStack createItem(ItemStack item, String localizationPath, String persistentData) {
        ItemStack itemStack = ItemUtils.clearItemFlags(item.clone());
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(MessageUtils.getLocaleItemName(localizationPath + ".name"));
        itemMeta.setLore(MessageUtils.getLocaleItemDescription(localizationPath + ".lore"));
        itemStack.setItemMeta(itemMeta);
        ItemUtils.setPersistentData(itemStack, ItemUtils.getItemTypeKey(), persistentData);
        return itemStack;
    }

    public static ItemStack createItem(Material material, int amount, String localizationPath, String persistentData) {
        ItemStack itemStack = ItemUtils.createItem(material, amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(MessageUtils.getLocaleItemName(localizationPath + ".name"));
        itemMeta.setLore(MessageUtils.getLocaleItemDescription(localizationPath + ".lore"));
        itemStack.setItemMeta(itemMeta);
        ItemUtils.setPersistentData(itemStack, ItemUtils.getItemTypeKey(), persistentData);
        return itemStack;
    }

    public static ItemStack createItem(Material material, int amount, String localizationPath) {
        ItemStack itemStack = ItemUtils.createItem(material, amount);
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(MessageUtils.getLocaleItemName(localizationPath + ".name"));
        itemMeta.setLore(MessageUtils.getLocaleItemDescription(localizationPath + ".lore"));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack createItem(ItemStack item, String localizationPath) {
        ItemStack itemStack = ItemUtils.clearItemFlags(item.clone());
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(MessageUtils.getLocaleItemName(localizationPath + ".name"));
        itemMeta.setLore(MessageUtils.getLocaleItemDescription(localizationPath + ".lore"));
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public static ItemStack createItem(Material material, int amount, String localizationPath, Object value) {
        ItemStack itemStack = ItemUtils.createItem(material, amount, localizationPath);
        ItemMeta meta = ItemUtils.getOrCreateItemMeta(itemStack);
        PersistentDataContainer container = itemStack.getItemMeta().getPersistentDataContainer();
        container.set(CODING_VALUE_KEY, PersistentDataType.BYTE, (Object)((Byte)value));
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack createItem(Material material, int amount) {
        ItemStack itemStack = new ItemStack(material, amount);
        ItemMeta itemMeta = ItemUtils.getOrCreateItemMeta(itemStack);
        itemMeta.setDisplayName(" ");
        itemStack.setItemMeta(itemMeta);
        return ItemUtils.clearItemFlags(itemStack);
    }

    public static ItemStack clearItemFlags(ItemStack itemStack) {
        ItemMeta meta = itemStack.getItemMeta();
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES, ItemFlag.HIDE_ADDITIONAL_TOOLTIP, ItemFlag.HIDE_ARMOR_TRIM, ItemFlag.HIDE_DESTROYS, ItemFlag.HIDE_UNBREAKABLE, ItemFlag.HIDE_ENCHANTS, ItemFlag.HIDE_DYE, ItemFlag.HIDE_PLACED_ON, ItemFlag.HIDE_STORED_ENCHANTS, ItemFlag.HIDE_ITEM_SPECIFICS});
        if (!meta.hasAttributeModifiers()) {
            meta.addAttributeModifier(Attribute.GENERIC_ARMOR, new AttributeModifier(new NamespacedKey((Plugin)OpenCreative.getPlugin(), "hide_attributes"), 0.0, AttributeModifier.Operation.ADD_NUMBER));
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static ItemStack clearItemMeta(ItemStack itemStack) {
        ItemMeta meta = ItemUtils.getOrCreateItemMeta(itemStack);
        meta.displayName(null);
        meta.lore(null);
        meta.removeEnchantments();
        HashSet persistentKeys = new HashSet(meta.getPersistentDataContainer().getKeys());
        for (NamespacedKey key : persistentKeys) {
            meta.getPersistentDataContainer().remove(key);
        }
        itemStack.setItemMeta(meta);
        return itemStack;
    }

    public static boolean itemEquals(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == null || itemStack2 == null) {
            return false;
        }
        if (itemStack.getType() != itemStack2.getType()) {
            return false;
        }
        if (itemStack.getItemMeta() != null && itemStack.getItemMeta() != null) {
            if (!itemStack.getItemMeta().getDisplayName().equalsIgnoreCase(itemStack2.getItemMeta().getDisplayName())) {
                return false;
            }
            return !itemStack.getItemMeta().hasLore() || !itemStack2.getItemMeta().hasLore() || itemStack.getItemMeta().getLore().equals(itemStack2.getItemMeta().getLore());
        }
        return true;
    }

    public static ItemStack replacePlaceholderInName(ItemStack item, String placeholder, Object value) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(meta.getDisplayName().replace(placeholder, value.toString()));
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack replacePlaceholderInLore(ItemStack item, String placeholder, Object value) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null && meta.getLore() != null) {
            ArrayList<String> newLore = new ArrayList<String>();
            List oldLore = meta.getLore();
            for (String loreLine : oldLore) {
                newLore.add(loreLine.replace(placeholder, value.toString()));
            }
            meta.setLore(newLore);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack setDisplayName(ItemStack item, String displayName) {
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(displayName);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack setLore(ItemStack item, List<String> lore) {
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack addLoreAtBegin(ItemStack item, String loreLine) {
        if (loreLine.isEmpty()) {
            return item;
        }
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            ArrayList<String> lore = new ArrayList<String>();
            lore.add(loreLine);
            if (meta.hasLore()) {
                lore.addAll(meta.getLore());
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack addLoreAtEnd(ItemStack item, String loreLine) {
        if (loreLine.isEmpty()) {
            return item;
        }
        if (item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            List<String> lore = new ArrayList<String>();
            if (meta.hasLore()) {
                lore = meta.getLore();
            }
            lore.add(loreLine);
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ValueType getValueType(ItemStack item) {
        String typeString = ItemUtils.getPersistentData(item, ItemUtils.getCodingValueKey());
        try {
            return ValueType.valueOf(typeString);
        }
        catch (IllegalArgumentException e) {
            return ValueType.ITEM;
        }
    }

    public static String getItemType(ItemStack item) {
        return ItemUtils.getPersistentData(item, ItemUtils.getItemTypeKey());
    }

    public static String getPersistentData(ItemStack item, NamespacedKey key) {
        if (item == null) {
            return "";
        }
        if (item.getItemMeta() == null) {
            return "";
        }
        PersistentDataContainer container = item.getItemMeta().getPersistentDataContainer();
        if (!container.has(key)) {
            return "";
        }
        String dataType = (String)container.get(key, PersistentDataType.STRING);
        if (dataType == null) {
            return "";
        }
        return dataType;
    }

    public static ItemStack getItemWithIgnoreData(ItemStack item, boolean removeAmount, boolean removeName, boolean removeLore, boolean removeFlags, boolean removeEnchantments, boolean removeMaterial, boolean removeDurability) {
        ItemStack newItem = item.clone();
        ItemMeta meta = newItem.getItemMeta();
        if (removeAmount) {
            newItem.setAmount(1);
        }
        if (meta != null) {
            if (removeName) {
                meta.displayName((Component)Component.text((String)""));
            }
            if (removeLore) {
                meta.lore(new ArrayList());
            }
            if (removeDurability && meta instanceof Damageable) {
                Damageable damageable = (Damageable)meta;
                damageable.setDamage(0);
            }
            newItem.setItemMeta(meta);
        }
        if (removeMaterial) {
            newItem.setType(Material.DIAMOND);
        }
        if (removeEnchantments) {
            newItem.removeEnchantments();
        }
        if (removeFlags) {
            for (ItemFlag flag : newItem.getItemFlags()) {
                newItem.removeItemFlags(new ItemFlag[]{flag});
            }
        }
        return newItem;
    }

    @NotNull
    public static ItemMeta getOrCreateItemMeta(@NotNull ItemStack item) {
        if (item == null) {
            ItemUtils.$$$reportNull$$$0(0);
        }
        ItemMeta itemMeta = item.hasItemMeta() ? item.getItemMeta() : Bukkit.getItemFactory().getItemMeta(item.getType());
        if (itemMeta == null) {
            ItemUtils.$$$reportNull$$$0(1);
        }
        return itemMeta;
    }

    public static ItemStack fixItem(@NotNull ItemStack item) {
        Settings settings;
        if (item == null) {
            ItemUtils.$$$reportNull$$$0(2);
        }
        if (!(settings = OpenCreative.getSettings()).isItemFixerEnabled()) {
            return item;
        }
        return ItemUtils.fixItem(item, settings.getItemsDisplayNameMaxLength(), settings.getItemsLoreLineMaxLength(), settings.getItemsLoreLinesMaxAmount(), settings.getItemsMaxEnchantLevel(), settings.getItemsMaxBookPagesAmount(), settings.isItemsRemoveClickableBooks(), settings.getItemsContainerBigItemsLimit(), settings.getItemsEntitiesMaxAmount(), settings.isItemsRemoveCustomSpawnEggs(), settings.isItemsRemoveBossSpawnEggs(), settings.isItemsRemoveAttributes(), settings.isItemsClearCommandBlocksData());
    }

    public static ItemStack fixItem(@NotNull ItemStack item, int displayNameMaxLength, int loreLineMaxLength, int loreLinesLimit, int maxEnchantLevel, int bookPagesLimit, boolean removeClickableBooks, int containerBigItemsLimit, int entitiesLimit, boolean removeCustomEggs, boolean removeBossEggs, boolean removeAttributes, boolean clearCommandBlocksData) {
        block51: {
            if (item == null) {
                ItemUtils.$$$reportNull$$$0(3);
            }
            try {
                List lore;
                String displayName;
                Component component;
                ItemMeta meta = item.getItemMeta();
                if (meta == null) {
                    return item;
                }
                if (meta.hasEnchants()) {
                    int enchantsLimit = 15;
                    if (meta.getEnchants().size() > enchantsLimit) {
                        ErrorUtils.sendDebug("[ITEMS] Destroyed item with too many enchantments.");
                        item.setType(Material.AIR);
                        item.setItemMeta(null);
                    } else {
                        ArrayList<Enchantment> badEnchants = new ArrayList<Enchantment>();
                        for (Enchantment enchant : meta.getEnchants().keySet()) {
                            if (meta.getEnchantLevel(enchant) <= maxEnchantLevel) continue;
                            badEnchants.add(enchant);
                        }
                        if (!badEnchants.isEmpty()) {
                            for (Enchantment enchantment : badEnchants) {
                                meta.removeEnchant(enchantment);
                            }
                            item.setItemMeta(meta);
                            ErrorUtils.sendDebug("[ITEMS] Cleared enchants");
                        }
                    }
                }
                if (meta.hasAttributeModifiers() && meta.getAttributeModifiers() != null && removeAttributes) {
                    Set attributes = meta.getAttributeModifiers().keySet();
                    int attributesLimit = 20;
                    if (meta.getEnchants().size() > attributesLimit) {
                        ErrorUtils.sendDebug("[ITEMS] Destroyed item with too many attributes.");
                        item.setType(Material.AIR);
                        item.setItemMeta(null);
                        return item;
                    }
                    for (Attribute attribute : attributes) {
                        if (attribute == Attribute.GENERIC_ARMOR) continue;
                        meta.removeAttributeModifier(attribute);
                        ErrorUtils.sendDebug("[ITEMS] Cleared attributes");
                    }
                }
                if (!meta.getPersistentDataContainer().isEmpty()) {
                    int persistentDataKeysLimit = 15;
                    if (meta.getPersistentDataContainer().getKeys().size() > persistentDataKeysLimit) {
                        ErrorUtils.sendDebug("[ITEMS] Destroyed item with too many persistent data keys.");
                        item.setType(Material.AIR);
                        item.setItemMeta(null);
                        return item;
                    }
                    if (ItemUtils.getPersistentDataAmount(item) > OpenCreative.getSettings().getItemsMaxPersistentDataSize()) {
                        for (NamespacedKey key : item.getPersistentDataContainer().getKeys()) {
                            meta.getPersistentDataContainer().remove(key);
                        }
                        item.setItemMeta(meta);
                        ErrorUtils.sendDebug("[ITEMS] Cleared persistent data");
                    }
                }
                if (meta.hasDisplayName() && (component = meta.displayName()) != null && (displayName = LegacyComponentSerializer.legacySection().serialize(component)).length() > displayNameMaxLength) {
                    displayName = displayName.substring(0, displayNameMaxLength);
                    meta.displayName((Component)LegacyComponentSerializer.legacySection().deserialize(displayName));
                    item.setItemMeta(meta);
                    ErrorUtils.sendDebug("[ITEMS] Fixed too long display name");
                }
                if (meta.hasLore() && (lore = item.lore()) != null) {
                    if (lore.size() > loreLinesLimit) {
                        meta.lore(null);
                        item.setItemMeta(meta);
                        ErrorUtils.sendDebug("[ITEMS] Fixed too many lore lines");
                    }
                    ArrayList<TextComponent> newLore = new ArrayList<TextComponent>(lore);
                    int loreIndex = 0;
                    boolean needsToChange = false;
                    for (Component loreLine : lore) {
                        String line = LegacyComponentSerializer.legacySection().serialize(loreLine);
                        if (line.length() > loreLineMaxLength) {
                            needsToChange = true;
                            line = line.substring(0, loreLineMaxLength);
                            newLore.set(loreIndex, LegacyComponentSerializer.legacySection().deserialize(line));
                            ErrorUtils.sendDebug("[ITEMS] Fixed too long lore line");
                        }
                        ++loreIndex;
                    }
                    if (needsToChange) {
                        meta.lore(newLore);
                        item.setItemMeta(meta);
                    }
                }
                ItemMeta itemMeta = meta;
                Objects.requireNonNull(itemMeta);
                ItemMeta itemMeta2 = itemMeta;
                int n = 0;
                block14: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockStateMeta.class, BlockStateMeta.class, BlockStateMeta.class, BookMeta.class, SpawnEggMeta.class}, (Object)itemMeta2, n)) {
                        case 0: {
                            BlockStateMeta blockMeta = (BlockStateMeta)itemMeta2;
                            BlockState blockState = blockMeta.getBlockState();
                            if (!(blockState instanceof InventoryHolder)) {
                                n = 1;
                                continue block14;
                            }
                            InventoryHolder holder = (InventoryHolder)blockState;
                            int insideContainers = 0;
                            ItemStack[] items = holder.getInventory().getContents();
                            int itemsLimit = 30;
                            if (meta.getEnchants().size() > itemsLimit) {
                                ErrorUtils.sendDebug("[ITEMS] Destroyed container item with too many items.");
                                item.setType(Material.AIR);
                                item.setItemMeta(null);
                                return item;
                            }
                            for (ItemStack insideItem : items) {
                                InventoryHolder insideHolder;
                                BlockStateMeta insideMeta;
                                BlockState blockState2;
                                if (insideItem == null) continue;
                                if (insideItem instanceof BlockStateMeta && (blockState2 = (insideMeta = (BlockStateMeta)insideItem).getBlockState()) instanceof InventoryHolder && !(insideHolder = (InventoryHolder)blockState2).getInventory().isEmpty()) {
                                    ++insideContainers;
                                } else if (insideItem.getItemMeta() instanceof BookMeta) {
                                    ++insideContainers;
                                }
                                if (insideContainers > containerBigItemsLimit) break;
                            }
                            if (insideContainers > containerBigItemsLimit) {
                                item.setType(Material.AIR);
                                item.setItemMeta(null);
                                ErrorUtils.sendDebug("[ITEMS] Destroyed container with a lot of items");
                                break block14;
                            }
                            break block51;
                        }
                        case 1: {
                            BlockStateMeta blockMeta = (BlockStateMeta)itemMeta2;
                            BlockState itemsLimit = blockMeta.getBlockState();
                            if (!(itemsLimit instanceof CommandBlock)) {
                                n = 2;
                                continue block14;
                            }
                            CommandBlock block = (CommandBlock)itemsLimit;
                            if (clearCommandBlocksData) {
                                if (!block.getCommand().isEmpty()) {
                                    block.setCommand(null);
                                }
                                blockMeta.setBlockState((BlockState)block);
                                item.setItemMeta((ItemMeta)blockMeta);
                                break block14;
                            }
                            break block51;
                        }
                        case 2: {
                            BlockStateMeta blockMeta = (BlockStateMeta)itemMeta2;
                            BlockState blockState = blockMeta.getBlockState();
                            if (!(blockState instanceof EntityBlockStorage)) {
                                n = 3;
                                continue block14;
                            }
                            EntityBlockStorage storage = (EntityBlockStorage)blockState;
                            if (storage.getEntityCount() > entitiesLimit) {
                                item.setType(Material.AIR);
                                item.setItemMeta(null);
                                ErrorUtils.sendDebug("[ITEMS] Destroyed entities block storage with a lot of entities");
                                break block14;
                            }
                            break block51;
                        }
                        case 3: {
                            BookMeta book = (BookMeta)itemMeta2;
                            if (book.pages().size() > bookPagesLimit) {
                                item.setType(Material.AIR);
                                item.setItemMeta(null);
                                ErrorUtils.sendDebug("[ITEMS] Destroyed book with a lot of pages");
                                break block14;
                            }
                            if (removeClickableBooks) {
                                List pages = book.pages();
                                boolean cleared = false;
                                for (int i = 0; i < pages.size(); ++i) {
                                    Component component2 = (Component)pages.get(i);
                                    if (component2.clickEvent() != null) {
                                        cleared = true;
                                    }
                                    component2 = component2.clickEvent() != null ? component2.clickEvent(null) : component2;
                                    book.page(i + 1, component2);
                                }
                                if (cleared) {
                                    ErrorUtils.sendDebug("[ITEMS] Cleared book with clickable components");
                                    item.setItemMeta((ItemMeta)book);
                                    break block14;
                                }
                            }
                            break block51;
                        }
                        case 4: {
                            SpawnEggMeta egg = (SpawnEggMeta)itemMeta2;
                            if (!removeCustomEggs && !removeBossEggs) {
                                n = 5;
                                continue block14;
                            }
                            if (egg.getCustomSpawnedType() != null) {
                                item.setType(Material.AIR);
                                item.setItemMeta(null);
                                ErrorUtils.sendDebug("[ITEMS] Destroyed custom spawn egg");
                            }
                            if (removeBossEggs && (item.getType() == Material.ENDER_DRAGON_SPAWN_EGG || item.getType() == Material.WITHER_SPAWN_EGG)) {
                                item.setType(Material.AIR);
                                item.setItemMeta(null);
                                ErrorUtils.sendDebug("[ITEMS] Destroyed boss spawn egg");
                                break block14;
                            }
                            break block51;
                        }
                    }
                    break;
                }
            }
            catch (Exception exception) {
                ErrorUtils.sendDebugError("[ITEMS] Can't fix item: " + String.valueOf(item), exception);
            }
        }
        return item;
    }

    public static int getPersistentDataAmount(@NotNull ItemStack item) {
        if (item == null) {
            ItemUtils.$$$reportNull$$$0(4);
        }
        int length = 0;
        int limit = OpenCreative.getSettings().getItemsMaxPersistentDataSize();
        PersistentDataContainerView container = item.getPersistentDataContainer();
        for (NamespacedKey key : container.getKeys()) {
            length += key.getKey().length();
            if (container.has(key, PersistentDataType.STRING)) {
                val = (String)container.get(key, PersistentDataType.STRING);
                if (val != null) {
                    length += ((String)val).length();
                }
            } else if (container.has(key, PersistentDataType.BYTE_ARRAY)) {
                val = (byte[])container.get(key, PersistentDataType.BYTE_ARRAY);
                if (val != null) {
                    length += ((Object)val).length;
                }
            } else if (container.has(key, PersistentDataType.INTEGER)) {
                length += 4;
            } else if (container.has(key, PersistentDataType.LONG)) {
                length += 8;
            } else if (container.has(key, PersistentDataType.BYTE)) {
                ++length;
            } else if (container.has(key, PersistentDataType.BYTE_ARRAY)) {
                val = (byte[])container.get(key, PersistentDataType.BYTE_ARRAY);
                if (val != null) {
                    length += ((Object)val).length;
                }
            } else if (container.has(key, PersistentDataType.DOUBLE)) {
                length += 8;
            } else if (container.has(key, PersistentDataType.FLOAT)) {
                length += 4;
            } else if (container.has(key, PersistentDataType.SHORT)) {
                length += 2;
            }
            if (length < limit) continue;
            break;
        }
        return length;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/utils/ItemUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/utils/ItemUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateItemMeta";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateItemMeta";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fixItem";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPersistentDataAmount";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

