/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.coding.modules.Module;
import ua.mcchickenstudio.opencreative.planets.Planet;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.hooks.HookUtils;
import ua.mcchickenstudio.opencreative.utils.hooks.PAPIUtils;

public final class MessageUtils {
    private static File localizationFile;
    private static FileConfiguration localizationConfig;
    static final Map<Planet, Long> messagesOnce;

    public static Component toComponent(String text) {
        if (MessageUtils.isLegacyFormat(text)) {
            return LegacyComponentSerializer.legacyAmpersand().deserialize(text);
        }
        return MiniMessage.miniMessage().deserialize((Object)text);
    }

    public static boolean isLegacyFormat(String text) {
        return text.indexOf(38) != -1 || text.indexOf(167) != -1;
    }

    public static String substring(String text, int length) {
        if (text.length() <= length || length <= 0) {
            return text;
        }
        String dots = text.endsWith("...") ? "" : (text.endsWith("..") ? "." : "...");
        return text.substring(0, length - dots.length()) + dots;
    }

    public static void loadLocalizationFile() {
        File localeFile = new File(String.valueOf(OpenCreative.getPlugin().getDataFolder()) + File.separator + "locales" + File.separator, MessageUtils.getLanguage() + ".yml");
        if (localeFile.exists()) {
            localizationFile = localeFile;
        } else {
            String defaultLanguage = MessageUtils.getLanguage().equalsIgnoreCase("ru") ? "ru" : "en";
            OpenCreative.getPlugin().getConfig().set("messages.locale", (Object)defaultLanguage);
            OpenCreative.getPlugin().saveResource("locales" + File.separator + "en.yml", false);
            OpenCreative.getPlugin().saveResource("locales" + File.separator + "ru.yml", false);
            OpenCreative.getPlugin().reloadConfig();
            localeFile = new File(String.valueOf(OpenCreative.getPlugin().getDataFolder()) + File.separator + "locales" + File.separator, defaultLanguage + ".yml");
        }
        MessageUtils.addMissingMessageLines();
        localizationConfig = YamlConfiguration.loadConfiguration((File)localeFile);
    }

    public static int addMissingMessageLines() {
        String selectedLang = OpenCreative.getPlugin().getConfig().getString("messages.locale", "en");
        File folder = new File(String.valueOf(OpenCreative.getPlugin().getDataFolder()) + File.separator + "locales" + File.separator);
        File file = new File(folder.getPath() + File.separator + selectedLang + ".yml");
        if (!file.exists()) {
            return -1;
        }
        InputStream input = OpenCreative.getPlugin().getResource("locales/" + selectedLang + ".yml");
        if (input == null) {
            return -1;
        }
        YamlConfiguration resource = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(input, StandardCharsets.UTF_8));
        YamlConfiguration localization = YamlConfiguration.loadConfiguration((File)file);
        int changes = 0;
        for (String key : resource.getKeys(true)) {
            if (localization.contains(key)) continue;
            localization.set(key, resource.get(key));
            ++changes;
        }
        if (changes == 0) {
            return 0;
        }
        try {
            localization.save(file);
            OpenCreative.getPlugin().getLogger().info("Added " + changes + " lines to localization file.");
        }
        catch (Exception error) {
            ErrorUtils.sendCriticalErrorMessage("Failed to update lines in localization file " + file.getName(), error);
        }
        return changes;
    }

    public static boolean localizationFileExists(String languageName) {
        return "en".equalsIgnoreCase(languageName) || "ru".equalsIgnoreCase(languageName) || new File(String.valueOf(OpenCreative.getPlugin().getDataFolder()) + File.separator + "locales" + File.separator, languageName + ".yml").exists();
    }

    private static String getPrefix() {
        String prefix = OpenCreative.getPlugin().getConfig().getString("messages.prefix");
        if (prefix == null || prefix.equalsIgnoreCase("null")) {
            prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)"&6 Worlds &8| &f");
            OpenCreative.getPlugin().getConfig().set("messages.prefix", (Object)"&6 Worlds &8| &f");
            OpenCreative.getPlugin().saveConfig();
            return prefix;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)prefix);
    }

    private static String getCreativeChatPrefix() {
        String prefix = OpenCreative.getPlugin().getConfig().getString("messages.cc-prefix");
        if (prefix == null || prefix.equalsIgnoreCase("null")) {
            prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)"&6 Creative Chat &8| &7");
            OpenCreative.getPlugin().getConfig().set("messages.cc-prefix", (Object)"&6 Creative Chat &8| &7");
            OpenCreative.getPlugin().reloadConfig();
            return prefix;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)prefix);
    }

    private static String getBranding() {
        String prefix = OpenCreative.getPlugin().getConfig().getString("messages.branding");
        if (prefix == null || prefix.equalsIgnoreCase("null")) {
            prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)"&fOpen&7Creative&a+");
            OpenCreative.getPlugin().getConfig().set("messages.branding", (Object)"&fOpen&7Creative&a+");
            OpenCreative.getPlugin().reloadConfig();
            return prefix;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)prefix);
    }

    public static String getLanguage() {
        Object language = OpenCreative.getPlugin().getConfig().get("messages.locale");
        if (language != null) {
            return String.valueOf(language);
        }
        String defaultLanguage = "en";
        OpenCreative.getPlugin().getConfig().set("messages.locale", (Object)defaultLanguage);
        OpenCreative.getPlugin().saveResource("locales" + File.separator + "en.yml", false);
        OpenCreative.getPlugin().saveResource("locales" + File.separator + "ru.yml", false);
        OpenCreative.getPlugin().reloadConfig();
        return "en";
    }

    private static File getLocalizationFile() {
        return localizationFile;
    }

    private static FileConfiguration getLocalization() {
        return localizationConfig;
    }

    public static Component getLocaleComponent(String messageID) {
        return MessageUtils.toComponent(MessageUtils.getLocaleMessage(messageID));
    }

    public static Component getLocaleComponent(String messageID, OfflinePlayer player) {
        return MessageUtils.toComponent(MessageUtils.getPlayerLocaleMessage(messageID, player));
    }

    public static Component getLocaleComponent(String messageID, boolean returnDetailedError) {
        return MessageUtils.toComponent(MessageUtils.getLocaleMessage(messageID, returnDetailedError));
    }

    public static String getLocaleMessage(String messageID) {
        String originalMessage = MessageUtils.getLocalization().getString(messageID);
        if (originalMessage == null || originalMessage.equalsIgnoreCase("null")) {
            if (OpenCreative.getSettings().isConsoleNotFoundMessage()) {
                ErrorUtils.sendWarningErrorMessage("Not found " + messageID + " in localization file!");
            }
            return "\u00a76 Error \u00a78| \u00a7fNot found \u00a76" + messageID + "\u00a7f! Administration of server needs to fill that line in \u00a76locales" + File.separator + MessageUtils.getLanguage() + ".yml";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)originalMessage.replace("%prefix%", MessageUtils.getPrefix()).replace("%branding%", MessageUtils.getBranding()).replace("%cc-prefix%", MessageUtils.getCreativeChatPrefix()));
    }

    public static String getPlayerLocaleMessage(String messageID, OfflinePlayer player) {
        String originalMessage = MessageUtils.getLocalization().getString(messageID);
        if (originalMessage == null || originalMessage.equalsIgnoreCase("null")) {
            if (OpenCreative.getSettings().isConsoleNotFoundMessage()) {
                ErrorUtils.sendWarningErrorMessage("Not found " + messageID + " in localization file!");
            }
            return "\u00a76 Error \u00a78| \u00a7fNot found \u00a76" + messageID + "\u00a7f! Administration of server needs to fill that line in \u00a76locales" + File.separator + MessageUtils.getLanguage() + ".yml";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)MessageUtils.parsePAPI(player, originalMessage.replace("%prefix%", MessageUtils.getPrefix()).replace("%branding%", MessageUtils.getBranding()).replace("%cc-prefix%", MessageUtils.getCreativeChatPrefix()).replace("%player%", player.getName() == null ? "Unknown player" : player.getName())));
    }

    public static String getLocaleMessage(String messageID, boolean returnDetailedError) {
        String originalMessage = MessageUtils.getLocalization().getString(messageID);
        if (originalMessage == null || originalMessage.equalsIgnoreCase("null")) {
            if (OpenCreative.getSettings().isConsoleNotFoundMessage()) {
                ErrorUtils.sendWarningErrorMessage("Not found " + messageID + " in localization file!");
            }
            if (returnDetailedError) {
                return "\u00a76 Error \u00a78| \u00a7fNot found \u00a76" + messageID + "\u00a7f! Administration of server needs to fill that line in \u00a76locales" + File.separator + MessageUtils.getLanguage() + ".yml";
            }
            return messageID;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)originalMessage.replace("%prefix%", MessageUtils.getPrefix()).replace("%branding%", MessageUtils.getBranding()).replace("%cc-prefix%", MessageUtils.getCreativeChatPrefix()));
    }

    public static String getLocaleItemName(String nameID) {
        String originalName = MessageUtils.getLocalization().getString(nameID);
        if (originalName == null || originalName.equalsIgnoreCase("null")) {
            if (OpenCreative.getSettings().isConsoleNotFoundMessage()) {
                ErrorUtils.sendWarningErrorMessage("Not found item name " + nameID + " in localization file!");
            }
            return "\u00a7fNot found: " + nameID;
        }
        if (originalName.length() > 50) {
            originalName = originalName.substring(0, 50);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)originalName.replace("%prefix%", MessageUtils.getPrefix()).replace("%cc-prefix%", MessageUtils.getCreativeChatPrefix()).replace("%branding%", MessageUtils.getBranding()));
    }

    public static List<String> getLocaleItemDescription(String descriptionID) {
        List originalDescription = MessageUtils.getLocalization().getStringList(descriptionID);
        ArrayList<String> parsedDescription = new ArrayList<String>();
        if (originalDescription.isEmpty()) {
            if (OpenCreative.getSettings().isConsoleNotFoundMessage()) {
                ErrorUtils.sendWarningErrorMessage("Not found item description " + descriptionID);
            }
            parsedDescription.add("\u00a76Not found item description");
            parsedDescription.add("\u00a76" + descriptionID);
            parsedDescription.add("\u00a7fPlease send this to server administration!");
            parsedDescription.add("\u00a7f They need to fill this line in ");
            parsedDescription.add("\u00a7f localization file: locales" + File.separator + MessageUtils.getLanguage() + ".yml");
        } else {
            for (String descriptionLine : originalDescription) {
                parsedDescription.add(ChatColor.translateAlternateColorCodes((char)'&', (String)descriptionLine.replace("%prefix%", MessageUtils.getPrefix()).replace("%cc-prefix%", MessageUtils.getCreativeChatPrefix()).replace("%branding%", MessageUtils.getBranding())));
            }
        }
        return parsedDescription;
    }

    @NotNull
    public static List<String> getBookPages(@NotNull String localizationID) {
        if (localizationID == null) {
            MessageUtils.$$$reportNull$$$0(0);
        }
        List foundPages = MessageUtils.getLocalization().getStringList(localizationID);
        ArrayList<String> pages = new ArrayList<String>();
        if (foundPages.isEmpty()) {
            if (OpenCreative.getSettings().isConsoleNotFoundMessage()) {
                ErrorUtils.sendWarningErrorMessage("Not found book pages " + localizationID);
            }
            pages.add("\u00a74Not found pages: \u00a70" + localizationID + " \nPlease report server administration, they need to fill this line in locales" + File.separator + MessageUtils.getLanguage() + ".yml");
        } else {
            for (String page : foundPages) {
                pages.add(ChatColor.translateAlternateColorCodes((char)'&', (String)page.replace("%prefix%", MessageUtils.getPrefix()).replace("%cc-prefix%", MessageUtils.getCreativeChatPrefix()).replace("%version%", OpenCreative.getVersion())));
            }
        }
        ArrayList<String> arrayList = pages;
        if (arrayList == null) {
            MessageUtils.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static String getElapsedTime(long currentTime, long oldTime) {
        Object elapsedTime = "";
        long elapsedTimeInSeconds = (currentTime - oldTime) / 1000L;
        long elapsedTimeInMinutes = elapsedTimeInSeconds / 60L;
        long elapsedTimeInHours = elapsedTimeInMinutes / 60L;
        long elapsedTimeInDays = elapsedTimeInHours / 24L;
        elapsedTimeInSeconds %= 60L;
        elapsedTimeInMinutes %= 60L;
        elapsedTimeInHours %= 24L;
        if (elapsedTimeInDays > 0L) {
            elapsedTime = ((String)elapsedTime).concat(elapsedTimeInDays + " " + MessageUtils.getLocaleMessage("time.days", false) + " ");
        }
        if (elapsedTimeInHours > 0L) {
            elapsedTime = ((String)elapsedTime).concat(elapsedTimeInHours + " " + MessageUtils.getLocaleMessage("time.hours", false) + " ");
        }
        if (elapsedTimeInMinutes > 0L) {
            elapsedTime = ((String)elapsedTime).concat(elapsedTimeInMinutes + " " + MessageUtils.getLocaleMessage("time.minutes", false) + " ");
        }
        if (elapsedTimeInSeconds > 0L) {
            elapsedTime = ((String)elapsedTime).concat(elapsedTimeInSeconds + " " + MessageUtils.getLocaleMessage("time.seconds", false) + " ");
        }
        if (currentTime - oldTime < 1000L) {
            elapsedTime = MessageUtils.getLocaleMessage("time.less-second", false) + " ";
        }
        String string = (String)elapsedTime + MessageUtils.getLocaleMessage("time.ago", false);
        if (string == null) {
            MessageUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String convertTime(long duration) {
        String convertedTime = "";
        long seconds = duration / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        seconds %= 60L;
        minutes %= 60L;
        hours %= 24L;
        if (days > 0L) {
            convertedTime = convertedTime.concat(days + " " + MessageUtils.getLocaleMessage("time.days", false) + " ");
        }
        if (hours > 0L) {
            convertedTime = convertedTime.concat(hours + " " + MessageUtils.getLocaleMessage("time.hours", false) + " ");
        }
        if (minutes > 0L) {
            convertedTime = convertedTime.concat(minutes + " " + MessageUtils.getLocaleMessage("time.minutes", false) + " ");
        }
        if (seconds > 0L) {
            convertedTime = convertedTime.concat(seconds + " " + MessageUtils.getLocaleMessage("time.seconds", false));
        }
        if (duration < 1000L) {
            convertedTime = MessageUtils.getLocaleMessage("time.less-second", false);
        }
        if (duration < 0L) {
            convertedTime = "\u221e";
        }
        String string = convertedTime;
        if (string == null) {
            MessageUtils.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static void sendMessageOnce(Planet planet, String message, int onceInSeconds) {
        long timeInMap;
        long elapsedTime;
        long elapsedSeconds;
        long currentTime = System.currentTimeMillis();
        if (messagesOnce.containsKey(planet) && (elapsedSeconds = (elapsedTime = currentTime - (timeInMap = messagesOnce.get(planet).longValue())) / 1000L) < (long)onceInSeconds) {
            return;
        }
        for (Player player : planet.getPlayers()) {
            player.sendMessage(message);
        }
        messagesOnce.put(planet, currentTime);
    }

    public static void sendMessageOnce(Planet planet, TextComponent message, int onceInSeconds) {
        long timeInMap;
        long elapsedTime;
        long elapsedSeconds;
        long currentTime = System.currentTimeMillis();
        if (messagesOnce.get(planet) != null && (elapsedSeconds = (elapsedTime = currentTime - (timeInMap = messagesOnce.get(planet).longValue())) / 1000L) < (long)onceInSeconds) {
            return;
        }
        for (Player player : planet.getPlayers()) {
            player.sendMessage((BaseComponent)message);
        }
        messagesOnce.put(planet, currentTime);
    }

    public static void clearOnceMessages(Planet planet) {
        messagesOnce.remove(planet);
    }

    public static String parsePlanetLines(Planet planet, String string) {
        Object planetReputation = String.valueOf(planet.getInformation().getReputation());
        planetReputation = planet.getInformation().getReputation() >= 1 ? "\u00a7a+" + (String)planetReputation : (planet.getInformation().getReputation() <= -1 ? "\u00a7c" + (String)planetReputation : "\u00a7e" + (String)planetReputation);
        return MessageUtils.parsePAPI(Bukkit.getOfflinePlayer((String)planet.getOwner()), string).replace("%planetName%", planet.getInformation().getDisplayName()).replace("%planetOnline%", String.valueOf(planet.getOnline())).replace("%planetOwner%", planet.getOwner()).replace("%planetID%", String.valueOf(planet.getId())).replace("%planetCustomID%", planet.getInformation().getCustomID()).replace("%planetCategory%", planet.getInformation().getCategory().getLocaleName()).replace("%planetUniques%", String.valueOf(planet.getInformation().getUniques())).replace("%planetReputation%", (CharSequence)planetReputation).replace("%planetLastTime%", MessageUtils.getElapsedTime(System.currentTimeMillis(), planet.getLastActivityTime())).replace("%planetCreationTime%", MessageUtils.getElapsedTime(System.currentTimeMillis(), planet.getCreationTime()));
    }

    public static Component parsePlanetLines(Planet planet, Component component) {
        Object planetReputation = String.valueOf(planet.getInformation().getReputation());
        planetReputation = planet.getInformation().getReputation() >= 1 ? "\u00a7a+" + (String)planetReputation : (planet.getInformation().getReputation() <= -1 ? "\u00a7c" + (String)planetReputation : "\u00a7e" + (String)planetReputation);
        return component.replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%planetName%").replacement((ComponentLike)planet.getInformation().displayName()).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%planetOnline%").replacement(String.valueOf(planet.getOnline())).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%planetOwner%").replacement(planet.getOwner()).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%planetID%").replacement(String.valueOf(planet.getId())).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%planetCustomID%").replacement(planet.getInformation().getCustomID()).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%planetCategory%").replacement((ComponentLike)MessageUtils.toComponent(planet.getInformation().getCategory().getLocaleName())).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%planetUniques%").replacement(String.valueOf(planet.getInformation().getUniques())).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%planetReputation%").replacement((ComponentLike)MessageUtils.toComponent((String)planetReputation)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%planetLastTime%").replacement(MessageUtils.getElapsedTime(System.currentTimeMillis(), planet.getLastActivityTime())).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().match("%planetCreationTime%").replacement(MessageUtils.getElapsedTime(System.currentTimeMillis(), planet.getCreationTime())).build());
    }

    public static String parseModuleLines(Module module, String string) {
        Object reputation = String.valueOf(module.getInformation().getReputation());
        reputation = module.getInformation().getReputation() >= 1 ? "\u00a7a+" + (String)reputation : (module.getInformation().getReputation() <= -1 ? "\u00a7c" + (String)reputation : "\u00a7e" + (String)reputation);
        return MessageUtils.parsePAPI(Bukkit.getOfflinePlayer((UUID)module.getOwner()), string).replace("%moduleName%", module.getInformation().getDisplayName()).replace("%moduleDescription%", module.getInformation().getDescription()).replace("%moduleOwner%", module.getOwnerName()).replace("%moduleID%", String.valueOf(module.getId())).replace("%moduleDownloads%", String.valueOf(module.getInformation().getDownloads())).replace("%moduleReputation%", (CharSequence)reputation).replace("%moduleCreationTime%", MessageUtils.getElapsedTime(System.currentTimeMillis(), module.getInformation().getCreationTime())).replace("%moduleSharing%", MessageUtils.getLocaleMessage("modules.sharing." + (module.getInformation().isPublic() ? "public" : "private"), false));
    }

    public static String parsePAPI(OfflinePlayer player, String string) {
        if (HookUtils.isPlaceholderAPIEnabled) {
            try {
                return PAPIUtils.parsePlaceholdersAPI(player, string);
            }
            catch (Exception ignored) {
                return string;
            }
        }
        return string;
    }

    public static double parseTicks(String message) {
        double modifier;
        double ticks = 0.0;
        if (message == null) {
            return ticks;
        }
        if (message.isEmpty()) {
            return ticks;
        }
        switch (message.toLowerCase().charAt(message.length() - 1)) {
            case 's': {
                double d = 20.0;
                break;
            }
            case 'm': {
                double d = 1200.0;
                break;
            }
            case 'h': {
                double d = 72000.0;
                break;
            }
            case 'd': {
                double d = 1728000.0;
                break;
            }
            default: {
                double d = modifier = 1.0;
            }
        }
        if (modifier != 1.0) {
            message = message.substring(0, message.length() - 1);
        }
        try {
            ticks = Double.parseDouble(message);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return ticks * modifier;
    }

    public static boolean messageExists(String messageID) {
        String originalMessage = MessageUtils.getLocalization().getString(messageID);
        return originalMessage != null && !originalMessage.equalsIgnoreCase("null");
    }

    static {
        messagesOnce = new HashMap<Planet, Long>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizationID";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/utils/MessageUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/utils/MessageUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBookPages";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElapsedTime";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBookPages";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

