/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.boss.KeyedBossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.events.player.PlayerLobbyEvent;
import ua.mcchickenstudio.opencreative.settings.Settings;
import ua.mcchickenstudio.opencreative.settings.Sounds;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.ItemUtils;
import ua.mcchickenstudio.opencreative.utils.MessageUtils;
import ua.mcchickenstudio.opencreative.utils.async.AsyncScheduler;
import ua.mcchickenstudio.opencreative.utils.hooks.HookUtils;
import ua.mcchickenstudio.opencreative.utils.world.WorldUtils;

public final class PlayerUtils {
    private static final Map<UUID, PermissionAttachment> permissionAttachmentMap = new HashMap<UUID, PermissionAttachment>();

    public static void clearPlayer(Player player) {
        if (player.isDead()) {
            player.spigot().respawn();
        }
        player.setGameMode(GameMode.ADVENTURE);
        PlayerUtils.clearWorldModePermissions(player);
        player.closeInventory();
        if (OpenCreative.getSettings().isLobbyClearInventory()) {
            player.getInventory().clear();
        }
        for (PotionEffect effect : player.getActivePotionEffects()) {
            player.removePotionEffect(effect.getType());
        }
        PlayerUtils.resetAttributes(player);
        player.resetPlayerTime();
        player.resetPlayerWeather();
        player.removeResourcePacks();
        player.releaseLeftShoulderEntity();
        player.releaseRightShoulderEntity();
        player.eject();
        player.setSimulationDistance(Bukkit.getSimulationDistance());
        player.setViewDistance(Math.min(player.getClientViewDistance(), Bukkit.getViewDistance()));
        player.setWorldBorder(player.getWorld().getWorldBorder());
        player.stopAllSounds();
        for (Entity entity : player.getWorld().getEntities()) {
            player.showEntity((Plugin)OpenCreative.getPlugin(), entity);
        }
        for (Player p : player.getWorld().getPlayers()) {
            player.showEntity((Plugin)OpenCreative.getPlugin(), (Entity)p);
        }
        player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        PlayerUtils.clearBossBars(player);
        HookUtils.clearPlayerHook(player);
        player.setGameMode(GameMode.ADVENTURE);
    }

    public static void resetAttributes(Player player) {
        AttributeInstance stepHeight;
        AttributeInstance scale;
        player.setFireTicks(0);
        player.setFreezeTicks(0);
        player.setNoDamageTicks(20);
        player.setMaximumNoDamageTicks(20);
        player.setArrowsInBody(0);
        player.setExp(0.0f);
        player.setLevel(0);
        player.setMaxHealth(20.0);
        player.setHealth(20.0);
        player.setFoodLevel(20);
        player.setFlying(false);
        player.setGliding(false);
        player.setFlySpeed(0.1f);
        player.setWalkSpeed(0.2f);
        player.setMaximumAir(300);
        player.setRemainingAir(player.getMaximumAir());
        player.setCanPickupItems(true);
        player.setGlowing(false);
        AttributeInstance movementSpeed = player.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        if (movementSpeed != null) {
            movementSpeed.setBaseValue((double)0.1f);
        }
        if ((scale = player.getAttribute(Attribute.GENERIC_SCALE)) != null) {
            scale.setBaseValue(1.0);
        }
        if ((stepHeight = player.getAttribute(Attribute.GENERIC_STEP_HEIGHT)) != null) {
            stepHeight.setBaseValue((double)0.6f);
        }
    }

    public static void clearBossBars(Player player) {
        try {
            @NotNull Iterator it = Bukkit.getBossBars();
            while (it.hasNext()) {
                KeyedBossBar bar = (KeyedBossBar)it.next();
                bar.removePlayer(player);
            }
            player.activeBossBars().forEach(arg_0 -> ((Player)player).hideBossBar(arg_0));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void teleportToLobby(Player player) {
        World lobbyWorld = PlayerUtils.getLobbyWorld();
        Location location = lobbyWorld != null ? lobbyWorld.getSpawnLocation() : player.getLocation();
        player.teleport(location);
        PlayerUtils.clearPlayer(player);
        player.showTitle(Title.title((Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("lobby.title")), (Component)MessageUtils.toComponent(MessageUtils.getLocaleMessage("lobby.subtitle")), (Title.Times)Title.Times.times((Duration)Duration.ofSeconds(1L), (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofSeconds(1L))));
        player.sendMessage(MessageUtils.toComponent(MessageUtils.getLocaleMessage("lobby.message")));
        Sounds.LOBBY.play((Audience)player);
        Sounds.LOBBY_MUSIC.play((Audience)player);
        ItemStack gamesItem = ItemUtils.createItem(Material.COMPASS, 1, "items.lobby.games", "worlds");
        player.getInventory().setItem(3, gamesItem);
        ItemStack myWorldsItem = ItemUtils.createItem(Material.NETHER_STAR, 1, "items.lobby.own", "own_worlds");
        player.getInventory().setItem(5, myWorldsItem);
        ItemStack changelogsItems = ItemUtils.createItem(Material.WRITTEN_BOOK, 1, "items.lobby.changelogs", "changelogs");
        ItemMeta itemMeta = changelogsItems.getItemMeta();
        if (itemMeta instanceof BookMeta) {
            BookMeta bookMeta = (BookMeta)itemMeta;
            bookMeta.setPages(MessageUtils.getBookPages("items.lobby.changelogs.pages"));
            changelogsItems.setItemMeta((ItemMeta)bookMeta);
        }
        player.getInventory().setItem(0, changelogsItems);
        player.getInventory().setHeldItemSlot(4);
        PlayerUtils.giveLobbyPermissions(player);
        PlayerLobbyEvent event = new PlayerLobbyEvent(player);
        event.callEvent();
    }

    public static World getLobbyWorld() {
        String spawnWorld = OpenCreative.getPlugin().getConfig().getString("lobby.world");
        if (spawnWorld == null || spawnWorld.isEmpty() || Bukkit.getWorld((String)spawnWorld) == null) {
            spawnWorld = "world";
        }
        return Bukkit.getWorld((String)spawnWorld);
    }

    public static boolean isEntityInDevPlanet(@NotNull Entity entity) {
        if (entity == null) {
            PlayerUtils.$$$reportNull$$$0(0);
        }
        return WorldUtils.isDevPlanet(entity.getWorld());
    }

    public static boolean isEntityInLobby(@NotNull Entity entity) {
        if (entity == null) {
            PlayerUtils.$$$reportNull$$$0(1);
        }
        return PlayerUtils.getLobbyWorld().equals((Object)entity.getWorld());
    }

    public static void loadPermissions() {
        permissionAttachmentMap.clear();
        for (Player player : Bukkit.getOnlinePlayers()) {
            PlayerUtils.loadPermissions(player);
        }
    }

    public static void loadPermissions(@NotNull Player player) {
        if (player == null) {
            PlayerUtils.$$$reportNull$$$0(2);
        }
        PermissionAttachment permissionAttachment = player.addAttachment((Plugin)OpenCreative.getPlugin());
        permissionAttachmentMap.put(player.getUniqueId(), permissionAttachment);
    }

    public static void removeFromPermissionsMap(@NotNull Player player) {
        if (player == null) {
            PlayerUtils.$$$reportNull$$$0(3);
        }
        PlayerUtils.clearWorldModePermissions(player);
        permissionAttachmentMap.remove(player.getUniqueId());
    }

    public static void giveDevPermissions(@NotNull Player player) {
        if (player == null) {
            PlayerUtils.$$$reportNull$$$0(4);
        }
        PermissionAttachment permissionAttachment = permissionAttachmentMap.get(player.getUniqueId());
        Set<String> perms = OpenCreative.getSettings().getGroups().getGroup(player).getDevPermissions();
        for (String permission : perms) {
            permissionAttachment.setPermission(permission, !permission.startsWith("!"));
        }
    }

    public static void givePlayPermissions(@NotNull Player player) {
        if (player == null) {
            PlayerUtils.$$$reportNull$$$0(5);
        }
        PermissionAttachment permissionAttachment = permissionAttachmentMap.get(player.getUniqueId());
        Set<String> perms = OpenCreative.getSettings().getGroups().getGroup(player).getPlayPermissions();
        for (String permission : perms) {
            permissionAttachment.setPermission(permission, !permission.startsWith("!"));
        }
    }

    public static void giveBuildPermissions(@NotNull Player player) {
        if (player == null) {
            PlayerUtils.$$$reportNull$$$0(6);
        }
        PermissionAttachment permissionAttachment = permissionAttachmentMap.get(player.getUniqueId());
        Set<String> perms = OpenCreative.getSettings().getGroups().getGroup(player).getBuildPermissions();
        for (String permission : perms) {
            permissionAttachment.setPermission(permission, !permission.startsWith("!"));
        }
    }

    public static void giveLobbyPermissions(@NotNull Player player) {
        if (player == null) {
            PlayerUtils.$$$reportNull$$$0(7);
        }
        PermissionAttachment permissionAttachment = permissionAttachmentMap.get(player.getUniqueId());
        Set<String> perms = OpenCreative.getSettings().getGroups().getGroup(player).getLobbyPermissions();
        for (String permission : perms) {
            permissionAttachment.setPermission(permission, !permission.startsWith("!"));
        }
    }

    public static void clearWorldModePermissions(@NotNull Player player) {
        PermissionAttachment permissionAttachment;
        if (player == null) {
            PlayerUtils.$$$reportNull$$$0(8);
        }
        if ((permissionAttachment = permissionAttachmentMap.get(player.getUniqueId())) == null) {
            return;
        }
        Map permissions = permissionAttachment.getPermissions();
        HashSet permissionsCopy = new HashSet(permissions.entrySet());
        for (Map.Entry entry : permissionsCopy) {
            String key = (String)entry.getKey();
            permissionAttachment.unsetPermission(key);
        }
    }

    public static void translateBlockSign(Block block) {
        if (!block.getType().toString().contains("SIGN")) {
            return;
        }
        Sign sign = (Sign)block.getState();
        AsyncScheduler.run(() -> {
            ArrayList<Object> newLines = new ArrayList<Object>();
            for (Component line : sign.getSide(Side.FRONT).lines()) {
                String content = ((TextComponent)line).content();
                String path = "blocks." + content;
                if (content.isEmpty()) {
                    newLines.add(Component.text((String)""));
                    continue;
                }
                if (!MessageUtils.messageExists(path)) {
                    newLines.add(Component.text((String)content));
                    continue;
                }
                newLines.add(MessageUtils.toComponent(MessageUtils.getLocaleMessage(path, false)));
            }
            AsyncScheduler.later(() -> {
                for (Player player : block.getLocation().getWorld().getPlayers()) {
                    player.sendSignChange(block.getLocation(), newLines);
                }
            }, AsyncScheduler.getScheduler(), 100L, TimeUnit.MILLISECONDS);
        }, AsyncScheduler.getScheduler());
    }

    public static void translateBlockSign(final Block block, final Player player) {
        if (block == null) {
            return;
        }
        if (!block.getType().toString().contains("SIGN")) {
            return;
        }
        Sign sign = (Sign)block.getState();
        final ArrayList<Object> newLines = new ArrayList<Object>();
        for (Component line : sign.getSide(Side.FRONT).lines()) {
            String content = ((TextComponent)line).content();
            String path = "blocks." + content;
            if (content.isEmpty()) {
                newLines.add(Component.text((String)""));
                continue;
            }
            if (!MessageUtils.messageExists(path)) {
                newLines.add(Component.text((String)content));
                continue;
            }
            newLines.add(MessageUtils.toComponent(MessageUtils.getLocaleMessage(path, false)));
        }
        new BukkitRunnable(){

            public void run() {
                player.sendSignChange(block.getLocation(), newLines);
            }
        }.runTaskLater((Plugin)OpenCreative.getPlugin(), 5L);
    }

    public static void translateSigns(Player player, int radius) {
        if (radius <= 0) {
            return;
        }
        if (radius > 50) {
            radius = 50;
        }
        int minX = player.getLocation().getBlockX() - radius;
        int maxX = player.getLocation().getBlockX() + radius;
        int minZ = player.getLocation().getBlockZ() - radius;
        int maxZ = player.getLocation().getBlockZ() + radius;
        int y = player.getLocation().getBlockY();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                Block block = player.getWorld().getBlockAt(x, y, z);
                if (!block.getType().name().contains("WALL_SIGN")) continue;
                PlayerUtils.translateBlockSign(block, player);
            }
        }
    }

    public static void spawnGlowingBlock(Player player, Location location) {
        if (OpenCreative.getPacketManager().isEnabled()) {
            try {
                OpenCreative.getPacketManager().displayGlowingBlock(player, location);
            }
            catch (Exception error) {
                ErrorUtils.sendPlayerErrorMessage(player, "Failed to spawn glowing block", error);
            }
        }
    }

    public static void sendOpenedChestAnimation(Player player, Block block) {
        if (OpenCreative.getPacketManager().isEnabled()) {
            try {
                OpenCreative.getPacketManager().sendChestOpenAnimation(player, block);
            }
            catch (Exception error) {
                ErrorUtils.sendPlayerErrorMessage(player, "Failed to display opened chest animation", error);
            }
        }
    }

    public static void sendClosedChestAnimation(Player player, Block block) {
        if (OpenCreative.getPacketManager().isEnabled()) {
            try {
                OpenCreative.getPacketManager().sendChestCloseAnimation(player, block);
            }
            catch (Exception error) {
                ErrorUtils.sendPlayerErrorMessage(player, "Failed to display closed chest animation", error);
            }
        }
    }

    public static void hidePlayerInTab(Player spectator, Player receiver) {
        if (spectator == receiver) {
            return;
        }
        Settings.PlayerListChanger changer = OpenCreative.getSettings().getListChanger();
        if (changer == Settings.PlayerListChanger.SPECTATOR) {
            if (OpenCreative.getPacketManager().isEnabled()) {
                try {
                    OpenCreative.getPacketManager().displayAsSpectatorName(spectator, receiver);
                }
                catch (Exception error) {
                    ErrorUtils.sendWarningMessage("Failed to mark player " + spectator.getName() + "as hidden in tab", error);
                }
            } else {
                receiver.hidePlayer((Plugin)OpenCreative.getPlugin(), spectator);
            }
        } else if (changer == Settings.PlayerListChanger.FULL) {
            receiver.hidePlayer((Plugin)OpenCreative.getPlugin(), spectator);
        }
    }

    public static void showPlayerFromTab(Player spectator, Player receiver) {
        if (spectator == receiver) {
            return;
        }
        if (OpenCreative.getPacketManager().isEnabled() && OpenCreative.getSettings().getListChanger() == Settings.PlayerListChanger.SPECTATOR) {
            try {
                OpenCreative.getPacketManager().removeSpectatorName(spectator, receiver);
            }
            catch (Exception error) {
                ErrorUtils.sendWarningMessage("Failed send uncolored spectator name " + spectator.getName(), error);
            }
        } else {
            receiver.showPlayer((Plugin)OpenCreative.getPlugin(), spectator);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "player";
                break;
            }
        }
        objectArray2[1] = "ua/mcchickenstudio/opencreative/utils/PlayerUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEntityInDevPlanet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isEntityInLobby";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadPermissions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeFromPermissionsMap";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "giveDevPermissions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "givePlayPermissions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "giveBuildPermissions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "giveLobbyPermissions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "clearWorldModePermissions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

