/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import lombok.Generated;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.async.TryIgnore;

public class AsyncScheduler {
    private static final char INNER_CLASS_SEPARATOR_CHAR = '$';
    private static final int STOP_WATCH_TIME_MILLIS = 750;
    private static final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(36, new ThreadFactoryBuilder().setNameFormat("opencreative-thread-%d").build());

    public static void shutdown(ScheduledExecutorService schedulerCustom) {
        TryIgnore.ignore(schedulerCustom::shutdownNow);
    }

    private AsyncScheduler() {
    }

    public static Future<?> run(Runnable runnable, ScheduledExecutorService schedulerCustom) {
        return schedulerCustom.submit(new DecoratedRunnable(runnable));
    }

    public static <T> Future<T> run(Callable<T> callable, ScheduledExecutorService schedulerCustom) {
        return schedulerCustom.submit(new DecoratedCallable<T>(callable));
    }

    public static ScheduledFuture<?> later(Runnable runnable, ScheduledExecutorService schedulerCustom, long delay, TimeUnit time) {
        return schedulerCustom.schedule(new DecoratedRunnable(runnable), delay, time);
    }

    public static ScheduledFuture<?> timer(Runnable runnable, ScheduledExecutorService schedulerCustom, long delay, long period, TimeUnit time) {
        return schedulerCustom.scheduleAtFixedRate(new DecoratedRunnable(runnable), delay, period, time);
    }

    public static void cancel(ScheduledFuture<?> timer) {
        try {
            if (timer != null) {
                timer.cancel(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String toString(Object object) {
        if (object == null) {
            return "null";
        }
        Class<?> clazz = object.getClass();
        StringBuilder sb = new StringBuilder(clazz.getSimpleName() + "{");
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            field.setAccessible(true);
            try {
                if (field.getName().indexOf(36) != -1) {
                    sb.append(field.getName()).append("=");
                    Object value = field.get(object);
                    sb.append(value == null ? "null" : value.toString());
                }
            }
            catch (IllegalAccessException e) {
                sb.append(field.getName()).append("=<access denied>");
            }
            if (i >= fields.length - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Generated
    public static ScheduledExecutorService getScheduler() {
        return scheduler;
    }

    public static class DecoratedRunnable
    implements Runnable {
        private static Function<Runnable, Runnable> hotfixDecorator = runnable -> runnable;
        private final Runnable originalRunnable;
        private final Runnable decoratedRunnable;

        public DecoratedRunnable(Runnable originalRunnable) {
            this.originalRunnable = originalRunnable;
            this.decoratedRunnable = hotfixDecorator.apply(originalRunnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            try {
                this.decoratedRunnable.run();
            }
            catch (Throwable throwable) {
                ErrorUtils.sendCriticalErrorMessage("Asynchronous task error " + AsyncScheduler.toString(this.originalRunnable), new Exception(throwable));
            }
            finally {
                long after = System.currentTimeMillis() - start;
                if (after > 750L) {
                    ErrorUtils.sendCriticalErrorMessage("Asynchronous task took longer time (" + after + " ms) than expected. " + AsyncScheduler.toString(this.originalRunnable));
                }
            }
        }

        @Generated
        public String toString() {
            return "AsyncScheduler.DecoratedRunnable(originalRunnable=" + String.valueOf(this.originalRunnable) + ", decoratedRunnable=" + String.valueOf(this.decoratedRunnable) + ")";
        }

        @Generated
        public static void setHotfixDecorator(Function<Runnable, Runnable> hotfixDecorator) {
            DecoratedRunnable.hotfixDecorator = hotfixDecorator;
        }
    }

    public static class DecoratedCallable<T>
    implements Callable<T> {
        private static Function<Callable<?>, Callable<?>> hotfixDecorator = callable -> callable;
        private final Callable<T> originalCallable;
        private final Callable<T> decoratedCallable;

        public DecoratedCallable(Callable<T> originalCallable) {
            this.originalCallable = originalCallable;
            this.decoratedCallable = hotfixDecorator.apply(originalCallable);
        }

        @Override
        public T call() throws Exception {
            long start = System.currentTimeMillis();
            try {
                T t = this.decoratedCallable.call();
                return t;
            }
            catch (Throwable throwable) {
                ErrorUtils.sendCriticalErrorMessage("Asynchronous task error " + AsyncScheduler.toString(this.decoratedCallable), new Exception(throwable));
                throw throwable;
            }
            finally {
                long after = System.currentTimeMillis() - start;
                if (after > 750L) {
                    ErrorUtils.sendCriticalErrorMessage("Asynchronous task took longer time (" + after + " ms) than expected. " + AsyncScheduler.toString(this.decoratedCallable));
                }
            }
        }

        @Generated
        public String toString() {
            return "AsyncScheduler.DecoratedCallable(originalCallable=" + String.valueOf(this.originalCallable) + ", decoratedCallable=" + String.valueOf(this.decoratedCallable) + ")";
        }

        @Generated
        public static void setHotfixDecorator(Function<Callable<?>, Callable<?>> hotfixDecorator) {
            DecoratedCallable.hotfixDecorator = hotfixDecorator;
        }
    }
}

