/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.async;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class TryIgnore {
    public static ThrowableHandler throwableHandler = Throwable::printStackTrace;

    public static <T> T unchecked(SupplierThrows<T> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception e) {
            TryIgnore.doThrow0(e);
            throw new AssertionError();
        }
    }

    public static void unchecked(RunnableThrows runnable) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            TryIgnore.doThrow0(e);
            throw new AssertionError();
        }
    }

    public static <T> Predicate<T> unchecked(PredicateThrows<T> predicate) {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Exception e) {
                TryIgnore.doThrow0(e);
                throw new AssertionError();
            }
        };
    }

    public static <T> T ignore(SupplierThrows<T> supplier, T def) {
        try {
            return supplier.get();
        }
        catch (Throwable e) {
            throwableHandler.handle(e);
            return def;
        }
    }

    public static Optional<Throwable> ignore(RunnableThrows runnable) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            throwableHandler.handle(e);
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static Optional<Throwable> ignore(RunnableThrows runnable, Consumer<Throwable> consumer) {
        try {
            runnable.run();
        }
        catch (Throwable e) {
            consumer.accept(e);
            throwableHandler.handle(e);
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public static <T> Predicate<T> ignore(PredicateThrows<T> predicate, boolean def) {
        return t -> {
            try {
                return predicate.test(t);
            }
            catch (Throwable e) {
                throwableHandler.handle(e);
                return def;
            }
        };
    }

    public static <E extends Throwable> void doThrow0(Throwable e) throws E {
        throw e;
    }

    public static interface SupplierThrows<T> {
        public T get();
    }

    public static interface RunnableThrows {
        public void run();
    }

    public static interface PredicateThrows<T> {
        public boolean test(T var1);
    }

    public static interface ThrowableHandler {
        public void handle(Throwable var1);
    }
}

