/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.millennium.math;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import lombok.Generated;
import ua.mcchickenstudio.opencreative.utils.millennium.math.FastMath;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec3i;

public enum EnumFacing {
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));

    public static final EnumFacing[] VALUES;
    private static final EnumFacing[] HORIZONTALS;
    private static final Map NAME_LOOKUP;
    private static final EnumFacing[] $VALUES;
    private final int index;
    private final int opposite;
    private final int horizontalIndex;
    private final String name;
    private final Axis axis;
    private final AxisDirection axisDirection;
    private final Vec3i directionVec;

    private EnumFacing(int indexIn, int oppositeIn, int horizontalIndexIn, String nameIn, AxisDirection axisDirectionIn, Axis axisIn, Vec3i directionVecIn) {
        this.index = indexIn;
        this.horizontalIndex = horizontalIndexIn;
        this.opposite = oppositeIn;
        this.name = nameIn;
        this.axis = axisIn;
        this.axisDirection = axisDirectionIn;
        this.directionVec = directionVecIn;
    }

    public static EnumFacing byName(String name) {
        return name == null ? null : (EnumFacing)((Object)NAME_LOOKUP.get(name.toLowerCase()));
    }

    public static EnumFacing getFront(int index) {
        return VALUES[Math.abs(index % VALUES.length)];
    }

    public static EnumFacing getHorizontal(int p_176731_0_) {
        return HORIZONTALS[Math.abs(p_176731_0_ % HORIZONTALS.length)];
    }

    public static EnumFacing fromAngle(double angle) {
        return EnumFacing.getHorizontal(FastMath.floor(angle / 90.0 + 0.5) & 3);
    }

    public static EnumFacing random(Random rand) {
        return EnumFacing.values()[rand.nextInt(EnumFacing.values().length)];
    }

    public static EnumFacing func_176737_a(float p_176737_0_, float p_176737_1_, float p_176737_2_) {
        EnumFacing var3 = NORTH;
        float var4 = Float.MIN_VALUE;
        EnumFacing[] var5 = EnumFacing.values();
        int var6 = var5.length;
        for (EnumFacing var8 : var5) {
            float var9 = p_176737_0_ * (float)var8.directionVec.getX() + p_176737_1_ * (float)var8.directionVec.getY() + p_176737_2_ * (float)var8.directionVec.getZ();
            if (!(var9 > var4)) continue;
            var4 = var9;
            var3 = var8;
        }
        return var3;
    }

    public EnumFacing getOpposite() {
        return VALUES[this.opposite];
    }

    public EnumFacing rotateAround(Axis axis) {
        return switch (axis) {
            case Axis.X -> {
                if (this != WEST && this != EAST) {
                    yield this.rotateX();
                }
                yield this;
            }
            case Axis.Y -> {
                if (this != UP && this != DOWN) {
                    yield this.rotateY();
                }
                yield this;
            }
            case Axis.Z -> {
                if (this != NORTH && this != SOUTH) {
                    yield this.rotateZ();
                }
                yield this;
            }
            default -> throw new IllegalStateException("Unable to get CW facing for axis " + String.valueOf((Object)axis));
        };
    }

    public EnumFacing rotateY() {
        return switch (this) {
            case NORTH -> EAST;
            case EAST -> SOUTH;
            case SOUTH -> WEST;
            case WEST -> NORTH;
            default -> throw new IllegalStateException("Unable to get Y-rotated facing of " + String.valueOf((Object)this));
        };
    }

    private EnumFacing rotateX() {
        return switch (this) {
            case NORTH -> DOWN;
            case SOUTH -> UP;
            case UP -> NORTH;
            case DOWN -> SOUTH;
            default -> throw new IllegalStateException("Unable to get X-rotated facing of " + String.valueOf((Object)this));
        };
    }

    private EnumFacing rotateZ() {
        return switch (this) {
            case EAST -> DOWN;
            case WEST -> UP;
            case UP -> EAST;
            case DOWN -> WEST;
            default -> throw new IllegalStateException("Unable to get Z-rotated facing of " + String.valueOf((Object)this));
        };
    }

    public EnumFacing rotateYCCW() {
        return switch (this) {
            case NORTH -> WEST;
            case EAST -> NORTH;
            case SOUTH -> EAST;
            case WEST -> SOUTH;
            default -> throw new IllegalStateException("Unable to get CCW facing of " + String.valueOf((Object)this));
        };
    }

    public int getFrontOffsetX() {
        return this.axis == Axis.X ? this.axisDirection.getOffset() : 0;
    }

    public int getFrontOffsetY() {
        return this.axis == Axis.Y ? this.axisDirection.getOffset() : 0;
    }

    public int getFrontOffsetZ() {
        return this.axis == Axis.Z ? this.axisDirection.getOffset() : 0;
    }

    public String getName2() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Axis getAxis() {
        return this.axis;
    }

    @Generated
    public AxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    @Generated
    public Vec3i getDirectionVec() {
        return this.directionVec;
    }

    static {
        VALUES = new EnumFacing[6];
        HORIZONTALS = new EnumFacing[4];
        NAME_LOOKUP = Maps.newHashMap();
        $VALUES = new EnumFacing[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
        EnumFacing[] var0 = EnumFacing.values();
        int var1 = var0.length;
        EnumFacing[] enumFacingArray = var0;
        int n = enumFacingArray.length;
        for (int i = 0; i < n; ++i) {
            EnumFacing var3;
            EnumFacing.VALUES[var3.index] = var3 = enumFacingArray[i];
            if (var3.getAxis().isHorizontal()) {
                EnumFacing.HORIZONTALS[var3.horizontalIndex] = var3;
            }
            NAME_LOOKUP.put(var3.getName2().toLowerCase(), var3);
        }
    }

    public static enum Axis implements Predicate
    {
        X("x", Plane.HORIZONTAL),
        Y("y", Plane.VERTICAL),
        Z("z", Plane.HORIZONTAL);

        private static final Map NAME_LOOKUP;
        private static final Axis[] $VALUES;
        private static final Axis[] $VALUES$;
        private final String name;
        private final Plane plane;

        private Axis(String name, Plane plane) {
            this.name = name;
            this.plane = plane;
        }

        public static Axis byName(String name) {
            return name == null ? null : (Axis)((Object)NAME_LOOKUP.get(name.toLowerCase()));
        }

        public String getName2() {
            return this.name;
        }

        public boolean isVertical() {
            return this.plane == Plane.VERTICAL;
        }

        public boolean isHorizontal() {
            return this.plane == Plane.HORIZONTAL;
        }

        public String toString() {
            return this.name;
        }

        public boolean apply(EnumFacing facing) {
            return facing != null && facing.getAxis() == this;
        }

        public boolean apply(Object p_apply_1_) {
            return this.apply((EnumFacing)((Object)p_apply_1_));
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Plane getPlane() {
            return this.plane;
        }

        static {
            NAME_LOOKUP = Maps.newHashMap();
            $VALUES = new Axis[]{X, Y, Z};
            $VALUES$ = new Axis[]{X, Y, Z};
            Axis[] var0 = Axis.values();
            int var1 = var0.length;
            for (Axis var3 : var0) {
                NAME_LOOKUP.put(var3.getName2().toLowerCase(), var3);
            }
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private static final AxisDirection[] $VALUES;
        private final int offset;
        private final String description;

        private AxisDirection(int offset, String description) {
            this.offset = offset;
            this.description = description;
        }

        public String toString() {
            return this.description;
        }

        @Generated
        public int getOffset() {
            return this.offset;
        }

        static {
            $VALUES = new AxisDirection[]{POSITIVE, NEGATIVE};
        }
    }

    public static enum Plane implements Predicate,
    Iterable
    {
        HORIZONTAL,
        VERTICAL;

        private static final Plane[] $VALUES;

        public EnumFacing[] facings() {
            EnumFacing[] enumFacingArray;
            switch (this) {
                case HORIZONTAL: {
                    EnumFacing[] enumFacingArray2 = new EnumFacing[4];
                    enumFacingArray2[0] = NORTH;
                    enumFacingArray2[1] = EAST;
                    enumFacingArray2[2] = SOUTH;
                    enumFacingArray = enumFacingArray2;
                    enumFacingArray2[3] = WEST;
                    break;
                }
                case VERTICAL: {
                    EnumFacing[] enumFacingArray3 = new EnumFacing[2];
                    enumFacingArray3[0] = UP;
                    enumFacingArray = enumFacingArray3;
                    enumFacingArray3[1] = DOWN;
                    break;
                }
                default: {
                    throw new Error("Someone's been tampering with the universe!");
                }
            }
            return enumFacingArray;
        }

        public EnumFacing random(Random rand) {
            EnumFacing[] var2 = this.facings();
            return var2[rand.nextInt(var2.length)];
        }

        public boolean apply(EnumFacing facing) {
            return facing != null && facing.getAxis().getPlane() == this;
        }

        public Iterator iterator() {
            return Iterators.forArray((Object[])this.facings());
        }

        public boolean apply(Object p_apply_1_) {
            return this.apply((EnumFacing)((Object)p_apply_1_));
        }

        static {
            $VALUES = new Plane[]{HORIZONTAL, VERTICAL};
        }
    }
}

