/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.millennium.math;

import lombok.NonNull;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec2;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec3;

public final class Euler {
    public static boolean compareTwoVectorAngle(@NonNull Vec2 a, @NonNull Vec2 b, double radi) {
        double angleB;
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        double angleA = Math.atan2(a.getY(), a.getX());
        double angleDiff = Math.abs(angleA - (angleB = Math.atan2(b.getY(), b.getX())));
        if (angleDiff > Math.PI) {
            angleDiff = Math.PI * 2 - angleDiff;
        }
        return angleDiff <= Math.toRadians(radi);
    }

    public static double calculateTwoVectorAngleDifference(@NonNull Vec2 a, @NonNull Vec2 b) {
        double angleB;
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        double angleA = Math.atan2(a.getY(), a.getX());
        double angleDiff = Math.abs(angleA - (angleB = Math.atan2(b.getY(), b.getX())));
        if (angleDiff > Math.PI) {
            angleDiff = Math.PI * 2 - angleDiff;
        }
        return angleDiff;
    }

    public static Vec2 calculateVec2Vec(Vec3 from, Vec3 to) {
        Vec3 diff = to.subtract(from);
        double distance = Math.hypot(diff.xCoord, diff.zCoord);
        float yaw = (float)(Math.atan2(diff.zCoord, diff.xCoord) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(diff.yCoord, distance) * 180.0 / Math.PI));
        return new Vec2(yaw, pitch);
    }

    public static Vec2 calculateRotationToVec(Vec3 pos) {
        float deltaX = (float)pos.xCoord;
        float deltaY = (float)pos.yCoord;
        float deltaZ = (float)pos.zCoord;
        float distance = (float)Math.hypot(deltaX, deltaZ);
        float yaw = (float)(Math.toDegrees(Math.atan2(deltaZ, deltaX)) - 90.0);
        float pitch = (float)Math.toDegrees(-Math.atan2(deltaY, distance));
        return new Vec2(Euler.wrapDegrees(yaw), Euler.clamp(pitch, -90.0f, 90.0f));
    }

    public static float wrapDegrees(float value) {
        float f = value % 360.0f;
        if (f >= 180.0f) {
            f -= 360.0f;
        }
        if (f < -180.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static float clamp(float num, float min, float max) {
        if (num < min) {
            return min;
        }
        return Math.min(num, max);
    }

    public static double calculateVectorAngle(@NonNull Vec2 a) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        return Math.atan2(a.getY(), a.getX());
    }
}

