/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.millennium.math;

import ua.mcchickenstudio.opencreative.utils.millennium.math.AxisAlignedBB;
import ua.mcchickenstudio.opencreative.utils.millennium.math.BuildSpeed;
import ua.mcchickenstudio.opencreative.utils.millennium.math.FastMath;
import ua.mcchickenstudio.opencreative.utils.millennium.math.GeneralMath;
import ua.mcchickenstudio.opencreative.utils.millennium.math.MovingObjectPosition;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec2;
import ua.mcchickenstudio.opencreative.utils.millennium.vectors.Vec3;

public final class RayTrace {
    public static boolean doRayTrace(BuildSpeed s, Vec2 rotation, Vec3 from, AxisAlignedBB box, double dist) {
        boolean intersection = false;
        intersection = RayTrace.isIntersection(from, rotation, intersection, box, dist, s);
        return intersection;
    }

    private static boolean isIntersection(Vec3 location, Vec2 rotation, boolean intersection, AxisAlignedBB boundingBox, double dist, BuildSpeed s) {
        float pitch;
        float yaw = (float)rotation.getY();
        MovingObjectPosition result = RayTrace.rayCast(yaw, pitch = (float)rotation.getX(), boundingBox, location, dist, s);
        return intersection |= result != null && result.hitVec != null;
    }

    public static MovingObjectPosition rayCast(float yaw, float pitch, AxisAlignedBB bb, Vec3 locationIn, double dist, BuildSpeed s) {
        double lastX = locationIn.xCoord;
        double lastY = locationIn.yCoord;
        double lastZ = locationIn.zCoord;
        Vec3 vec3 = new Vec3(lastX, lastY, lastZ);
        Vec3 vec31 = RayTrace.getVectorForRotation(pitch, yaw, s);
        Vec3 vec32 = vec3.add(new Vec3(vec31.xCoord * dist, vec31.yCoord * dist, vec31.zCoord * dist));
        return bb.calculateIntercept(vec3, vec32);
    }

    public static Vec3 getVectorForRotation(float pitch, float yaw, BuildSpeed s) {
        float f = FastMath.cos(-yaw * ((float)Math.PI / 180) - (float)Math.PI);
        float f1 = GeneralMath.sin(-yaw * ((float)Math.PI / 180) - (float)Math.PI, s);
        float f2 = -GeneralMath.cos(-pitch * ((float)Math.PI / 180), s);
        float f3 = GeneralMath.sin(-pitch * ((float)Math.PI / 180), s);
        return new Vec3(f1 * f2, f3, f * f2);
    }
}

