/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.millennium.math;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import ua.mcchickenstudio.opencreative.utils.async.Pair;

public final class Statistics {
    public static final double EXPANDER = Math.pow(2.0, 24.0);

    public static double getVariance(Collection<? extends Number> data) {
        int count = 0;
        double sum = 0.0;
        double variance = 0.0;
        for (Number number : data) {
            sum += number.doubleValue();
            ++count;
        }
        double average = sum / (double)count;
        for (Number number : data) {
            variance += Math.pow(number.doubleValue() - average, 2.0);
        }
        return variance / (double)count;
    }

    public static double getMin(Collection<? extends Number> collection) {
        double min = Double.MAX_VALUE;
        for (Number number : collection) {
            min = Math.min(min, number.doubleValue());
        }
        return min;
    }

    public static float getGCD(double s) {
        float f1 = (float)((double)((float)s) * 0.6 + 0.2);
        return f1 * f1 * f1 * 8.0f;
    }

    public static float getGCDValue(double s) {
        return Statistics.getGCD(s) * 0.15f;
    }

    public static double getMax(Collection<? extends Number> collection) {
        double max = Double.MIN_VALUE;
        for (Number number : collection) {
            max = Math.max(max, number.doubleValue());
        }
        return max;
    }

    public static double getStandardDeviation(Collection<? extends Number> data) {
        double variance = Statistics.getVariance(data);
        return Math.sqrt(variance);
    }

    public static double getSkewness(Collection<? extends Number> data) {
        double sum = 0.0;
        int count = 0;
        ArrayList numbers = Lists.newArrayList();
        for (Number number : data) {
            sum += number.doubleValue();
            ++count;
            numbers.add(number.doubleValue());
        }
        Collections.sort(numbers);
        double mean = sum / (double)count;
        double median = count % 2 != 0 ? (Double)numbers.get(count / 2) : ((Double)numbers.get((count - 1) / 2) + (Double)numbers.get(count / 2)) / 2.0;
        double variance = Statistics.getVariance(data);
        return 3.0 * (mean - median) / variance;
    }

    public static double getAverage(Collection<? extends Number> data) {
        double sum = 0.0;
        for (Number number : data) {
            sum += number.doubleValue();
        }
        double result = sum / (double)data.size();
        return Double.isNaN(result) ? 0.0 : result;
    }

    public static double getKurtosis(Collection<? extends Number> data) {
        double sum = 0.0;
        int count = 0;
        for (Number number : data) {
            sum += number.doubleValue();
            ++count;
        }
        if ((double)count < 3.0) {
            return 0.0;
        }
        double efficiencyFirst = (double)count * ((double)count + 1.0) / (((double)count - 1.0) * ((double)count - 2.0) * ((double)count - 3.0));
        double efficiencySecond = 3.0 * Math.pow((double)count - 1.0, 2.0) / (((double)count - 2.0) * ((double)count - 3.0));
        double average = sum / (double)count;
        double variance = 0.0;
        double varianceSquared = 0.0;
        for (Number number : data) {
            variance += Math.pow(average - number.doubleValue(), 2.0);
            varianceSquared += Math.pow(average - number.doubleValue(), 4.0);
        }
        return efficiencyFirst * (varianceSquared / Math.pow(variance / sum, 2.0)) - efficiencySecond;
    }

    public static long getMode(Collection<? extends Number> array) {
        long mode = (Long)array.toArray()[0];
        long maxCount = 0L;
        for (Number number : array) {
            int count = 1;
            for (Number number2 : array) {
                if (number2.equals(number)) {
                    ++count;
                }
                if ((long)count <= maxCount) continue;
                mode = (Long)number;
                maxCount = count;
            }
        }
        return mode;
    }

    public static float distanceBetweenAngles(float alpha, float beta) {
        float alphaX = alpha % 360.0f;
        float betaX = beta % 360.0f;
        float delta = Math.abs(alphaX - betaX);
        return (float)Math.abs(Math.min(360.0 - (double)delta, (double)delta));
    }

    public static double getModeDouble(Double[] data) {
        double maxValue = -1.0;
        int maxCount = 0;
        for (int i = 0; i < data.length; ++i) {
            double currentValue = data[i];
            int currentCount = 1;
            for (int j = i + 1; j < data.length; ++j) {
                if (!(Math.abs(data[j] - currentValue) < 0.001)) continue;
                ++currentCount;
            }
            if (currentCount > maxCount) {
                maxCount = currentCount;
                maxValue = currentValue;
                continue;
            }
            if (currentCount != maxCount) continue;
            maxValue = Double.NaN;
        }
        return maxValue;
    }

    public static double getMedian(List<Number> data) {
        if (data.size() % 2 == 0) {
            return (data.get(data.size() / 2).doubleValue() + data.get(data.size() / 2 - 1).doubleValue()) / 2.0;
        }
        return data.get(data.size() / 2).doubleValue();
    }

    public static double getMedianDouble(List<Double> data) {
        if (data.size() % 2 == 0) {
            return (data.get(data.size() / 2) + data.get(data.size() / 2 - 1)) / 2.0;
        }
        return data.get(data.size() / 2);
    }

    public static boolean isExponentiallySmall(Number number) {
        return number.doubleValue() < 1.0 && (Double.toString(number.doubleValue()).contains("E") || number.doubleValue() == 0.0);
    }

    public static boolean isExponentiallyLarge(Number number) {
        return number.doubleValue() > 10000.0 && Double.toString(number.doubleValue()).contains("E");
    }

    public static long getGcd(long current, long previous) {
        return previous <= 16384L ? current : Statistics.getGcd(previous, current % previous);
    }

    public static double getGcd(double a, double b) {
        if (a == b) {
            return 0.0;
        }
        if (a < b) {
            return Statistics.getGcd(b, a);
        }
        if (Math.abs(b) < 1.0E-5) {
            return a;
        }
        return Statistics.getGcd(b, a - Math.floor(a / b) * b);
    }

    public static long getAbsoluteGcd(float current, float last) {
        long currentExpanded = (long)((double)current * EXPANDER);
        long lastExpanded = (long)((double)last * EXPANDER);
        return Statistics.getGcd(currentExpanded, lastExpanded);
    }

    public static long getAbsoluteGcd(double current, double last) {
        long currentExpanded = (long)(current * EXPANDER);
        long lastExpanded = (long)(last * EXPANDER);
        return Statistics.getGcd(currentExpanded, lastExpanded);
    }

    public static float gcdRational(List<Float> numbers) {
        float result = numbers.getFirst().floatValue();
        for (int i = 1; i < numbers.size(); ++i) {
            result = Statistics.gcdRational(numbers.get(i).floatValue(), result);
            if (!((double)result < 1.0E-7)) continue;
            return 0.0f;
        }
        return result;
    }

    public static float gcdRational(float a, float b) {
        if (a == 0.0f) {
            return b;
        }
        int quotient = Statistics.getIntQuotient(b, a);
        float remainder = (b / a - (float)quotient) * a;
        if (Math.abs(remainder) < Math.max(a, b) * 0.001f) {
            remainder = 0.0f;
        }
        return Statistics.gcdRational(remainder, a);
    }

    public static int getIntQuotient(float dividend, float divisor) {
        float ans = dividend / divisor;
        float error = Math.max(dividend, divisor) * 0.001f;
        return (int)(ans + error);
    }

    public static double getCps(Collection<? extends Number> data) {
        return 20.0 / Statistics.getAverage(data);
    }

    public static int getDuplicates(Collection<? extends Number> data) {
        return data.size() - Statistics.getDistinct(data);
    }

    public static Pair<List<Double>, List<Double>> getOutliers(Collection<? extends Number> collection) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (Number number : collection) {
            values.add(number.doubleValue());
        }
        double q1 = Statistics.getMedianDouble(values.subList(0, values.size() / 2));
        double q3 = Statistics.getMedianDouble(values.subList(values.size() / 2, values.size()));
        double iqr = Math.abs(q1 - q3);
        double lowThreshold = q1 - 1.5 * iqr;
        double highThreshold = q3 + 1.5 * iqr;
        Pair<List<Double>, List<Double>> tuple = new Pair<List<Double>, List<Double>>(new ArrayList(), new ArrayList());
        for (Double value : values) {
            if (value < lowThreshold) {
                tuple.getX().add(value);
                continue;
            }
            if (!(value > highThreshold)) continue;
            tuple.getY().add(value);
        }
        return tuple;
    }

    public static List<List<Double>> getOutliersSimply(Collection<? extends Number> collection) {
        Pair<List<Double>, List<Double>> result = Statistics.getOutliers(collection);
        return Arrays.asList(result.getX(), result.getY());
    }

    public static List<Long> convertToLongList(List<Integer> integerList) {
        ArrayList<Long> longList = new ArrayList<Long>();
        for (Integer i : integerList) {
            if (i != null) {
                longList.add(i.longValue());
                continue;
            }
            longList.add(null);
        }
        return longList;
    }

    public static double getKireikoGeneric(Collection<? extends Number> collection) {
        return (Statistics.getKurtosis(collection) + Statistics.getVariance(collection) * 3.0) / 20.0;
    }

    public static double calculatePercentile(Collection<? extends Number> data, double percentile) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("Collection cannot be empty");
        }
        List<Double> sortedValues = data.stream().map(Number::doubleValue).sorted().toList();
        int index = (int)Math.ceil(percentile / 100.0 * (double)sortedValues.size()) - 1;
        if (index < 0) {
            index = 0;
        }
        if (index >= sortedValues.size()) {
            index = sortedValues.size() - 1;
        }
        return sortedValues.get(index);
    }

    public static double getCoefficientOfVariation(Collection<? extends Number> data) {
        double mean = Statistics.getAverage(data);
        return mean == 0.0 ? 0.0 : Statistics.getStandardDeviation(data) / mean;
    }

    public static double getPearsonCorrelation(List<? extends Number> x, List<? extends Number> y) {
        if (x.size() != y.size() || x.isEmpty()) {
            return 0.0;
        }
        double meanX = Statistics.getAverage(x);
        double meanY = Statistics.getAverage(y);
        double sumXY = 0.0;
        double sumX2 = 0.0;
        double sumY2 = 0.0;
        for (int i = 0; i < x.size(); ++i) {
            double dx = x.get(i).doubleValue() - meanX;
            double dy = y.get(i).doubleValue() - meanY;
            sumXY += dx * dy;
            sumX2 += dx * dx;
            sumY2 += dy * dy;
        }
        return sumX2 == 0.0 || sumY2 == 0.0 ? 0.0 : sumXY / Math.sqrt(sumX2 * sumY2);
    }

    public static double getZScore(double value, Collection<? extends Number> data) {
        double mean = Statistics.getAverage(data);
        double stdDev = Statistics.getStandardDeviation(data);
        return stdDev == 0.0 ? 0.0 : (value - mean) / stdDev;
    }

    public static double getShannonEntropy(Collection<? extends Number> data) {
        Map<Double, Long> freqMap = data.stream().collect(Collectors.groupingBy(Number::doubleValue, Collectors.counting()));
        double total = data.size();
        return -freqMap.values().stream().mapToDouble(count -> (double)count.longValue() / total * (Math.log((double)count.longValue() / total) / Math.log(2.0))).sum();
    }

    public static double getHarmonicMean(Collection<? extends Number> data) {
        double sum = 0.0;
        int count = 0;
        for (Number number : data) {
            if (number.doubleValue() == 0.0) continue;
            sum += 1.0 / number.doubleValue();
            ++count;
        }
        return count == 0 ? 0.0 : (double)count / sum;
    }

    public static double getLinearTrend(List<? extends Number> data) {
        int n = data.size();
        if (n < 2) {
            return 0.0;
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXY = 0.0;
        double sumX2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double x = i + 1;
            double y = data.get(i).doubleValue();
            sumX += x;
            sumY += y;
            sumXY += x * y;
            sumX2 += x * x;
        }
        return ((double)n * sumXY - sumX * sumY) / ((double)n * sumX2 - sumX * sumX);
    }

    public static double getCovariance(List<? extends Number> x, List<? extends Number> y) {
        if (x.size() != y.size() || x.isEmpty()) {
            return 0.0;
        }
        double meanX = Statistics.getAverage(x);
        double meanY = Statistics.getAverage(y);
        double sum = 0.0;
        for (int i = 0; i < x.size(); ++i) {
            sum += (x.get(i).doubleValue() - meanX) * (y.get(i).doubleValue() - meanY);
        }
        return sum / (double)x.size();
    }

    public static double getSharpeRatio(Collection<? extends Number> returns, double riskFreeRate) {
        double mean = Statistics.getAverage(returns);
        double stdDev = Statistics.getStandardDeviation(returns);
        return stdDev == 0.0 ? 0.0 : (mean - riskFreeRate) / stdDev;
    }

    public static double getQuantile(Collection<? extends Number> data, double quantile) {
        List<Double> sorted = data.stream().map(Number::doubleValue).sorted().toList();
        int index = (int)Math.ceil(quantile * (double)sorted.size()) - 1;
        return sorted.get(Math.max(0, Math.min(index, sorted.size() - 1)));
    }

    public static double getGiniIndex(Collection<? extends Number> data) {
        List<Double> sorted = data.stream().map(Number::doubleValue).sorted().toList();
        int n = sorted.size();
        double sum = 0.0;
        for (Double aDouble : sorted) {
            for (int j = 0; j < n; ++j) {
                sum += Math.abs(aDouble - sorted.get(j));
            }
        }
        double mean = Statistics.getAverage(data);
        return mean == 0.0 ? 0.0 : sum / ((double)(2 * n * n) * mean);
    }

    public static double roundToPlace(double value, int places) {
        double multiplier = Math.pow(10.0, places);
        return (double)Math.round(value * multiplier) / multiplier;
    }

    public static List<Double> getZScoreOutliers(Collection<? extends Number> data, double threshold) {
        ArrayList<Double> outliers = new ArrayList<Double>();
        double mean = Statistics.getAverage(data);
        double stdDev = Statistics.getStandardDeviation(data);
        for (Number number : data) {
            double zScore = (number.doubleValue() - mean) / stdDev;
            if (!(Math.abs(zScore) > threshold)) continue;
            outliers.add(number.doubleValue());
        }
        return outliers;
    }

    public static double getRSquared(List<? extends Number> actual, List<? extends Number> predicted) {
        if (actual.size() != predicted.size() || actual.isEmpty()) {
            return 0.0;
        }
        double meanActual = Statistics.getAverage(actual);
        double ssTotal = 0.0;
        double ssResidual = 0.0;
        for (int i = 0; i < actual.size(); ++i) {
            double diffActual = actual.get(i).doubleValue() - meanActual;
            double diffResidual = actual.get(i).doubleValue() - predicted.get(i).doubleValue();
            ssTotal += diffActual * diffActual;
            ssResidual += diffResidual * diffResidual;
        }
        return ssTotal == 0.0 ? 0.0 : 1.0 - ssResidual / ssTotal;
    }

    private static double pearsonCorrelation(List<? extends Number> x, List<? extends Number> y) {
        double meanX = Statistics.getAverage(x);
        double meanY = Statistics.getAverage(y);
        double numerator = 0.0;
        double denominatorX = 0.0;
        double denominatorY = 0.0;
        for (int i = 0; i < x.size(); ++i) {
            double diffX = x.get(i).doubleValue() - meanX;
            double diffY = y.get(i).doubleValue() - meanY;
            numerator += diffX * diffY;
            denominatorX += diffX * diffX;
            denominatorY += diffY * diffY;
        }
        return numerator / Math.sqrt(denominatorX * denominatorY);
    }

    public static double spearmanCorrelation(List<? extends Number> x, List<? extends Number> y) {
        if (x.size() != y.size() || x.isEmpty()) {
            throw new IllegalArgumentException("Lists must be of the same size and non-empty");
        }
        List<Double> rankX = Statistics.getRanks(x);
        List<Double> rankY = Statistics.getRanks(y);
        return Statistics.pearsonCorrelation(rankX, rankY);
    }

    public static double rSquared(List<? extends Number> actual, List<? extends Number> predicted) {
        if (actual.size() != predicted.size() || actual.isEmpty()) {
            throw new IllegalArgumentException("Lists must be of the same size and non-empty");
        }
        double meanActual = Statistics.getAverage(actual);
        double ssTotal = 0.0;
        double ssResidual = 0.0;
        for (int i = 0; i < actual.size(); ++i) {
            double y = actual.get(i).doubleValue();
            double yPred = predicted.get(i).doubleValue();
            ssTotal += Math.pow(y - meanActual, 2.0);
            ssResidual += Math.pow(y - yPred, 2.0);
        }
        return 1.0 - ssResidual / ssTotal;
    }

    public static double tTest(List<? extends Number> sample1, List<? extends Number> sample2) {
        double mean1 = Statistics.getAverage(sample1);
        double mean2 = Statistics.getAverage(sample2);
        double var1 = Statistics.getVariance(sample1);
        double var2 = Statistics.getVariance(sample2);
        int n1 = sample1.size();
        int n2 = sample2.size();
        return (mean1 - mean2) / Math.sqrt(var1 / (double)n1 + var2 / (double)n2);
    }

    public static List<Double> movingAverage(List<? extends Number> data, int windowSize) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i <= data.size() - windowSize; ++i) {
            double sum = 0.0;
            for (int j = 0; j < windowSize; ++j) {
                sum += data.get(i + j).doubleValue();
            }
            result.add(sum / (double)windowSize);
        }
        return result;
    }

    public static List<Double> exponentialMovingAverage(List<? extends Number> data, double smoothingFactor) {
        ArrayList<Double> result = new ArrayList<Double>();
        double ema = data.getFirst().doubleValue();
        result.add(ema);
        for (int i = 1; i < data.size(); ++i) {
            double value = data.get(i).doubleValue();
            ema = smoothingFactor * value + (1.0 - smoothingFactor) * ema;
            result.add(ema);
        }
        return result;
    }

    public static double[] linearRegression(List<? extends Number> x, List<? extends Number> y) {
        int n = x.size();
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXY = 0.0;
        double sumX2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double xi = x.get(i).doubleValue();
            double yi = y.get(i).doubleValue();
            sumX += xi;
            sumY += yi;
            sumXY += xi * yi;
            sumX2 += xi * xi;
        }
        double slope = ((double)n * sumXY - sumX * sumY) / ((double)n * sumX2 - sumX * sumX);
        double intercept = (sumY - slope * sumX) / (double)n;
        return new double[]{slope, intercept};
    }

    public static double regressionStandardError(List<? extends Number> x, List<? extends Number> y, double slope, double intercept) {
        int n = x.size();
        double sumSquaredErrors = 0.0;
        for (int i = 0; i < n; ++i) {
            double xi = x.get(i).doubleValue();
            double yi = y.get(i).doubleValue();
            double predicted = slope * xi + intercept;
            sumSquaredErrors += Math.pow(yi - predicted, 2.0);
        }
        return Math.sqrt(sumSquaredErrors / (double)(n - 2));
    }

    public static double getWinsorizedMean(List<? extends Number> data, double trimFraction) {
        List<Double> sorted = data.stream().map(Number::doubleValue).sorted().toList();
        int n = sorted.size();
        int trimCount = (int)((double)n * trimFraction);
        double lowerBound = sorted.get(trimCount - 1);
        double upperBound = sorted.get(n - trimCount);
        ArrayList<Double> winsorized = new ArrayList<Double>(n);
        for (double value : sorted) {
            if (value < lowerBound) {
                winsorized.add(lowerBound);
                continue;
            }
            winsorized.add(Math.min(value, upperBound));
        }
        return winsorized.stream().mapToDouble(Double::doubleValue).average().orElse(0.0);
    }

    public static double kolmogorovSmirnovTest(List<? extends Number> data, Function<Double, Double> cdfFunction) {
        List<Double> sorted = data.stream().map(Number::doubleValue).sorted().toList();
        int n = sorted.size();
        double dStatistic = 0.0;
        for (int i = 0; i < n; ++i) {
            double empiricalCDF = (double)(i + 1) / (double)n;
            double theoreticalCDF = cdfFunction.apply(sorted.get(i));
            dStatistic = Math.max(dStatistic, Math.abs(empiricalCDF - theoreticalCDF));
        }
        return dStatistic;
    }

    public static double getExponentiallyWeightedVariance(List<? extends Number> data, double alpha) {
        double ewMean = data.getFirst().doubleValue();
        double ewVariance = 0.0;
        for (int i = 1; i < data.size(); ++i) {
            double value = data.get(i).doubleValue();
            ewMean = alpha * value + (1.0 - alpha) * ewMean;
            ewVariance = alpha * Math.pow(value - ewMean, 2.0) + (1.0 - alpha) * ewVariance;
        }
        return ewVariance;
    }

    public static double calculateAimSuspicionIndex(List<? extends Number> aimDeltas, List<? extends Number> reactionTimes) {
        double avgDelta = Statistics.getAverage(aimDeltas);
        double stdDelta = Statistics.getStandardDeviation(aimDeltas);
        double deltaZSum = 0.0;
        for (Number number : aimDeltas) {
            double z = stdDelta == 0.0 ? 0.0 : (number.doubleValue() - avgDelta) / stdDelta;
            deltaZSum += Math.abs(z);
        }
        double avgDeltaZ = deltaZSum / (double)aimDeltas.size();
        double avgReaction = Statistics.getAverage(reactionTimes);
        double stdReaction = Statistics.getStandardDeviation(reactionTimes);
        double reactionZSum = 0.0;
        for (Number number : reactionTimes) {
            double z = stdReaction == 0.0 ? 0.0 : (number.doubleValue() - avgReaction) / stdReaction;
            reactionZSum += Math.abs(z);
        }
        double avgReactionZ = reactionZSum / (double)reactionTimes.size();
        return avgDeltaZ * 0.6 + avgReactionZ * 0.4;
    }

    public static List<Double> kalmanFilterPredict(List<? extends Number> measurements, double processVariance, double measurementVariance) {
        int n = measurements.size();
        ArrayList<Double> predictions = new ArrayList<Double>(n);
        double estimate = measurements.getFirst().doubleValue();
        double errorCovariance = 1.0;
        predictions.add(estimate);
        for (int i = 1; i < n; ++i) {
            double prediction = estimate;
            double predictedError = errorCovariance + processVariance;
            double measurement = measurements.get(i).doubleValue();
            double kalmanGain = predictedError / (predictedError + measurementVariance);
            estimate = prediction + kalmanGain * (measurement - prediction);
            errorCovariance = (1.0 - kalmanGain) * predictedError;
            predictions.add(estimate);
        }
        return predictions;
    }

    public static double dynamicTimeWarpingDistance(List<Double> series1, List<Double> series2) {
        int i;
        int n = series1.size();
        int m = series2.size();
        double[][] dtw = new double[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            Arrays.fill(dtw[i], Double.POSITIVE_INFINITY);
        }
        dtw[0][0] = 0.0;
        for (i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                double cost = Math.abs(series1.get(i - 1) - series2.get(j - 1));
                dtw[i][j] = cost + Math.min(Math.min(dtw[i - 1][j], dtw[i][j - 1]), dtw[i - 1][j - 1]);
            }
        }
        return dtw[n][m];
    }

    public static List<Integer> cusumDetection(List<? extends Number> data, double threshold, double drift) {
        List<Double> series = data.stream().map(Number::doubleValue).toList();
        ArrayList<Integer> changePoints = new ArrayList<Integer>();
        double posSum = 0.0;
        double negSum = 0.0;
        for (int i = 0; i < series.size(); ++i) {
            double value = series.get(i);
            posSum = Math.max(0.0, posSum + value - drift);
            negSum = Math.min(0.0, negSum + value + drift);
            if (posSum > threshold) {
                changePoints.add(i);
                posSum = 0.0;
                continue;
            }
            if (!(Math.abs(negSum) > threshold)) continue;
            changePoints.add(i);
            negSum = 0.0;
        }
        return changePoints;
    }

    public static List<Float> getJiffDelta(List<? extends Number> data, int depth) {
        ArrayList<Float> result = new ArrayList<Float>();
        for (Number number : data) {
            result.add(Float.valueOf(number.floatValue()));
        }
        for (int i = 0; i < depth; ++i) {
            ArrayList<Float> arrayList = new ArrayList<Float>();
            float old = Float.MIN_VALUE;
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                float n = ((Float)iterator.next()).floatValue();
                if (old == Float.MIN_VALUE) {
                    old = n;
                    continue;
                }
                arrayList.add(Float.valueOf(Math.abs(Math.abs(n) - Math.abs(old))));
                old = n;
            }
            result = new ArrayList(arrayList);
        }
        return result;
    }

    public static List<Double> getRanks(List<? extends Number> data) {
        List<Double> sorted = data.stream().map(Number::doubleValue).sorted().toList();
        return data.stream().map(v -> sorted.indexOf(v.doubleValue()) + 1).collect(Collectors.toList());
    }

    public static int getDistinct(Collection<? extends Number> data) {
        return (int)data.stream().distinct().count();
    }

    public static double hypot(double a, double b) {
        return Math.sqrt(a * a + b * b);
    }

    public static double getIQR(Collection<? extends Number> data) {
        List sorted = data.stream().map(Number::doubleValue).sorted().collect(Collectors.toList());
        return Statistics.calculatePercentile(sorted, 75.0) - Statistics.calculatePercentile(sorted, 25.0);
    }
}

