/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.millennium.types.concurrent;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;

public final class ConcurrentList<T> {
    private final List<T> list;
    private final Set<T> clamp;

    public ConcurrentList(List<T> list) {
        this.list = Collections.synchronizedList(list);
        this.clamp = Collections.synchronizedSet(new HashSet());
    }

    public void add(T object) {
        Objects.requireNonNull(object, "Object cannot be null");
        this.list.add(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int i) {
        List<T> list = this.list;
        synchronized (list) {
            return this.list.get(i);
        }
    }

    public void remove(T object) {
        Objects.requireNonNull(object, "Object cannot be null");
        this.list.remove(object);
    }

    public void clear() {
        this.list.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SafeVarargs
    public final void remove(T ... objects) {
        Objects.requireNonNull(objects, "Objects cannot be null");
        List<T> list = this.list;
        synchronized (list) {
            this.list.removeAll(Arrays.asList(objects));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Set<T> objects) {
        Objects.requireNonNull(objects, "Objects cannot be null");
        List<T> list = this.list;
        synchronized (list) {
            this.list.removeAll(objects);
        }
    }

    public void removeClamp(T object) {
        Objects.requireNonNull(object, "Object cannot be null");
        this.clamp.add(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyClamp() {
        List<T> list = this.list;
        synchronized (list) {
            this.list.removeAll(this.clamp);
            Set<T> set = this.clamp;
            synchronized (set) {
                this.clamp.clear();
            }
        }
    }

    @Generated
    public List<T> getList() {
        return this.list;
    }
}

