/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.millennium.types.concurrent;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;

public final class ForceThreadList<T> {
    private final List<T> list;
    private final Set<T> clamp;
    private final ExecutorService service;

    public ForceThreadList(List<T> list, ExecutorService service) {
        this.list = Collections.synchronizedList(list);
        this.clamp = Collections.synchronizedSet(new HashSet());
        this.service = service;
    }

    public ForceThreadList(List<T> list, int pool) {
        this(list, Executors.newScheduledThreadPool(pool));
    }

    public ForceThreadList(List<T> list) {
        this(list, Executors.newScheduledThreadPool(1));
    }

    public void add(T object) {
        this.service.submit(() -> {
            List<T> list = this.list;
            synchronized (list) {
                this.list.add(object);
            }
        });
    }

    public T get(int i) {
        try {
            return (T)this.service.submit(() -> {
                List<T> list = this.list;
                synchronized (list) {
                    return this.list.get(i);
                }
            }).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get element", e);
        }
    }

    public void remove(T object) {
        this.service.submit(() -> {
            List<T> list = this.list;
            synchronized (list) {
                this.list.remove(object);
            }
        });
    }

    public void clear() {
        this.service.submit(() -> {
            List<T> list = this.list;
            synchronized (list) {
                this.list.clear();
            }
        });
    }

    @SafeVarargs
    public final void remove(T ... objects) {
        this.service.submit(() -> {
            List<T> list = this.list;
            synchronized (list) {
                this.list.removeAll(Arrays.asList(objects));
            }
        });
    }

    public void remove(Set<T> objects) {
        this.service.submit(() -> {
            List<T> list = this.list;
            synchronized (list) {
                this.list.removeAll(objects);
            }
        });
    }

    public void removeClamp(T object) {
        this.service.submit(() -> this.clamp);
    }

    @Generated
    public List<T> getList() {
        return this.list;
    }
}

