/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.world;

import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Boss;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.OpenCreative;
import ua.mcchickenstudio.opencreative.utils.FileUtils;
import ua.mcchickenstudio.opencreative.utils.PlayerUtils;

public final class WorldUtils {
    @NotNull
    public static String getPlanetIdFromName(@NotNull World world) {
        if (world == null) {
            WorldUtils.$$$reportNull$$$0(0);
        }
        String string = world.getName().replace(String.valueOf(Bukkit.getServer().getWorldContainer()) + "/", "").replace("planets/planet", "");
        if (string == null) {
            WorldUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean isPlanet(@NotNull World world) {
        if (world == null) {
            WorldUtils.$$$reportNull$$$0(2);
        }
        return world.getName().contains("planets/planet");
    }

    public static boolean isOpenCreativeWorld(@NotNull World world) {
        if (world == null) {
            WorldUtils.$$$reportNull$$$0(3);
        }
        return WorldUtils.isLobbyWorld(world) || WorldUtils.isPlanet(world) || WorldUtils.isDevPlanet(world);
    }

    public static boolean isEntityHostile(@Nullable Entity entity) {
        return entity instanceof Enemy || entity instanceof Boss;
    }

    public static boolean isDevPlanet(World world) {
        return world.getName().endsWith("dev");
    }

    public static boolean isLobbyWorld(@NotNull World world) {
        if (world == null) {
            WorldUtils.$$$reportNull$$$0(4);
        }
        return world.equals((Object)PlayerUtils.getLobbyWorld());
    }

    public static int generateWorldID() {
        boolean exists;
        int newWorldID = OpenCreative.getPlugin().getConfig().getInt("last-world-id", 1);
        block0: do {
            ++newWorldID;
            exists = false;
            for (File folder : FileUtils.getWorldsFolders()) {
                if (folder.getName().equalsIgnoreCase("planet" + newWorldID)) {
                    exists = true;
                    continue block0;
                }
                if (!folder.getName().equalsIgnoreCase("planet" + newWorldID + "dev")) continue;
                exists = true;
                continue block0;
            }
        } while (exists);
        OpenCreative.getPlugin().getConfig().set("last-world-id", (Object)newWorldID);
        OpenCreative.getPlugin().saveConfig();
        return newWorldID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "world";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/utils/world/WorldUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/utils/world/WorldUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlanetIdFromName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPlanetIdFromName";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPlanet";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isOpenCreativeWorld";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isLobbyWorld";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

