/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.world.cache;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.events.ListenerOptions;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import java.util.Collections;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.world.cache.ChunkCache;

public class ChunkPacketListener
extends PacketAdapter {
    public ChunkPacketListener(Plugin plugin) {
        super(plugin, ListenerPriority.HIGHEST, Collections.singletonList(PacketType.Play.Server.MAP_CHUNK), new ListenerOptions[]{ListenerOptions.ASYNC});
    }

    public void onPacketSending(PacketEvent event) {
        World world = event.getPlayer().getWorld();
        try {
            int chunkX = (Integer)event.getPacket().getIntegers().read(0);
            int chunkZ = (Integer)event.getPacket().getIntegers().read(1);
            ChunkCache.preLoad(world, chunkX, chunkZ);
        }
        catch (Exception error) {
            ErrorUtils.sendDebugError("Cannot preload chunks.", error);
        }
    }
}

