/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.world.generators;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.block.Biome;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.utils.world.generators.WorldGenerator;

public abstract class AbstractFlatGenerator
extends WorldGenerator {
    protected final Map<Integer, Material> blocks;
    protected Biome biome;
    protected boolean generateTrees;

    public AbstractFlatGenerator(@NotNull String id, @NotNull ItemStack displayIcon) {
        if (id == null) {
            AbstractFlatGenerator.$$$reportNull$$$0(0);
        }
        if (displayIcon == null) {
            AbstractFlatGenerator.$$$reportNull$$$0(1);
        }
        super(id, displayIcon);
        this.blocks = new HashMap<Integer, Material>();
        this.biome = Biome.PLAINS;
        this.generateTrees = false;
    }

    @Override
    public void modifyWorldCreator(@NotNull WorldCreator creator) {
        if (creator == null) {
            AbstractFlatGenerator.$$$reportNull$$$0(2);
        }
        creator.type(WorldType.FLAT);
        creator.generator((ChunkGenerator)this);
    }

    @Override
    public void afterCreation(@NotNull World world) {
        if (world == null) {
            AbstractFlatGenerator.$$$reportNull$$$0(3);
        }
    }

    public void generateSurface(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull ChunkGenerator.ChunkData chunkData) {
        if (worldInfo == null) {
            AbstractFlatGenerator.$$$reportNull$$$0(4);
        }
        if (random == null) {
            AbstractFlatGenerator.$$$reportNull$$$0(5);
        }
        if (chunkData == null) {
            AbstractFlatGenerator.$$$reportNull$$$0(6);
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int y = chunkData.getMinHeight(); y < chunkData.getMaxHeight(); ++y) {
                    Material material = this.blocks.getOrDefault(y, Material.AIR);
                    if (!material.isBlock() || material == Material.AIR) continue;
                    chunkData.setBlock(i, y, j, material);
                }
            }
        }
    }

    @Nullable
    public BiomeProvider getDefaultBiomeProvider(@NotNull WorldInfo worldInfo) {
        if (worldInfo == null) {
            AbstractFlatGenerator.$$$reportNull$$$0(7);
        }
        return new BiomeProvider(){

            @NotNull
            public Biome getBiome(@NotNull WorldInfo worldInfo, int x, int y, int z) {
                if (worldInfo == null) {
                    1.$$$reportNull$$$0(0);
                }
                Biome biome = AbstractFlatGenerator.this.biome;
                if (biome == null) {
                    1.$$$reportNull$$$0(1);
                }
                return biome;
            }

            @NotNull
            public List<Biome> getBiomes(@NotNull WorldInfo worldInfo) {
                if (worldInfo == null) {
                    1.$$$reportNull$$$0(2);
                }
                List<Biome> list = List.of(AbstractFlatGenerator.this.biome);
                if (list == null) {
                    1.$$$reportNull$$$0(3);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "worldInfo";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "ua/mcchickenstudio/opencreative/utils/world/generators/AbstractFlatGenerator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "ua/mcchickenstudio/opencreative/utils/world/generators/AbstractFlatGenerator$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBiome";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBiomes";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getBiome";
                        break;
                    }
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getBiomes";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3 -> new IllegalStateException(string);
                };
            }
        };
    }

    @NotNull
    public List<BlockPopulator> getDefaultPopulators(@NotNull World world) {
        if (world == null) {
            AbstractFlatGenerator.$$$reportNull$$$0(8);
        }
        ArrayList<BlockPopulator> list = new ArrayList<BlockPopulator>();
        if (!this.generateTrees) {
            ArrayList<BlockPopulator> arrayList = list;
            if (arrayList == null) {
                AbstractFlatGenerator.$$$reportNull$$$0(9);
            }
            return arrayList;
        }
        list.add(new BlockPopulator(){

            public void populate(@NotNull WorldInfo worldInfo, @NotNull Random random, int chunkX, int chunkZ, @NotNull LimitedRegion limitedRegion) {
                if (worldInfo == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (random == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (limitedRegion == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (random.nextBoolean()) {
                    TreeType type = this.getTreeFromBiome(AbstractFlatGenerator.this.biome);
                    if (type == null) {
                        return;
                    }
                    int amount = random.nextInt(2) + 1;
                    for (int tree = 1; tree < amount; ++tree) {
                        int treeX = (chunkX << 4) + random.nextInt(9) + 3;
                        int treeZ = (chunkZ << 4) + random.nextInt(9) + 3;
                        int treeY = limitedRegion.getHighestBlockYAt(treeX, treeZ);
                        limitedRegion.generateTree(new Location(null, (double)treeX, (double)treeY, (double)treeZ), random, type);
                    }
                }
            }

            @Nullable
            public TreeType getTreeFromBiome(@NotNull Biome biome) {
                if (biome == null) {
                    2.$$$reportNull$$$0(3);
                }
                return switch (biome) {
                    case Biome.PLAINS, Biome.TAIGA, Biome.WINDSWEPT_FOREST, Biome.SNOWY_TAIGA, Biome.OLD_GROWTH_SPRUCE_TAIGA -> TreeType.TREE;
                    case Biome.DARK_FOREST -> TreeType.DARK_OAK;
                    case Biome.BIRCH_FOREST -> TreeType.BIRCH;
                    case Biome.JUNGLE -> TreeType.JUNGLE;
                    case Biome.SAVANNA -> TreeType.ACACIA;
                    case Biome.LUSH_CAVES -> TreeType.AZALEA;
                    case Biome.MANGROVE_SWAMP -> TreeType.MANGROVE;
                    case Biome.CHERRY_GROVE -> TreeType.CHERRY;
                    case Biome.MUSHROOM_FIELDS -> TreeType.RED_MUSHROOM;
                    case Biome.SMALL_END_ISLANDS -> TreeType.CHORUS_PLANT;
                    case Biome.ICE_SPIKES, Biome.SNOWY_PLAINS -> TreeType.MEGA_PINE;
                    default -> null;
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "worldInfo";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "random";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "limitedRegion";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "biome";
                        break;
                    }
                }
                objectArray2[1] = "ua/mcchickenstudio/opencreative/utils/world/generators/AbstractFlatGenerator$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "populate";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getTreeFromBiome";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<BlockPopulator> arrayList = list;
        if (arrayList == null) {
            AbstractFlatGenerator.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayIcon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "world";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "worldInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "random";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunkData";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/utils/world/generators/AbstractFlatGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/utils/world/generators/AbstractFlatGenerator";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPopulators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "modifyWorldCreator";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "afterCreation";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "generateSurface";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultBiomeProvider";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPopulators";
                break;
            }
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 10 -> new IllegalStateException(string);
        };
    }
}

