/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.world.generators;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.world.generators.AbstractFlatGenerator;

public final class CustomFlatGenerator
extends AbstractFlatGenerator {
    public CustomFlatGenerator(@NotNull String id, @NotNull ItemStack displayIcon, @NotNull String generation, boolean generateTrees) {
        if (id == null) {
            CustomFlatGenerator.$$$reportNull$$$0(0);
        }
        if (displayIcon == null) {
            CustomFlatGenerator.$$$reportNull$$$0(1);
        }
        if (generation == null) {
            CustomFlatGenerator.$$$reportNull$$$0(2);
        }
        super(id, displayIcon);
        Map<Integer, Material> generationBlocks = this.getBlocksFromText(generation);
        for (int y : generationBlocks.keySet()) {
            this.blocks.put(y, generationBlocks.get(y));
        }
        this.generateTrees = generateTrees;
    }

    @NotNull
    private Map<Integer, Material> getBlocksFromText(@NotNull String text) {
        String[] blocksAndBiome;
        LinkedHashMap<Integer, Material> blocksMap;
        block17: {
            if (text == null) {
                CustomFlatGenerator.$$$reportNull$$$0(3);
            }
            blocksMap = new LinkedHashMap<Integer, Material>();
            text = text.toUpperCase().replace("-", "_").replace("MINECRAFT:", "");
            blocksAndBiome = text.split(";");
            String[] blocks = blocksAndBiome[0].split(",");
            int y = 0;
            for (String blockData : blocks) {
                String[] amountAndMaterial = blockData.split("\\*");
                String amountString = "";
                String materialString = "";
                if (amountAndMaterial.length == 1) {
                    amountString = "1";
                    materialString = amountAndMaterial[0];
                } else if (amountAndMaterial.length == 2) {
                    amountString = amountAndMaterial[0];
                    materialString = amountAndMaterial[1];
                }
                int amount = 1;
                Material material = Material.AIR;
                try {
                    amount = Integer.parseInt(amountString);
                    if (amount < 0 || amount > 320) {
                        amount = 1;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                material = Objects.requireNonNullElse(Material.getMaterial((String)materialString), material);
                if (!material.isBlock() || material == Material.AIR) {
                    y += amount;
                    continue;
                }
                for (int i = 0; i < amount; ++i) {
                    blocksMap.put(y, material);
                    ++y;
                }
            }
            if (blocksAndBiome.length != 1) break block17;
            LinkedHashMap<Integer, Material> linkedHashMap = blocksMap;
            if (linkedHashMap == null) {
                CustomFlatGenerator.$$$reportNull$$$0(4);
            }
            return linkedHashMap;
        }
        try {
            String biomeString = blocksAndBiome[1];
            Biome biome = this.getBiome(biomeString);
            if (biome != null) {
                this.biome = biome;
            } else {
                ErrorUtils.sendWarningErrorMessage("Can't recognize biome for " + this.getID() + ": " + biomeString);
            }
        }
        catch (Exception error) {
            ErrorUtils.sendWarningErrorMessage("Can't parse custom flat generation pattern for " + this.getID() + ": " + text);
        }
        LinkedHashMap<Integer, Material> linkedHashMap = blocksMap;
        if (linkedHashMap == null) {
            CustomFlatGenerator.$$$reportNull$$$0(5);
        }
        return linkedHashMap;
    }

    @Nullable
    private Biome getBiome(@Nullable String text) {
        if (text == null) {
            return null;
        }
        try {
            return Biome.valueOf((String)text);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getExtensionId() {
        return "default";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Generates flat world by settings";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayIcon";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/utils/world/generators/CustomFlatGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/utils/world/generators/CustomFlatGenerator";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlocksFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBlocksFromText";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

