/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.world.generators;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.bukkit.Material;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.world.generators.WorldGenerator;

public final class WorldGenerators {
    private static WorldGenerators instance;
    private final List<WorldGenerator> generators = new LinkedList<WorldGenerator>();

    @NotNull
    public static synchronized WorldGenerators getInstance() {
        if (instance == null) {
            instance = new WorldGenerators();
        }
        WorldGenerators worldGenerators = instance;
        if (worldGenerators == null) {
            WorldGenerators.$$$reportNull$$$0(0);
        }
        return worldGenerators;
    }

    public void registerWorldGenerator(@NotNull WorldGenerator generator) {
        WorldGenerator existing;
        if (generator == null) {
            WorldGenerators.$$$reportNull$$$0(1);
        }
        if ((existing = this.getById(generator.getID())) != null) {
            ErrorUtils.sendDebug("[GENERATORS] Can't register world generator " + generator.getName() + " (from " + generator.getExtensionId() + "), because there's already registered world generator " + existing.getName() + " (from " + existing.getExtensionId() + ") with same ID: " + generator.getID());
            return;
        }
        ErrorUtils.sendDebug("[GENERATORS] Registered world generator: " + generator.getName() + " (from " + generator.getExtensionId() + ")");
        this.generators.add(generator);
    }

    public void registerWorldGenerator(WorldGenerator ... generator) {
        if (generator == null) {
            WorldGenerators.$$$reportNull$$$0(2);
        }
        for (WorldGenerator value : generator) {
            this.registerWorldGenerator(value);
        }
    }

    public void unregisterWorldGenerator(@NotNull WorldGenerator generator) {
        if (generator == null) {
            WorldGenerators.$$$reportNull$$$0(3);
        }
        this.generators.remove(generator);
    }

    public void clearWorldGenerators() {
        this.generators.clear();
    }

    @NotNull
    public List<WorldGenerator> getWorldGenerators() {
        return new ArrayList<WorldGenerator>(this.generators);
    }

    @NotNull
    public List<Object> getGeneratorsIDs() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (WorldGenerator generator : this.generators) {
            list.add(generator.getID());
        }
        ArrayList<Object> arrayList = list;
        if (arrayList == null) {
            WorldGenerators.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public List<Material> getGeneratorsMaterials() {
        ArrayList<Material> list = new ArrayList<Material>();
        for (WorldGenerator generator : this.generators) {
            list.add(generator.getDisplayIcon().getType());
        }
        ArrayList<Material> arrayList = list;
        if (arrayList == null) {
            WorldGenerators.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    public WorldGenerator getById(@NotNull String id) {
        if (id == null) {
            WorldGenerators.$$$reportNull$$$0(6);
        }
        for (WorldGenerator generator : this.generators) {
            if (!generator.getID().equals(id)) continue;
            return generator;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/utils/world/generators/WorldGenerators";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/utils/world/generators/WorldGenerators";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorsIDs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getGeneratorsMaterials";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerWorldGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "unregisterWorldGenerator";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getById";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6 -> new IllegalArgumentException(string);
        };
    }
}

