/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.world.platforms;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.utils.ErrorUtils;
import ua.mcchickenstudio.opencreative.utils.world.platforms.DevPlatformer;
import ua.mcchickenstudio.opencreative.utils.world.platforms.HorizontalPlatformer;
import ua.mcchickenstudio.opencreative.utils.world.platforms.LegacyPlatformer;
import ua.mcchickenstudio.opencreative.utils.world.platforms.VerticalPlatformer;

public final class DevPlatformers {
    private static DevPlatformers instance;
    private final List<DevPlatformer> platformers = new LinkedList<DevPlatformer>();

    private DevPlatformers() {
    }

    public static synchronized DevPlatformers getInstance() {
        if (instance == null) {
            instance = new DevPlatformers();
            instance.registerDevPlatformer(new HorizontalPlatformer());
            instance.registerDevPlatformer(new VerticalPlatformer());
            instance.registerDevPlatformer(new LegacyPlatformer());
        }
        return instance;
    }

    public void registerDevPlatformer(@NotNull DevPlatformer platformer) {
        DevPlatformer existing;
        if (platformer == null) {
            DevPlatformers.$$$reportNull$$$0(0);
        }
        if ((existing = this.getById(platformer.getID())) != null) {
            ErrorUtils.sendDebug("[PLATFORMERS] Can't register coding platforms generator " + platformer.getName() + ", because there's already registered coding platformer " + existing.getName() + " with same ID: " + platformer.getID());
            return;
        }
        ErrorUtils.sendDebug("[PLATFORMERS] Registered coding platform generator: " + platformer.getName() + " (from " + platformer.getExtensionId() + ")");
        this.platformers.add(platformer);
    }

    @Nullable
    public DevPlatformer getById(@NotNull String id) {
        if (id == null) {
            DevPlatformers.$$$reportNull$$$0(1);
        }
        for (DevPlatformer platformer : this.platformers) {
            if (!platformer.getID().equals(id)) continue;
            return platformer;
        }
        return null;
    }

    @NotNull
    public List<String> getPlatformersIDs() {
        ArrayList<String> list = new ArrayList<String>();
        for (DevPlatformer platformer : this.platformers) {
            list.add(platformer.getID());
        }
        ArrayList<String> arrayList = list;
        if (arrayList == null) {
            DevPlatformers.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platformer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/utils/world/platforms/DevPlatformers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/utils/world/platforms/DevPlatformers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformersIDs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerDevPlatformer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getById";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

