/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.world.platforms;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.DevPlatform;
import ua.mcchickenstudio.opencreative.utils.world.platforms.DevPlatformer;

public final class HorizontalPlatformer
extends DevPlatformer {
    public HorizontalPlatformer() {
        super("horizontal");
    }

    @Override
    public void setWorldBorder(@NotNull DevPlanet devPlanet) {
        if (devPlanet == null) {
            HorizontalPlatformer.$$$reportNull$$$0(0);
        }
        World world = devPlanet.getWorld();
        world.getWorldBorder().setWarningDistance(0);
        world.getWorldBorder().setCenter(50.0, 50.0);
        world.getWorldBorder().setSize(120.0);
        DevPlatform platformZ = this.getFarPlatformByZ(devPlanet);
        DevPlatform platformX = this.getFarPlatformByX(devPlanet);
        double endZ = this.getPlatformEndLocation(platformZ).getBlockZ();
        double endX = this.getPlatformEndLocation(platformX).getBlockX();
        double centerZ = endZ / 2.0;
        double centerX = endX / 2.0;
        world.getWorldBorder().setCenter(centerX, centerZ);
        double size = (Math.max(endX, endZ) - Math.max(centerX, centerZ)) * 2.0 + 20.0;
        world.getWorldBorder().setSize(size);
    }

    @Override
    @Nullable
    public DevPlatform getPlatformInLocation(@NotNull DevPlanet devPlanet, @NotNull Location location) {
        if (devPlanet == null) {
            HorizontalPlatformer.$$$reportNull$$$0(1);
        }
        if (location == null) {
            HorizontalPlatformer.$$$reportNull$$$0(2);
        }
        double x = location.getX();
        double z = location.getZ();
        for (DevPlatform platform : this.getPlatforms(devPlanet)) {
            Location begin = this.getPlatformBeginLocation(platform);
            Location end = this.getPlatformEndLocation(platform);
            if (!(x >= (double)begin.getBlockX()) || !(x <= (double)end.getBlockX()) || !(z >= (double)begin.getBlockZ()) || !(z <= (double)end.getBlockZ())) continue;
            return platform;
        }
        return null;
    }

    @Override
    @NotNull
    public DevPlatform getFarPlatformByX(@NotNull DevPlanet devPlanet) {
        if (devPlanet == null) {
            HorizontalPlatformer.$$$reportNull$$$0(3);
        }
        DevPlatform farPlatform = new DevPlatform(devPlanet, 1, 1);
        if (!devPlanet.isLoaded()) {
            DevPlatform devPlatform = farPlatform;
            if (devPlatform == null) {
                HorizontalPlatformer.$$$reportNull$$$0(4);
            }
            return devPlatform;
        }
        for (int x = 2; x <= 5; ++x) {
            DevPlatform current = new DevPlatform(devPlanet, x, 1);
            if (!current.exists()) continue;
            farPlatform = current;
        }
        DevPlatform devPlatform = farPlatform;
        if (devPlatform == null) {
            HorizontalPlatformer.$$$reportNull$$$0(5);
        }
        return devPlatform;
    }

    @Override
    @NotNull
    public DevPlatform getFarPlatformByZ(@NotNull DevPlanet devPlanet) {
        if (devPlanet == null) {
            HorizontalPlatformer.$$$reportNull$$$0(6);
        }
        DevPlatform farPlatform = new DevPlatform(devPlanet, 1, 1);
        if (!devPlanet.isLoaded()) {
            DevPlatform devPlatform = farPlatform;
            if (devPlatform == null) {
                HorizontalPlatformer.$$$reportNull$$$0(7);
            }
            return devPlatform;
        }
        for (int z = 2; z <= 5; ++z) {
            DevPlatform current = new DevPlatform(devPlanet, 1, z);
            if (!current.exists()) continue;
            farPlatform = current;
        }
        DevPlatform devPlatform = farPlatform;
        if (devPlatform == null) {
            HorizontalPlatformer.$$$reportNull$$$0(8);
        }
        return devPlatform;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull DevPlatform> getPlatforms(@NotNull DevPlanet devPlanet) {
        if (devPlanet == null) {
            HorizontalPlatformer.$$$reportNull$$$0(9);
        }
        ArrayList<DevPlatform> platforms = new ArrayList<DevPlatform>();
        if (!devPlanet.isLoaded()) {
            ArrayList<DevPlatform> arrayList = platforms;
            if (arrayList == null) {
                HorizontalPlatformer.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        for (int x = 1; x <= this.getFarPlatformByX(devPlanet).getX(); ++x) {
            for (int z = 1; z <= this.getFarPlatformByZ(devPlanet).getZ(); ++z) {
                DevPlatform platform = new DevPlatform(devPlanet, x, z);
                if (!platform.exists()) continue;
                platforms.add(platform);
            }
        }
        ArrayList<DevPlatform> arrayList = platforms;
        if (arrayList == null) {
            HorizontalPlatformer.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    public boolean claimPlatform(@NotNull DevPlanet devPlanet, @NotNull DevPlatform platform) {
        if (devPlanet == null) {
            HorizontalPlatformer.$$$reportNull$$$0(12);
        }
        if (platform == null) {
            HorizontalPlatformer.$$$reportNull$$$0(13);
        }
        if (!devPlanet.isLoaded()) {
            return false;
        }
        if (platform.exists()) {
            return false;
        }
        this.buildPlatform(platform, DevPlanet.getDefaultFloorMaterial(), DevPlanet.getDefaultEventMaterial(), DevPlanet.getDefaultActionMaterial());
        this.setWorldBorder(devPlanet);
        devPlanet.displayWorldBorders();
        return true;
    }

    @Override
    public boolean buildPlatform(@NotNull DevPlatform platform, Material floorMaterial, Material eventMaterial, Material actionMaterial) {
        if (platform == null) {
            HorizontalPlatformer.$$$reportNull$$$0(14);
        }
        Location begin = this.getPlatformBeginLocation(platform);
        Location end = this.getPlatformEndLocation(platform);
        int beginX = begin.getBlockX();
        int endX = end.getBlockX();
        int beginZ = begin.getBlockZ();
        int endZ = end.getBlockZ();
        int executorX = beginX + 4;
        for (int x = beginX; x <= endX; ++x) {
            for (int z = beginZ; z <= endZ; ++z) {
                Block block = platform.getWorld().getBlockAt(x, 0, z);
                if (x == executorX && (z - beginZ) % 4 == 0 && z != beginZ && z != endZ) {
                    block.setType(eventMaterial);
                } else if (x > executorX && (x - executorX) % 2 == 0 && x < endX - 2 && (z - beginZ) % 4 == 0 && z != beginZ && z != endZ) {
                    block.setType(actionMaterial);
                } else {
                    block.setType(floorMaterial);
                }
                block.setBiome(Biome.ICE_SPIKES);
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Location getPlatformBeginLocation(@NotNull DevPlatform platform) {
        if (platform == null) {
            HorizontalPlatformer.$$$reportNull$$$0(15);
        }
        return new Location(platform.getWorld(), (double)((platform.getX() - 1) * 102), 0.0, (double)((platform.getZ() - 1) * 102));
    }

    @Override
    @NotNull
    public Location getPlatformEndLocation(@NotNull DevPlatform platform) {
        if (platform == null) {
            HorizontalPlatformer.$$$reportNull$$$0(16);
        }
        Location location = this.getPlatformBeginLocation(platform).clone().add(100.0, 0.0, 100.0);
        if (location == null) {
            HorizontalPlatformer.$$$reportNull$$$0(17);
        }
        return location;
    }

    @Override
    @NotNull
    public DevPlatform getNextAvailablePlatform(@NotNull DevPlanet planet) {
        int[] coords;
        if (planet == null) {
            HorizontalPlatformer.$$$reportNull$$$0(18);
        }
        int[][] platformCoordinates = new int[][]{{2, 1}, {1, 2}, {2, 2}, {3, 1}, {1, 3}, {2, 3}, {3, 2}, {3, 3}, {4, 1}, {1, 4}, {4, 2}, {2, 4}, {4, 3}, {3, 4}, {4, 4}};
        DevPlatform platform = null;
        int[][] nArrayArray = platformCoordinates;
        int n = nArrayArray.length;
        for (int i = 0; i < n && (platform = new DevPlatform(planet, (coords = nArrayArray[i])[0], coords[1])).exists(); ++i) {
        }
        DevPlatform devPlatform = platform;
        if (devPlatform == null) {
            HorizontalPlatformer.$$$reportNull$$$0(19);
        }
        return devPlatform;
    }

    @Override
    public int getCodingBlocksLimit(@NotNull DevPlanet planet) {
        if (planet == null) {
            HorizontalPlatformer.$$$reportNull$$$0(20);
        }
        return 46;
    }

    @Override
    public boolean notDependsOnHeight() {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return "Horizontal Platforms Generator";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Builds coding platforms like plots";
    }

    @Override
    @NotNull
    public String getExtensionId() {
        return "default";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8, 10, 11, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devPlanet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/utils/world/platforms/HorizontalPlatformer";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "planet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/utils/world/platforms/HorizontalPlatformer";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFarPlatformByX";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFarPlatformByZ";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatforms";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformEndLocation";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextAvailablePlatform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setWorldBorder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformInLocation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFarPlatformByX";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 17: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFarPlatformByZ";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPlatforms";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "claimPlatform";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildPlatform";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformBeginLocation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformEndLocation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNextAvailablePlatform";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCodingBlocksLimit";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8, 10, 11, 17, 19 -> new IllegalStateException(string);
        };
    }
}

