/*
 * Decompiled with CFR 0.152.
 */
package ua.mcchickenstudio.opencreative.utils.world.platforms;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ua.mcchickenstudio.opencreative.planets.DevPlanet;
import ua.mcchickenstudio.opencreative.planets.DevPlatform;
import ua.mcchickenstudio.opencreative.utils.world.platforms.DevPlatformer;
import ua.mcchickenstudio.opencreative.utils.world.platforms.HasVisibleBorder;

public final class LegacyPlatformer
extends DevPlatformer
implements HasVisibleBorder {
    public LegacyPlatformer() {
        super("legacy");
    }

    @Override
    public void setWorldBorder(@NotNull DevPlanet devPlanet) {
        if (devPlanet == null) {
            LegacyPlatformer.$$$reportNull$$$0(0);
        }
        World world = devPlanet.getWorld();
        world.getWorldBorder().setWarningDistance(0);
        world.getWorldBorder().setCenter(50.0, 50.0);
        world.getWorldBorder().setSize(100.0);
    }

    @Override
    @Nullable
    public DevPlatform getPlatformInLocation(@NotNull DevPlanet devPlanet, @NotNull Location location) {
        if (devPlanet == null) {
            LegacyPlatformer.$$$reportNull$$$0(1);
        }
        if (location == null) {
            LegacyPlatformer.$$$reportNull$$$0(2);
        }
        double x = location.getX();
        double y = location.getY();
        double z = location.getZ();
        for (DevPlatform platform : this.getPlatforms(devPlanet)) {
            Location beginLocation = this.getPlatformBeginLocation(platform);
            int height = beginLocation.getBlockY();
            int begin = beginLocation.getBlockX();
            int end = platform.getEndCoordinate();
            if (!(x >= (double)begin) || !(x <= (double)end) || !(z >= (double)begin) || !(z <= (double)end) || !(y >= (double)height) || !(y <= (double)(height + 3))) continue;
            return platform;
        }
        return null;
    }

    @Override
    @NotNull
    public DevPlatform getFarPlatformByX(@NotNull DevPlanet devPlanet) {
        if (devPlanet == null) {
            LegacyPlatformer.$$$reportNull$$$0(3);
        }
        return new DevPlatform(devPlanet, 1, 1);
    }

    @Override
    @NotNull
    public DevPlatform getFarPlatformByZ(@NotNull DevPlanet devPlanet) {
        if (devPlanet == null) {
            LegacyPlatformer.$$$reportNull$$$0(4);
        }
        DevPlatform farPlatform = new DevPlatform(devPlanet, 1, 1);
        if (!devPlanet.isLoaded()) {
            DevPlatform devPlatform = farPlatform;
            if (devPlatform == null) {
                LegacyPlatformer.$$$reportNull$$$0(5);
            }
            return devPlatform;
        }
        for (int z = 2; z <= 25; ++z) {
            DevPlatform current = new DevPlatform(devPlanet, 1, z);
            if (!current.exists()) continue;
            farPlatform = current;
        }
        DevPlatform devPlatform = farPlatform;
        if (devPlatform == null) {
            LegacyPlatformer.$$$reportNull$$$0(6);
        }
        return devPlatform;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull DevPlatform> getPlatforms(@NotNull DevPlanet devPlanet) {
        if (devPlanet == null) {
            LegacyPlatformer.$$$reportNull$$$0(7);
        }
        ArrayList<DevPlatform> platforms = new ArrayList<DevPlatform>();
        if (!devPlanet.isLoaded()) {
            ArrayList<DevPlatform> arrayList = platforms;
            if (arrayList == null) {
                LegacyPlatformer.$$$reportNull$$$0(8);
            }
            return arrayList;
        }
        for (int z = 1; z <= this.getFarPlatformByZ(devPlanet).getZ(); ++z) {
            DevPlatform platform = new DevPlatform(devPlanet, 1, z);
            if (!platform.exists()) continue;
            platforms.add(platform);
        }
        ArrayList<DevPlatform> arrayList = platforms;
        if (arrayList == null) {
            LegacyPlatformer.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    public boolean claimPlatform(@NotNull DevPlanet devPlanet, @NotNull DevPlatform platform) {
        if (devPlanet == null) {
            LegacyPlatformer.$$$reportNull$$$0(10);
        }
        if (platform == null) {
            LegacyPlatformer.$$$reportNull$$$0(11);
        }
        if (!devPlanet.isLoaded()) {
            return false;
        }
        if (platform.exists()) {
            return false;
        }
        this.buildPlatform(platform, DevPlanet.getDefaultFloorMaterial(), DevPlanet.getDefaultEventMaterial(), DevPlanet.getDefaultActionMaterial());
        this.setWorldBorder(devPlanet);
        devPlanet.displayWorldBorders();
        return true;
    }

    @Override
    public boolean buildPlatform(@NotNull DevPlatform platform, Material floorMaterial, Material eventMaterial, Material actionMaterial) {
        if (platform == null) {
            LegacyPlatformer.$$$reportNull$$$0(12);
        }
        Location begin = this.getPlatformBeginLocation(platform);
        Location end = this.getPlatformEndLocation(platform);
        int height = begin.getBlockY();
        int beginX = begin.getBlockX();
        int endX = end.getBlockX();
        int beginZ = begin.getBlockZ();
        int endZ = end.getBlockZ();
        int executorX = beginX + 4;
        for (int x = beginX; x <= endX; ++x) {
            for (int z = beginZ; z <= endZ; ++z) {
                Block block = platform.getWorld().getBlockAt(x, height, z);
                if (x == executorX && (z - beginZ) % 4 == 0 && z != beginZ && z != endZ) {
                    block.setType(eventMaterial);
                } else if (x > executorX && (x - executorX) % 2 == 0 && x < endX - 2 && (z - beginZ) % 4 == 0 && z != beginZ && z != endZ) {
                    block.setType(actionMaterial);
                } else if (height <= 1 || x >= beginX + 4 && x <= endX - 4 && z >= beginZ + 4 && z <= endZ - 4) {
                    block.setType(floorMaterial);
                }
                block.setBiome(Biome.ICE_SPIKES);
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Location getPlatformBeginLocation(@NotNull DevPlatform platform) {
        if (platform == null) {
            LegacyPlatformer.$$$reportNull$$$0(13);
        }
        return new Location(platform.getWorld(), 0.0, (double)((platform.getZ() - 1) * 10), 0.0);
    }

    @Override
    @NotNull
    public Location getPlatformEndLocation(@NotNull DevPlatform platform) {
        if (platform == null) {
            LegacyPlatformer.$$$reportNull$$$0(14);
        }
        Location location = this.getPlatformBeginLocation(platform).clone().add(100.0, 0.0, 100.0);
        if (location == null) {
            LegacyPlatformer.$$$reportNull$$$0(15);
        }
        return location;
    }

    @Override
    @NotNull
    public DevPlatform getNextAvailablePlatform(@NotNull DevPlanet planet) {
        if (planet == null) {
            LegacyPlatformer.$$$reportNull$$$0(16);
        }
        DevPlatform platform = new DevPlatform(planet, 1, 1);
        for (int y = 1; y <= 25; ++y) {
            platform = new DevPlatform(planet, 1, y);
            if (platform.exists()) continue;
            DevPlatform devPlatform = platform;
            if (devPlatform == null) {
                LegacyPlatformer.$$$reportNull$$$0(17);
            }
            return devPlatform;
        }
        DevPlatform devPlatform = platform;
        if (devPlatform == null) {
            LegacyPlatformer.$$$reportNull$$$0(18);
        }
        return devPlatform;
    }

    @Override
    public int getCodingBlocksLimit(@NotNull DevPlanet planet) {
        if (planet == null) {
            LegacyPlatformer.$$$reportNull$$$0(19);
        }
        return 46;
    }

    @Override
    public boolean notDependsOnHeight() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "Legacy Platforms Generator";
    }

    @Override
    @NotNull
    public String getDescription() {
        return "Builds coding platforms like legacy floors";
    }

    @Override
    @NotNull
    public String getExtensionId() {
        return "default";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 8, 9, 15, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devPlanet";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ua/mcchickenstudio/opencreative/utils/world/platforms/LegacyPlatformer";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "platform";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "planet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ua/mcchickenstudio/opencreative/utils/world/platforms/LegacyPlatformer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFarPlatformByZ";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatforms";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlatformEndLocation";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextAvailablePlatform";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setWorldBorder";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformInLocation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFarPlatformByX";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFarPlatformByZ";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPlatforms";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "claimPlatform";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "buildPlatform";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformBeginLocation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPlatformEndLocation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getNextAvailablePlatform";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getCodingBlocksLimit";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 8, 9, 15, 17, 18 -> new IllegalStateException(string);
        };
    }
}

