package xen42.canadamod;

import java.util.Optional;
import java.util.function.Function;

import net.fabricmc.fabric.api.item.v1.FabricItem.Settings;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.fabricmc.fabric.api.registry.FuelRegistryEvents;
import net.fabricmc.fabric.api.registry.StrippableBlockRegistry;
import net.minecraft.class_10717;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2323;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2362;
import net.minecraft.class_2378;
import net.minecraft.class_2400;
import net.minecraft.class_2440;
import net.minecraft.class_2465;
import net.minecraft.class_2473;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2591;
import net.minecraft.class_2625;
import net.minecraft.class_2960;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4719;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.minecraft.class_7717;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8177;
import net.minecraft.class_8813;
import xen42.canadamod.block.CookingPotBlock;
import xen42.canadamod.block.MooseSkullBlock;
import xen42.canadamod.block.MooseWallSkullBlock;
import xen42.canadamod.block.RubberBlock;
import xen42.canadamod.block.TreeTapBlock;
import xen42.canadamod.sign.MapleHangingSignBlock;
import xen42.canadamod.sign.MapleHangingSignBlockEntity;
import xen42.canadamod.sign.MapleSignBlock;
import xen42.canadamod.sign.MapleSignEntity;
import xen42.canadamod.sign.MapleWallHangingSignBlock;
import xen42.canadamod.sign.MapleWallSignBlock;
import xen42.canadamod.world.CanadaConfiguredFeatures;

public class CanadaBlocks {
    public static final class_8177 MAPLE_WOOD_SET = class_8177.method_49233(new class_8177("maple"));
    public static final class_4719 MAPLE_WOOD_TYPE = class_4719.method_24027(new class_4719("maple", MAPLE_WOOD_SET));

	public static class_2248 MAPLE_PLANKS;
    public static class_2248 MAPLE_LOG;
    public static class_2248 MAPLE_LEAVES;
    public static class_2248 STRIPPED_MAPLE_LOG;
    public static class_2248 MAPLE_WOOD;
    public static class_2248 STRIPPED_MAPLE_WOOD;
    public static class_2248 MAPLE_STAIRS;
    public static class_2248 MAPLE_BUTTON;
    public static class_2248 MAPLE_SLAB;
    public static class_2248 MAPLE_DOOR;
    public static class_2248 MAPLE_TRAPDOOR;
    public static class_2248 MAPLE_FENCE;
    public static class_2248 MAPLE_FENCE_GATE;
    public static class_2248 MAPLE_PRESSURE_PLATE;
    public static class_2248 MAPLE_SIGN;
    public static class_2248 MAPLE_WALL_SIGN;
    public static class_2248 MAPLE_HANGING_SIGN;
    public static class_2248 MAPLE_WALL_HANGING_SIGN;

	public static final class_8813 MAPLE_SAPLING_GENERATED = new class_8813("maple", Optional.empty(), 
		Optional.of(CanadaConfiguredFeatures.MAPLE_CONFIGURED_FEATURE), Optional.of(CanadaConfiguredFeatures.MAPLE_CONFIGURED_FEATURE));

	public static final class_2248 MAPLE_SAPLING = register("maple_sapling", 
        settings -> new class_2473(MAPLE_SAPLING_GENERATED, settings), 
        class_4970.class_2251.method_9630(class_2246.field_10394).method_31710(class_3620.field_16020),
		false);

	public static final class_2248 POTTED_MAPLE_SAPLING = register("potted_maple_sapling", 
		settings -> new class_2362(MAPLE_SAPLING, settings), class_2246.method_63176(), 
		false);

	public static class_2248 TREE_TAP = register(
			"tree_tap",
			TreeTapBlock::new,
			class_4970.class_2251.method_9637().method_51369().method_9626(class_2498.field_24119).method_22488().method_50012(class_3619.field_15971).method_9618(),
			false
		);
	
	public static class_2248 COOKING_POT = register(
		"cooking_pot",
		CookingPotBlock::new,
		class_4970.class_2251.method_9637().method_9631(class_2246.method_26107(13)).method_22488()
			.method_31710(class_3620.field_16023).method_50012(class_3619.field_15971).method_36557(0.3f),
		true
	);

	public static class_2248 RUBBER_BLOCK = register("rubber_block", RubberBlock::new, class_4970.class_2251.method_9637()
		.method_9626(class_2498.field_22154).method_31710(class_3620.field_16009).method_36557(0.1f), true);

	public static class_2248 MOOSE_HEAD = register(
		"moose_head",
		MooseSkullBlock::new,
		class_4970.class_2251.method_9637().method_9632(1.0F).method_50012(class_3619.field_15971),
		false
	);

	public static class_2248 MOOSE_WALL_HEAD = register(
		"moose_head_wall",
		MooseWallSkullBlock::new,
		class_4970.class_2251.method_9637().method_9632(1.0F).method_50012(class_3619.field_15971),
		false
	);

	public static class_2248[] MAPLE_BLOCKS;

	public static class_5794 MAPLE;

    public static class_2591<class_2625> MAPLE_SIGN_BLOCK_ENTITY;
    public static class_2591<class_7717> MAPLE_HANGING_SIGN_BLOCK_ENTITY;

	public static class_2400 MAPLE_LEAF_PARTICLE = FabricParticleTypes.simple();

	public static void initialize() {
		MAPLE_PLANKS = register(
			"maple_planks",
			class_2248::new,
			class_4970.class_2251.method_9630(class_2246.field_10161),
			true
		);
		MAPLE_LOG = register(
			"maple_log",
			class_2465::new,
			class_4970.class_2251.method_9630(class_2246.field_10431),
			true
		);
		class_2378.method_10230(class_7923.field_41180,
					class_2960.method_60655(CanadaMod.MOD_ID, "maple"),
					MAPLE_LEAF_PARTICLE);
		MAPLE_LEAVES = register(
			"maple_leaves",
			(settings) -> new class_10717(0.01F, MAPLE_LEAF_PARTICLE, settings),
			class_4970.class_2251.method_9630(class_2246.field_10503),
			true
		);
		STRIPPED_MAPLE_LOG = register(
			"stripped_maple_log",
			class_2465::new,
			class_4970.class_2251.method_9630(class_2246.field_10519),
			true
		);
		MAPLE_WOOD = register(
			"maple_wood",
			class_2465::new,
			class_4970.class_2251.method_9630(class_2246.field_10126),
			true
		);
		STRIPPED_MAPLE_WOOD = register(
			"stripped_maple_wood",
			class_2465::new,
			class_4970.class_2251.method_9630(class_2246.field_10250),
			true
		);
		MAPLE_STAIRS = register(
			"maple_stairs",
			(settings) -> new class_2510(MAPLE_PLANKS.method_9564(), settings),
			class_4970.class_2251.method_9630(class_2246.field_10563),
			true
		);
		MAPLE_BUTTON = register(
			"maple_button",
			(settings) -> new class_2269(MAPLE_WOOD_SET, 30, settings),
			class_4970.class_2251.method_9630(class_2246.field_10057),
			true
		);
		MAPLE_SLAB = register(
			"maple_slab",
			class_2482::new,
			class_4970.class_2251.method_9630(class_2246.field_10119),
			true
		);
		MAPLE_DOOR = register(
			"maple_door",
			(settings) -> new class_2323(MAPLE_WOOD_SET, settings),
			class_4970.class_2251.method_9630(class_2246.field_10149),
			true
		);
		MAPLE_TRAPDOOR = register(
			"maple_trapdoor",
			(settings) -> new class_2533(MAPLE_WOOD_SET, settings),
			class_4970.class_2251.method_9630(class_2246.field_10137),
			true
		);
		MAPLE_FENCE = register(
			"maple_fence",
			class_2354::new,
			class_4970.class_2251.method_9630(class_2246.field_10620),
			true
		);
		MAPLE_FENCE_GATE = register(
			"maple_fence_gate",
			(settings) -> new class_2349(MAPLE_WOOD_TYPE, settings),
			class_4970.class_2251.method_9630(class_2246.field_10188),
			true
		);
		MAPLE_PRESSURE_PLATE = register(
			"maple_pressure_plate",
			(settings) -> new class_2440(MAPLE_WOOD_SET, settings),
			class_4970.class_2251.method_9630(class_2246.field_10484),
			true
		);
		MAPLE_SIGN = register(
			"maple_sign",
			MapleSignBlock::new,
			class_4970.class_2251.method_9630(class_2246.field_10121),
			false
		);
		MAPLE_WALL_SIGN = register(
			"maple_wall_sign",
			MapleWallSignBlock::new,
			class_4970.class_2251.method_9630(class_2246.field_10187),
			false
		);
		MAPLE_HANGING_SIGN = register(
			"maple_hanging_sign",
			MapleHangingSignBlock::new,
			class_4970.class_2251.method_9630(class_2246.field_40262),
			false
		);
		MAPLE_WALL_HANGING_SIGN = register(
			"maple_hanging_wall_sign",
			MapleWallHangingSignBlock::new,
			class_4970.class_2251.method_9630(class_2246.field_40272),
			false
		);

		MAPLE = class_5793.method_33468(MAPLE_PLANKS)
			.method_33482(MAPLE_BUTTON)
			.method_33489(MAPLE_DOOR)
			.method_33490(MAPLE_FENCE)
			.method_33491(MAPLE_FENCE_GATE)
			.method_33494(MAPLE_PRESSURE_PLATE)
			.method_33496(MAPLE_TRAPDOOR)
			.method_33492(MAPLE_SLAB)
			.method_33493(MAPLE_STAIRS)
			.method_33483(MAPLE_SIGN, MAPLE_WALL_SIGN)
			.method_33484("wooden")
			.method_33487("has_planks")
			.method_33481();

		MAPLE_BLOCKS = new class_2248[] {
			MAPLE_LOG, MAPLE_WOOD, STRIPPED_MAPLE_LOG, STRIPPED_MAPLE_WOOD, MAPLE_PLANKS, MAPLE_STAIRS,
			MAPLE_SLAB, MAPLE_FENCE, MAPLE_FENCE_GATE, MAPLE_DOOR, MAPLE_TRAPDOOR, MAPLE_PRESSURE_PLATE, MAPLE_BUTTON
		};

		StrippableBlockRegistry.register(CanadaBlocks.MAPLE_LOG, CanadaBlocks.STRIPPED_MAPLE_LOG);
		StrippableBlockRegistry.register(CanadaBlocks.MAPLE_WOOD, CanadaBlocks.STRIPPED_MAPLE_WOOD);

		FuelRegistryEvents.BUILD.register((builder, context) -> {
            int time = context.baseSmeltTime(); 
			for (var woodItem : new class_2248[] { MAPLE_LOG, MAPLE_WOOD, STRIPPED_MAPLE_LOG, STRIPPED_MAPLE_WOOD, MAPLE_PLANKS,
												MAPLE_TRAPDOOR, MAPLE_FENCE_GATE, MAPLE_FENCE }) {
				builder.method_61762(woodItem, time);
			}
			for (var woodItem : new class_2248[] { MAPLE_STAIRS, MAPLE_SLAB, MAPLE_PRESSURE_PLATE }) {
				builder.method_61762(woodItem, time / 2);
			}
			for (var woodItem : new class_2248[] { MAPLE_DOOR, MAPLE_SIGN, MAPLE_HANGING_SIGN }) {
				builder.method_61762(woodItem, time * 2 / 3);
			}
			builder.method_61762(MAPLE_BUTTON, time / 3);
        });

        MAPLE_SIGN_BLOCK_ENTITY = class_2378.method_10230(
            class_7923.field_41181,
            class_2960.method_60655(CanadaMod.MOD_ID, "maple_sign"),
			FabricBlockEntityTypeBuilder.<class_2625>create(MapleSignEntity::new, MAPLE_SIGN, MAPLE_WALL_SIGN).build());
		
		MAPLE_HANGING_SIGN_BLOCK_ENTITY = class_2378.method_10230(
            class_7923.field_41181,
            class_2960.method_60655(CanadaMod.MOD_ID, "maple_hanging_sign"),
			FabricBlockEntityTypeBuilder.<class_7717>create(MapleHangingSignBlockEntity::new, MAPLE_HANGING_SIGN, MAPLE_WALL_HANGING_SIGN).build());
	}

    private static class_2248 register(String name, Function<class_4970.class_2251, class_2248> blockFactory, class_4970.class_2251 settings, boolean shouldRegisterItem) {
		// Create a registry key for the block
		class_5321<class_2248> blockKey = keyOfBlock(name);
		// Create the block instance
		class_2248 block = blockFactory.apply(settings.method_63500(blockKey));

		// Sometimes, you may not want to register an item for the block.
		// Eg: if it's a technical block like `minecraft:moving_piston` or `minecraft:end_gateway`
		if (shouldRegisterItem) {
			// Items need to be registered with a different type of registry key, but the ID
			// can be the same.
			class_5321<class_1792> itemKey = keyOfItem(name);

			class_1747 blockItem = new class_1747(block, new class_1792.class_1793().method_63686(itemKey));
			class_2378.method_39197(class_7923.field_41178, itemKey, blockItem);
		}

		return class_2378.method_39197(class_7923.field_41175, blockKey, block);
	}

	private static class_5321<class_2248> keyOfBlock(String name) {
		return class_5321.method_29179(class_7924.field_41254, class_2960.method_60655(CanadaMod.MOD_ID, name));
	}

	private static class_5321<class_1792> keyOfItem(String name) {
		return class_5321.method_29179(class_7924.field_41197, class_2960.method_60655(CanadaMod.MOD_ID, name));
	}
}