package xen42.canadamod;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;

import com.google.common.collect.Maps;

import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_10124;
import net.minecraft.class_10128;
import net.minecraft.class_10132;
import net.minecraft.class_10191;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1741;
import net.minecraft.class_1747;
import net.minecraft.class_1749;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1822;
import net.minecraft.class_1827;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_4174;
import net.minecraft.class_4176;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_7707;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8051;
import net.minecraft.class_9331;
import xen42.canadamod.entities.MapleBoatEntity;
import xen42.canadamod.item.DispensibleSpawnEggItem;
import xen42.canadamod.item.DurabilityFoodItem;
import xen42.canadamod.item.ThermosContentsComponent;
import xen42.canadamod.item.ThermosItem;

public class CanadaItems {
    public static final class_1792 PELT = register("pelt", class_1792::new, new class_1792.class_1793());
    public static final class_1792 FLOUR = register("flour", class_1792::new, new class_1792.class_1793());
    public static final class_1792 CHEESE_CURD = register("cheese_curd", class_1792::new, new class_1792.class_1793()
        .method_19265(new class_4174.class_4175().method_19238(2).method_19237(0.1f).method_19242()));
    public static final class_1792 POUTINE = register("poutine", DurabilityFoodItem::new, new class_1792.class_1793().method_7894(class_1814.field_8907)
        .method_7889(1).method_7895(8).method_7896(class_1802.field_8428).method_62834(class_1802.field_8428)
        .method_19265(new class_4174.class_4175().method_19238(10).method_19237(2f).method_19242()));
    public static final class_1792 DONAIR = register("donair", class_1792::new, new class_1792.class_1793().method_7894(class_1814.field_8907)
        .method_19265(new class_4174.class_4175().method_19238(6).method_19237(2f).method_19242()));
    public static final class_1792 PIEROGI = register("pierogi", class_1792::new, new class_1792.class_1793().method_7894(class_1814.field_8907)
        .method_19265(new class_4174.class_4175().method_19238(6).method_19237(2f).method_19242()));

    public static final class_1792 BEAVER_SPAWN_EGG = register("beaver_spawn_egg", (settings) -> 
        new DispensibleSpawnEggItem(CanadaMod.BEAVER_ENTITY, settings), new class_1792.class_1793());

    public static final class_1792 MOOSE_SPAWN_EGG = register("moose_spawn_egg", (settings) -> 
        new DispensibleSpawnEggItem(CanadaMod.MOOSE_ENTITY, settings), new class_1792.class_1793());

    public static final class_1792 TREE_TAP = register("tree_tap", (settings) -> new class_1747(CanadaBlocks.TREE_TAP, settings), new class_1792.class_1793());
    public static final class_1792 MAPLE_SAPLING = register("maple_sapling", (settings) -> new class_1747(CanadaBlocks.MAPLE_SAPLING, settings), new class_1792.class_1793());

    public static final class_4174 MAPLE_SYRUP_FOOD = new class_4174.class_4175().method_19238(4).method_19237(1.4F).method_19240().method_19242();
    public static final class_10124 MAPLE_SYRUP_CONSUME = class_10128.method_62859().method_62852(2.0F)
        .method_62855(class_3417.field_20615).method_62854(new class_10132(List.of(
        new class_1293(class_1294.field_5917, 600, 1)
    ))).method_62851();

    public static final class_4174 SAP_FOOD = new class_4174.class_4175().method_19238(3).method_19237(0.1F).method_19240().method_19242();
    public static final class_10124 SAP_CONSUME = class_10128.method_62859().method_62852(2.0F)
        .method_62855(class_3417.field_20615).method_62854(new class_10132(List.of(
        new class_1293(class_1294.field_5909, 200, 1), 
        new class_1293(class_1294.field_5916, 200, 1)
    ))).method_62851();
    
    public static final class_4174 GRAVY_FOOD = new class_4174.class_4175().method_19238(4).method_19237(1.0F).method_19240().method_19242();
    public static final class_10124 GRAVY_CONSUME = class_10128.method_62859().method_62852(2.0F)
        .method_62855(class_3417.field_20615).method_62851();

    public static final class_1792 MAPLE_SYRUP_BOTTLE = register("maple_syrup_bottle", class_1792::new, new class_1792.class_1793()
        .method_7896(class_1802.field_8469).method_62833(MAPLE_SYRUP_FOOD, MAPLE_SYRUP_CONSUME)
        .method_62834(class_1802.field_8469).method_7889(1));


    public static final class_1792 MAPLE_SAP = register("maple_sap", class_1792::new, new class_1792.class_1793().method_19265(SAP_FOOD));
    public static final class_1792 SAP = register("sap", class_1792::new, new class_1792.class_1793().method_62833(SAP_FOOD, SAP_CONSUME));

    public static final class_1792 RUBBER = register("rubber", class_1792::new, new class_1792.class_1793());

    private static Map<class_8051, Integer> NO_DEFENSE_MAP = Maps.newEnumMap(Map.of(class_8051.field_41937, 0, class_8051.field_41936, 0, class_8051.field_41935, 0, class_8051.field_41934, 0, class_8051.field_48838, 0));
    public static final class_1741 NO_ARMOR = new class_1741(5, NO_DEFENSE_MAP, 15, class_3417.field_14581, 0.0F, 0.0F, class_3489.field_54059, class_10191.field_54134);

    public static final class_1792 MOOSE_HEAD = register("moose_head", (settings) -> {
        return new class_1827(CanadaBlocks.MOOSE_HEAD, CanadaBlocks.MOOSE_WALL_HEAD, class_2350.field_11033, settings);
    }, new class_1792.class_1793().method_66332(NO_ARMOR, class_8051.field_41934).method_7894(class_1814.field_8907));

    public static final class_1792 GRAVY = register("gravy", class_1792::new, new class_1792.class_1793()
        .method_7896(class_1802.field_8469).method_62833(GRAVY_FOOD, GRAVY_CONSUME)
        .method_62834(class_1802.field_8469).method_7889(1));

    public static final class_1792 VENISON = register("venison", class_1792::new, (new class_1792.class_1793()).method_19265(class_4176.field_18662));
    public static final class_1792 COOKED_VENISON = register("cooked_venison", class_1792::new, (new class_1792.class_1793()).method_19265(class_4176.field_18651));
    public static final class_1792 ANTLERS = register("antlers", class_1792::new, new class_1792.class_1793());

    public static final class_1792 MAPLE_BOAT = register("maple_boat", settings -> 
        new class_1749(MapleBoatEntity.MAPLE_BOAT, settings), (new class_1792.class_1793()).method_7889(1));
    public static final class_1792 MAPLE_CHEST_BOAT = register("maple_chest_boat", settings -> 
        new class_1749(MapleBoatEntity.MAPLE_CHEST_BOAT, settings), (new class_1792.class_1793()).method_7889(1));

    private static <T> class_9331<T> registerContentsComponent(String id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return class_2378.method_10226(class_7923.field_49658, id, builderOperator.apply(class_9331.method_57873()).method_57880());
    }
    public static final class_9331<ThermosContentsComponent> THERMOS_CONTENTS = registerContentsComponent("thermos_contents", (builder) -> {
        return builder.method_57881(ThermosContentsComponent.CODEC).method_57882(ThermosContentsComponent.PACKET_CODEC).method_59871();
    });
    public static final class_1792 THERMOS = register("thermos",
        settings -> new ThermosItem(settings), (new class_1792.class_1793()).method_7889(1).method_57349(THERMOS_CONTENTS, ThermosContentsComponent.DEFAULT));

    public static final class_1792 BEAVER_HELMET = register("beaver_helmet", class_1792::new, 
        new class_1792.class_1793().method_66332(NO_ARMOR, class_8051.field_41934).method_7894(class_1814.field_8907));
    public static final class_1792 MOOSE_HELMET = register("moose_helmet", class_1792::new, 
        new class_1792.class_1793().method_66332(NO_ARMOR, class_8051.field_41934).method_7894(class_1814.field_8907));

    public static class_1792 MAPLE_HANGING_SIGN_ITEM, MAPLE_SIGN_ITEM;

    public static class_1792 register(String name, Function<class_1792.class_1793, class_1792> itemFactory, class_1792.class_1793 settings) {
		// Create the item key.
		class_5321<class_1792> itemKey = class_5321.method_29179(class_7924.field_41197, class_2960.method_60655(CanadaMod.MOD_ID, name));

		// Create the item instance.
		class_1792 item = itemFactory.apply(settings.method_63686(itemKey));

		// Register the item.
		class_2378.method_39197(class_7923.field_41178, itemKey, item);

		return item;
	}

    public static void initialize() {
        MAPLE_HANGING_SIGN_ITEM = register("maple_hanging_sign", settings -> 
            new class_7707(CanadaBlocks.MAPLE_HANGING_SIGN, CanadaBlocks.MAPLE_WALL_HANGING_SIGN, settings),
            new class_1792.class_1793().method_7889(16));
        
        MAPLE_SIGN_ITEM = register("maple_sign", settings -> 
            new class_1822(CanadaBlocks.MAPLE_SIGN, CanadaBlocks.MAPLE_WALL_SIGN, settings),
            new class_1792.class_1793().method_7889(16));

        // Add custom items to groups
        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41062).register((itemGroup) -> { 
            itemGroup.method_45421(PELT);
            itemGroup.method_45421(ANTLERS);
            itemGroup.method_45421(FLOUR);
            itemGroup.method_45421(SAP);
            itemGroup.method_45421(MAPLE_SAP);
            itemGroup.method_45421(RUBBER);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40195).register((itemGroup) -> { 
            for (var block : CanadaBlocks.MAPLE_BLOCKS) {
                itemGroup.method_45421(block.method_8389());
            }
            itemGroup.method_45421(CanadaBlocks.RUBBER_BLOCK);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40743).register((itemGroup) -> { 
            itemGroup.method_45421(CanadaBlocks.MAPLE_LEAVES.method_8389());
            itemGroup.method_45421(CanadaBlocks.MAPLE_SAPLING.method_8389());
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40197).register((itemGroup) -> { 
            itemGroup.method_45421(MAPLE_SIGN_ITEM);
            itemGroup.method_45421(MAPLE_HANGING_SIGN_ITEM);
            itemGroup.method_45421(TREE_TAP);
            itemGroup.method_45421(CanadaBlocks.COOKING_POT.method_8389());
            itemGroup.method_45421(MOOSE_HEAD);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41060).register((itemGroup) -> { 
            itemGroup.method_45421(MAPLE_BOAT);
            itemGroup.method_45421(MAPLE_CHEST_BOAT);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_41061).register((itemGroup) -> { 
            itemGroup.method_45421(MAPLE_SYRUP_BOTTLE);
            itemGroup.method_45421(GRAVY);
            itemGroup.method_45421(CHEESE_CURD);
            itemGroup.method_45421(POUTINE);
            itemGroup.method_45421(DONAIR);
            itemGroup.method_45421(PIEROGI);
            itemGroup.method_45421(VENISON);
            itemGroup.method_45421(COOKED_VENISON);
            itemGroup.method_45421(THERMOS);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40205).register((itemGroup) -> {
            itemGroup.method_45421(BEAVER_SPAWN_EGG);
            itemGroup.method_45421(MOOSE_SPAWN_EGG);
        });

        ItemGroupEvents.modifyEntriesEvent(class_7706.field_40202).register((itemGroup) -> {
            itemGroup.method_45421(BEAVER_HELMET);
            itemGroup.method_45421(MOOSE_HELMET);
        });
    }
}
