package xen42.canadamod;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.minecraft.class_10295;
import net.minecraft.class_10355;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1322.class_1323;
import net.minecraft.class_1865;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2591;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3481;
import net.minecraft.class_3730;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5434;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7151;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9169;
import xen42.canadamod.block.CookingPotBlockEntity;
import xen42.canadamod.block.MooseSkullBlockEntity;
import xen42.canadamod.entities.BeaverChopTreeEffectPayload;
import xen42.canadamod.entities.BeaverEntity;
import xen42.canadamod.entities.MapleBoatEntity;
import xen42.canadamod.entities.MooseEntity;
import xen42.canadamod.recipe.CookingPotRecipe;
import xen42.canadamod.recipe.CookingPotRecipeDisplay;
import xen42.canadamod.screen.CookingPotScreenHandler;
import xen42.canadamod.world.CanadaConfiguredFeatures;
import xen42.canadamod.world.CanadaPlacedFeatures;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanadaMod implements ModInitializer {
	public static final String MOD_ID = "canadamod";

	public static final class_5321<class_1959> MAPLE_BIOME_KEY = class_5321.method_29179(class_7924.field_41236, class_2960.method_60655(CanadaMod.MOD_ID, "maple_forest"));

	public static final class_5321<class_3956<?>> COOKING_POT_RECIPE_TYPE_KEY = class_5321.method_29179(class_7924.field_41217, class_2960.method_60655(MOD_ID, "cooking_pot"));
	public static final class_3956<CookingPotRecipe> COOKING_POT_RECIPE_TYPE = class_2378.method_10230(class_7923.field_41188, class_2960.method_60655(MOD_ID, "cooking_pot"), new class_3956<CookingPotRecipe>() {
		public String toString() {
			return "cooking_pot";
		}
	});
	public static final class_1865<CookingPotRecipe> COOKING_POT_RECIPE_SERIALIZER = class_2378.method_10230(class_7923.field_41189, class_2960.method_60655(MOD_ID, "cooking_pot"), new CookingPotRecipe.Serializer());
	public static final class_10295.class_10296<CookingPotRecipeDisplay> COOKING_POT_RECIPE_DISPLAY = class_2378.method_10230(class_7923.field_54874, class_2960.method_60655(MOD_ID, "cooking_pot"), CookingPotRecipeDisplay.SERIALIZER);
	public static final class_10355 COOKING_POT_RECIPE_BOOK_CATEGORY = class_2378.method_10230(class_7923.field_54927, 
		class_2960.method_60655(MOD_ID, "cooking_pot"), new class_10355() {
		public String toString() {
			return "COOKING_POT";
		}
	});

	public static final class_3917<CookingPotScreenHandler> COOKING_POT_SCREEN_HANDLER_TYPE = class_2378.method_10230(
		class_7923.field_41187,
		class_2960.method_60655(MOD_ID, "cooking_pot"),
		new class_3917<CookingPotScreenHandler>(CookingPotScreenHandler::new, null));

	public static final class_2591<CookingPotBlockEntity> COOKING_POT_ENTITY = registerBlockEntityType(
		"cooking_pot_entity",
		FabricBlockEntityTypeBuilder.create(CookingPotBlockEntity::new, 
			new class_2248[] { CanadaBlocks.COOKING_POT }).build()
	);
	public static final class_2591<MooseSkullBlockEntity> MOOSE_HEAD_ENTITY = registerBlockEntityType(
		"moose_head_entity",
		FabricBlockEntityTypeBuilder.create(MooseSkullBlockEntity::new, 
			new class_2248[] { CanadaBlocks.MOOSE_HEAD, CanadaBlocks.MOOSE_WALL_HEAD }).build()
	);
	public static <T extends class_2591<?>> T registerBlockEntityType(String path, T blockEntityType) {
		return class_2378.method_10230(class_7923.field_41181, class_2960.method_60655(CanadaMod.MOD_ID, path), blockEntityType);
	}

	public static final class_5321<class_1299<?>> BEAVER_ENTITY_KEY = class_5321.method_29179(class_7924.field_41266, class_2960.method_60655(MOD_ID,"beaver"));
	public static final class_1299<BeaverEntity> BEAVER_ENTITY = class_2378.method_10230(
		class_7923.field_41177, 
		class_2960.method_60655(MOD_ID, "beaver"), 
		class_1299.class_1300.method_5903(BeaverEntity::new, class_1311.field_6294).method_17687(0.5f, 0.5f).method_5905(BEAVER_ENTITY_KEY));

	public static final class_5321<class_1299<?>> MOOSE_ENTITY_KEY = class_5321.method_29179(class_7924.field_41266, class_2960.method_60655(MOD_ID,"moose"));
	public static final class_1299<MooseEntity> MOOSE_ENTITY = class_2378.method_10230(
		class_7923.field_41177, 
		class_2960.method_60655(MOD_ID, "moose"), 
		class_1299.class_1300.method_5903(MooseEntity::new, class_1311.field_6294).method_17687(1.75f, 2.5f).method_5905(MOOSE_ENTITY_KEY));

	private static class_6880<class_1291> registerStatusEffect(String id, class_1291 statusEffect) {
		return class_2378.method_47985(class_7923.field_41174, class_2960.method_60655(MOD_ID, id), statusEffect);
	}
	public static class_6880<class_1291> BEAVER_EFFECT;
	public static class_6880<class_1291> MOOSE_EFFECT;

	public static final class_5321<class_3195> MAPLE_CABIN_KEY = class_5321.method_29179(class_7924.field_41246, class_2960.method_60655(MOD_ID, "maple_cabin"));
	public static final class_7151<class_5434> MAPLE_CABIN_TYPE_KEY = class_2378.method_10230(class_7923.field_41147, class_2960.method_60655(MOD_ID, "maple_cabin"),
		() -> class_5434.field_37794);

	// This logger is used to write text to the console and the log file.
	// It is considered best practice to use your mod id as the logger's name.
	// That way, it's clear which mod wrote info, warnings, and errors.
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	@Override
	public void onInitialize() {
		// This code runs as soon as Minecraft is in a mod-load-ready state.
		// However, some things (like resources) may still be uninitialized.
		// Proceed with mild caution.

		LOGGER.info("Loading Canada mod!");

		FabricDefaultAttributeRegistry.register(BEAVER_ENTITY, BeaverEntity.createBeaverAttributes());
		FabricDefaultAttributeRegistry.register(MOOSE_ENTITY, MooseEntity.createMooseAttributes());

		BEAVER_EFFECT = registerStatusEffect("beaver_effect",
			(new CustomStatusEffect(class_4081.field_18271, 10187841))
			.method_5566(class_5134.field_49076, class_2960.method_60655(MOD_ID, "effect.beaver_effect"), 3f, class_1323.field_6331)
			.method_5566(class_5134.field_51576, class_2960.method_60655(MOD_ID, "effect.beaver_effect"), 2f, class_1323.field_6331)
		);
		MOOSE_EFFECT = registerStatusEffect("moose_effect",
			(new CustomStatusEffect(class_4081.field_18271, 7079970))
			.method_5566(class_5134.field_23716, class_2960.method_60655(MOD_ID, "effect.moose_effect"), 6.0, class_1323.field_6328)
			.method_5566(class_5134.field_23718, class_2960.method_60655(MOD_ID, "effect.moose_effect"), 2f, class_1323.field_6331)
		);

		CanadaBlocks.initialize();
		CanadaConfiguredFeatures.onInitialize();
		CanadaItems.initialize();
		MapleBoatEntity.initialize();
		CanadaVillagers.initialize();
		CanadaPlacedFeatures.onInitialize();
		
		BiomeModifications.addFeature(context -> context.getBiomeKey().method_29177()
			.equals(class_2960.method_60655(CanadaMod.MOD_ID, "maple_forest")), class_2893.class_2895.field_13178, CanadaPlacedFeatures.MAPLE_FOREST_VEGETATION);

		class_1317.method_20637(BEAVER_ENTITY, class_9169.field_48745, class_2902.class_2903.field_13203, CanadaMod::canSpawn);
		class_1317.method_20637(MOOSE_ENTITY, class_9169.field_48745, class_2902.class_2903.field_13203, CanadaMod::canSpawn);

		var mooseBiomes = BiomeSelectors.includeByKey(MAPLE_BIOME_KEY)
			.or(BiomeSelectors.includeByKey(class_1972.field_9420))
			.or(BiomeSelectors.includeByKey(class_1972.field_35113))
			.or(BiomeSelectors.includeByKey(class_1972.field_35119))
			.or(BiomeSelectors.includeByKey(class_1972.field_9454));
		BiomeModifications.addSpawn(mooseBiomes, class_1311.field_6294, MOOSE_ENTITY, 60, 2, 2);

		var beaverBiomes = BiomeSelectors.includeByKey(MAPLE_BIOME_KEY)
			.or(BiomeSelectors.includeByKey(class_1972.field_9438))
			.or(BiomeSelectors.includeByKey(class_1972.field_9471));
		BiomeModifications.addSpawn(beaverBiomes, class_1311.field_6294, BEAVER_ENTITY, 100, 4, 4);

		PayloadTypeRegistry.playS2C().register(BeaverChopTreeEffectPayload.PAYLOAD_ID, BeaverChopTreeEffectPayload.CODEC);

		CanadaSounds.onInit();
	}

	private static boolean canSpawn(class_1299 type, class_5425 access, class_3730 reason, class_2338 pos, class_5819 random) {
		var ground = access.method_8320(pos.method_10074());
		var goodGround = ground.method_26164(class_3481.field_29822) || ground.method_27852(class_2246.field_10219) || ground.method_27852(class_2246.field_10520) || ground.method_27852(class_2246.field_10477);
		var goodLight = access.method_22339(pos) > 8;
		return goodGround && goodLight;
	}
}