package xen42.canadamod;

import java.util.function.Supplier;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.ArmorRenderer;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_10034;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_3929;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4719;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_554;
import net.minecraft.class_5601;
import net.minecraft.class_5607;
import net.minecraft.class_5616;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_7761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_837;
import net.minecraft.class_881;
import xen42.canadamod.armor.BeaverHatModel;
import xen42.canadamod.armor.MooseHatModel;
import xen42.canadamod.block.MooseSkullBlock;
import xen42.canadamod.entities.BeaverChopTreeEffectPayload;
import xen42.canadamod.entities.BeaverChopTreeGoal;
import xen42.canadamod.entities.BeaverEntity;
import xen42.canadamod.entities.MapleBoatEntity;
import xen42.canadamod.entity.BeaverEntityModel;
import xen42.canadamod.entity.BeaverEntityRenderer;
import xen42.canadamod.entity.MooseEntityModel;
import xen42.canadamod.entity.MooseEntityRenderer;
import xen42.canadamod.entity.MooseSkullBlockEntityRenderer;
import xen42.canadamod.screen.CookingPotHandledScreen;

public class CanadaModClient implements ClientModInitializer {
	public static final class_5601 MAPLE_BOAT = new class_5601(class_2960.method_60655(CanadaMod.MOD_ID, "boat/maple"), "main");
	public static final class_5601 MAPLE_CHEST_BOAT = new class_5601(class_2960.method_60655(CanadaMod.MOD_ID, "chest_boat/maple"), "main");
	public static final class_5601 MODEL_BEAVER_LAYER = new class_5601(class_2960.method_60655(CanadaMod.MOD_ID, "beaver"), "main");
	public static final class_5601 MODEL_MOOSE_LAYER = new class_5601(class_2960.method_60655(CanadaMod.MOD_ID, "moose"), "main");

	public class MapleBoat implements EntityModelLayerRegistry.TexturedModelDataProvider {
		@Override
		public class_5607 createModelData() {
			return class_554.method_31985();
		}
	}

	public class MapleChestBoat implements EntityModelLayerRegistry.TexturedModelDataProvider {
		@Override
		public class_5607 createModelData() {
			return class_554.method_62066();
		}
	}

	@Override
	public void onInitializeClient() {
		addCustomWoodTypeTexture(CanadaBlocks.MAPLE_WOOD_TYPE);

		BlockRenderLayerMap.INSTANCE.putBlock(CanadaBlocks.MAPLE_DOOR, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(CanadaBlocks.MAPLE_SAPLING, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(CanadaBlocks.POTTED_MAPLE_SAPLING, class_1921.method_23581());
		BlockRenderLayerMap.INSTANCE.putBlock(CanadaBlocks.TREE_TAP, class_1921.method_23581());

		EntityRendererRegistry.register(MapleBoatEntity.MAPLE_BOAT, context -> new class_881(context, MAPLE_BOAT));
		EntityRendererRegistry.register(MapleBoatEntity.MAPLE_CHEST_BOAT, context -> new class_881(context, MAPLE_CHEST_BOAT));
		EntityModelLayerRegistry.registerModelLayer(MAPLE_BOAT, new MapleBoat());
		EntityModelLayerRegistry.registerModelLayer(MAPLE_CHEST_BOAT, new MapleChestBoat());

		ParticleFactoryRegistry.getInstance().register(CanadaBlocks.MAPLE_LEAF_PARTICLE, MapleLeavesFactory::new);

		class_5616.method_32144(CanadaBlocks.MAPLE_SIGN_BLOCK_ENTITY, class_837::new);
		class_5616.method_32144(CanadaBlocks.MAPLE_HANGING_SIGN_BLOCK_ENTITY, class_7761::new);

		class_3929.method_17542(CanadaMod.COOKING_POT_SCREEN_HANDLER_TYPE, CookingPotHandledScreen::new);

		EntityRendererRegistry.register(CanadaMod.BEAVER_ENTITY, context -> new BeaverEntityRenderer(context));
		EntityModelLayerRegistry.registerModelLayer(MODEL_BEAVER_LAYER, BeaverEntityModel::getTexturedModelData);

		EntityRendererRegistry.register(CanadaMod.MOOSE_ENTITY, context -> new MooseEntityRenderer(context));
		EntityModelLayerRegistry.registerModelLayer(MODEL_MOOSE_LAYER, MooseEntityModel::getTexturedModelData);

		ArmorRenderer.register(new CustomArmorRenderer(BeaverHatModel::getModel), CanadaItems.BEAVER_HELMET);
		ArmorRenderer.register(new CustomArmorRenderer(MooseHatModel::getModel), CanadaItems.MOOSE_HELMET);
		ArmorRenderer.register(new BlockOnHeadArmorRenderer(CanadaBlocks.MOOSE_HEAD), CanadaItems.MOOSE_HEAD);

		class_5616.method_32144(CanadaMod.MOOSE_HEAD_ENTITY, MooseSkullBlockEntityRenderer::new);

		ClientPlayNetworking.registerGlobalReceiver(BeaverChopTreeEffectPayload.PAYLOAD_ID, (payload, context) -> {
			context.client().execute(() -> {
				// Animations and rendering all done on the client side, but Goal behaviours run on the server
				var beaver = (BeaverEntity)context.client().field_1687.method_8469(payload.id);
				if (beaver != null) {
					beaver.isChopping = payload.stage != -1;
				}
				context.client().field_1769.method_8569(payload.id, payload.pos, payload.stage);
				
				// Don't play sound when setting a guy to -1
				if (payload.stage > 0) {
					context.client().field_1687.method_45446(
						payload.pos, class_2498.field_11547.method_10596(), class_3419.field_15245, 1.0f, 1.0f, false
					);
				}
			});
		});
	}

	public void addCustomWoodTypeTexture(class_4719 type) {
		class_2960 textureId = class_2960.method_60655(CanadaMod.MOD_ID, "entity/signs/" + type.comp_1299());
		class_4730 spriteId = new class_4730(class_4722.field_21712.get(class_4719.field_21676).method_24144(), textureId);
		class_4722.field_21712.put(type, spriteId);

		class_2960 hangingTextureId = class_2960.method_60655(CanadaMod.MOD_ID, "entity/signs/hanging/" + type.comp_1299());
		class_4730 hangingSpriteId = new class_4730(class_4722.field_40515.get(class_4719.field_21676).method_24144(), hangingTextureId);
		class_4722.field_40515.put(type, hangingSpriteId);
	}

	private class CustomArmorRenderer implements ArmorRenderer {
		private Supplier<class_5607> model;

		public CustomArmorRenderer(Supplier<class_5607> model) {
			this.model = model;
		}

		@Override
		public void render(class_4587 matrices, class_4597 vertexConsumers, class_1799 stack,
				class_10034 bipedEntityRenderState, class_1304 slot, int light,
				class_572<class_10034> contextModel) {
			if (slot != class_1304.field_6169) {
				return;
			}

			var name = stack.method_7909().toString().split(":")[1];

			class_630 part = model.get().method_32109().method_32086("hat");
			part.method_17138(contextModel.method_2838());
			part.method_22698(matrices, vertexConsumers.getBuffer(class_1921.method_25448(class_2960.method_60655(CanadaMod.MOD_ID, "textures/armor/" + name + ".png"))),
				light, class_4608.field_21444);

			class_310.method_1551().method_1480().method_23178(stack, class_811.field_4316, light, class_4608.field_21444, matrices,
				vertexConsumers, class_310.method_1551().field_1687, 0);
		}
	}

	private class BlockOnHeadArmorRenderer implements ArmorRenderer {
		private class_2248 block;

		public BlockOnHeadArmorRenderer(class_2248 block) {
			this.block = block;
		}

		@Override
		public void render(class_4587 matrices, class_4597 vertexConsumers, class_1799 stack,
				class_10034 bipedEntityRenderState, class_1304 slot, int light,
				class_572<class_10034> contextModel) {
			if (slot != class_1304.field_6169) {
				return;
			}

			matrices.method_22903();

			var head = contextModel.method_2838();
			matrices.method_46416(head.field_3657 / 16.0f, head.field_3656 / 16.0f, head.field_3655 / 16.0f);
			matrices.method_22907(class_7833.field_40718.rotation(head.field_3674));
			matrices.method_22907(class_7833.field_40716.rotation(head.field_3675));
			matrices.method_22907(class_7833.field_40714.rotation(head.field_3654));
			matrices.method_46416(0.5f, -0.025f, -0.75f);
			matrices.method_22907(class_7833.field_40718.rotation((float)Math.PI));
			matrices.method_22905(1.05f, 1.05f, 1.05f);
			matrices.method_46416(-0.025f, -0.025f, -0.025f);

			var state = block.method_9564();
			if (state.method_27852(CanadaBlocks.MOOSE_HEAD)) {
				state = state.method_11657(MooseSkullBlock.WEIRD_HACK, false);
			}

			class_310.method_1551().method_1541().method_3353(state, matrices, vertexConsumers,
				light, class_4608.field_21444);

			matrices.method_22909();
		}
	}
}