package xen42.canadamod;

import com.google.common.collect.ImmutableSet;

import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.object.builder.v1.world.poi.PointOfInterestHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_21;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3852;
import net.minecraft.class_3853.class_1652;
import net.minecraft.class_3853.class_1654;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9306;
import net.minecraft.class_9428;

public class CanadaVillagers {
    public static final class_5321<class_4158> LUMBERJACK_POI_KEY = class_5321.method_29179(class_7924.field_41212, class_2960.method_60655(CanadaMod.MOD_ID, "lumberjack_poi"));
    public static final class_4158 LUMBERJACK_POI = registerNewPOI("lumberjack_poi", CanadaBlocks.TREE_TAP);

    public static final class_5321<class_3852> SUGAR_SHACK_VILLAGER_KEY = class_5321.method_29179(class_7924.field_41234, class_2960.method_60655(CanadaMod.MOD_ID, "sugar_shack"));
    public static final class_3852 SUGAR_SHACK_VILLAGER = registerNewProfession(SUGAR_SHACK_VILLAGER_KEY, LUMBERJACK_POI_KEY, class_3417.field_20670);

    public static class_3852 registerNewProfession(class_5321<class_3852> key, class_5321<class_4158> poi, class_3414 sound) {
        var profession = new class_3852(
                class_2561.method_43471("entity." + key.method_29177().method_12836() + ".villager." + key.method_29177().method_12832()),
                entry -> entry.method_40225(poi),
                entry -> entry.method_40225(poi),
                ImmutableSet.of(),
                ImmutableSet.of(),
                sound
            );
        return class_2378.method_10230(class_7923.field_41195, key.method_29177(), profession);
    }

    public static class_4158 registerNewPOI(String name, class_2248 block) {
        return PointOfInterestHelper.register(class_2960.method_60655(CanadaMod.MOD_ID, name), 1, 1, block);
    }

    private static class_1914 SellMap(class_1297 entity, class_5819 random, int price, class_6862<class_3195> structure, class_6880<class_9428> decoration, int maxUses, int experience) {
    	return new class_1654(price, structure, 
    		"filled_map." + structure.comp_327().method_12836() + "." + structure.comp_327().method_12832(),
    		decoration, maxUses, experience).method_7246(entity, random);
    }

    public static void initialize() {
        // CUSTOM VILLAGER
        TradeOfferHelper.registerVillagerOffers(SUGAR_SHACK_VILLAGER_KEY, 1, factories -> {
            factories.add((entity, random) -> new class_1914(
				new class_9306(CanadaItems.SAP, 4),
				new class_1799(class_1802.field_8687, 1), 16, 2, 0.05f));
            factories.add((entity, random) -> new class_1914(
				new class_9306(CanadaItems.MAPLE_SAP, 4),
				new class_1799(class_1802.field_8687, 2), 16, 2, 0.05f));
		});

        TradeOfferHelper.registerVillagerOffers(SUGAR_SHACK_VILLAGER_KEY, 2, factories -> {
            factories.add((entity, random) -> new class_1914(
				new class_9306(CanadaItems.PELT, 9),
				new class_1799(class_1802.field_8687, 1), 12, 5, 0.05f));
            factories.add((entity, random) -> new class_1914(
				new class_9306(class_1802.field_8687, 2),
				new class_1799(CanadaItems.MAPLE_SAPLING, 4), 12, 5, 0.05f));
		});

        TradeOfferHelper.registerVillagerOffers(SUGAR_SHACK_VILLAGER_KEY, 3, factories -> {
            factories.add((entity, random) -> new class_1914(
				new class_9306(CanadaItems.ANTLERS, 4),
				new class_1799(class_1802.field_8687, 1), 12, 5, 0.05f));
            factories.add((entity, random) -> new class_1914(
                new class_9306(class_1802.field_8687, 2),
                new class_1799(CanadaItems.CHEESE_CURD, 3), 12, 5, 0.05f));
		});

        TradeOfferHelper.registerVillagerOffers(SUGAR_SHACK_VILLAGER_KEY, 4, factories -> {
            factories.add((entity, random) -> new class_1914(
                new class_9306(class_1802.field_8687, 3),
                new class_1799(CanadaItems.MAPLE_SYRUP_BOTTLE, 1), 12, 5, 0.05f));
            factories.add((entity, random) -> new class_1914(
                new class_9306(class_1802.field_8687, 3),
                new class_1799(CanadaItems.POUTINE, 1), 12, 5, 0.05f));
		});

        TradeOfferHelper.registerVillagerOffers(SUGAR_SHACK_VILLAGER_KEY, 5, factories -> {
            factories.add((entity, random) -> new class_1914(
                new class_9306(class_1802.field_8687, 12),
                new class_1799(CanadaItems.MOOSE_HELMET, 1), 12, 5, 0.05f));
            factories.add((entity, random) -> new class_1914(
                new class_9306(class_1802.field_8687, 12),
                new class_1799(CanadaItems.BEAVER_HELMET, 1), 12, 5, 0.05f));
		});

		TradeOfferHelper.registerWanderingTraderOffers(builder -> {
			builder.addOffersToPool(
				TradeOfferHelper.WanderingTraderOffersBuilder.SELL_SPECIAL_ITEMS_POOL, 
				new TradeOfferFactory(new class_1914(
					new class_9306(class_1802.field_8687, 2),
					new class_1799(CanadaItems.MAPLE_SAPLING, 1), 12, 20, 0.05f)
				),
                new TradeOfferFactory(new class_1914(
					new class_9306(class_1802.field_8687, 4),
					new class_1799(CanadaItems.MOOSE_HEAD, 1), 12, 20, 0.05f)
				)
			);
		});

        TradeOfferHelper.registerVillagerOffers(class_3852.field_17054, 3, factories -> {
			// Map to sugar shack
			factories.add((entity, random) -> SellMap(entity, random, 10,
				CanadaTags.StructureTags.MAPLE_CABIN, class_21.field_84, 4, 15));
		});
    }

    private static class TradeOfferFactory implements class_1652 {
		private class_1914 _tradeOffer;

		public TradeOfferFactory(class_1914 tradeOffer) {
			_tradeOffer = tradeOffer;
		}

		@Override
		public class_1914 method_7246(class_1297 arg0, class_5819 arg1) {
			return _tradeOffer.method_53881();
		}
	}
}
