package xen42.canadamod.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import xen42.canadamod.CanadaMod;

public class CookingPotBlock extends class_2237 {

    public CookingPotBlock(class_2251 settings) {
        super(settings);
        method_9590((this.field_10647.method_11664()).method_11657(LIT, false));
    }

    public static final class_2746 LIT = class_2741.field_12548;
    public static final class_2754<class_2350> FACING = class_2383.field_11177;
    public static final MapCodec<CookingPotBlock> field_46280 = method_54094(CookingPotBlock::new);
    
    @Override
    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[] { FACING, LIT });
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return method_9564().method_11657(FACING, ctx.method_8042().method_10153());
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (!state.method_11654(LIT))
            return;  
        
        var x = pos.method_10263() + 0.5f;
        var y = pos.method_10264();
        var z = pos.method_10260() + 0.5f;
        if (random.method_43058() < 0.1f) {
            world.method_8486(x, y, z, class_3417.field_15006, class_3419.field_15245, 1.0f, 1.0f, false);
        }

        var direction = state.method_11654(FACING);
        var axis = direction.method_10166();

        double g = 0.52D;
        double h = random.method_43058() * 0.6D - 0.3D;
        double i = (axis == class_2350.class_2351.field_11048) ? (direction.method_10148() * 0.52D) : h;
        double j = random.method_43058() * 6.0D / 16.0D;
        double k = (axis == class_2350.class_2351.field_11051) ? (direction.method_10165() * 0.52D) : h;

        world.method_8406(class_2398.field_11251, x + i, y + j, z + k, 0.0D, 0.0D, 0.0D);
        world.method_8406(class_2398.field_11240, x + i, y + j, z + k, 0.0D, 0.0D, 0.0D);

        if (random.method_43048(2) == 0) {
            for (int ii = 0; ii < random.method_43048(1) + 2; ii++) {
                world.method_8406(class_2398.field_11251, x + random.method_43057() / 2f, y + 1f, z + random.method_43057() / 2f, 0, 0.005f, 0);
            }
        }

        if (random.method_43048(20) == 0) {
            world.method_8406(class_2398.field_17430, x, y + 1f, z, 0, 0.025f, 0);
        }
    }

    @Override
    public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236) {
            openScreen(world, pos, player);
        }
        return class_1269.field_5812;
    }
    
    public class_2561 getTitle() {
        return class_2561.method_43471(method_63499());
    }

    public void openScreen(class_1937 world, class_2338 pos, class_1657 player) {
        var blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CookingPotBlockEntity) {
            player.method_17355((class_3908)blockEntity);
        }
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CookingPotBlockEntity(pos, state);
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return field_46280;
    }

    @Override
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return validateTicker(world, type, CanadaMod.COOKING_POT_ENTITY);
    }

    protected static <T extends class_2586> class_5558<T> validateTicker(class_1937 world, class_2591<T> givenType, class_2591<? extends CookingPotBlockEntity> expectedType) {
        if (world instanceof class_3218 serverWorld) {
            return method_31618(givenType, expectedType, (__, pos, state, blockEntity) -> CookingPotBlockEntity.tick(serverWorld, pos, state, blockEntity));
        }
        else {
            return null;
        }
    }
}
