package xen42.canadamod.block;

import net.minecraft.class_1262;
import net.minecraft.class_1278;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1737;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3919;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9875;
import xen42.canadamod.CanadaMod;
import xen42.canadamod.recipe.CookingPotRecipe;
import xen42.canadamod.recipe.CookingPotRecipeInput;
import xen42.canadamod.screen.CookingPotScreenHandler;

public class CookingPotBlockEntity extends class_2624 implements class_1737, class_1278 {
    protected class_2371<class_1799> inventory;
    private class_2680 _blockState;

    public int cookTimeRemaining;
    public int cookTimeTotal;

    public int burnTimeRemaining;
    public int burnTimeTotal;

    public  class_5321<class_1860<?>> currentRecipeID;

    private final class_1863.class_7266<CookingPotRecipeInput, ? extends CookingPotRecipe> matchGetter;

    protected final class_3913 propertyDelegate;

    public CookingPotBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(CanadaMod.COOKING_POT_ENTITY, blockPos, blockState);
        this.propertyDelegate = new class_3919(4);

        this.inventory = class_2371.method_10213(8, class_1799.field_8037);
        _blockState = blockState;
        this.matchGetter = class_1863.method_42302(CanadaMod.COOKING_POT_RECIPE_TYPE);
    }

    private CookingPotScreenHandler _handler;

    public boolean isCooking() {
        return cookTimeRemaining > 0;
    }

    public boolean hasFuel() {
        return burnTimeRemaining > 0;
    }

    @Override
    public int method_5439() {
        return 8;
    }

    @Override
    protected class_1703 method_5465(int syncId, class_1661 playerInventory) {
        _handler = new CookingPotScreenHandler(syncId, playerInventory, class_3914.field_17304, this, this.propertyDelegate);
        return _handler;
    }

    @Override
    protected class_2561 method_17823() {
        return ((CookingPotBlock)(this._blockState.method_26204())).getTitle();
    }

    @Override
    protected class_2371<class_1799> method_11282() {
        return this.inventory;
    }

    @Override
    protected void method_11281(class_2371<class_1799> inventory) {
        this.inventory = inventory;
    }

    @Override
    public boolean method_61176(class_2680 state) {
        return CanadaMod.COOKING_POT_ENTITY.method_20526(state);
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        this.inventory = class_2371.method_10213(method_5439(), class_1799.field_8037);
        class_1262.method_5429(nbt, this.inventory, registries);
        this.cookTimeRemaining = nbt.method_10568("cookTimeRemaining").orElse((short)0);
        this.cookTimeTotal = nbt.method_10568("cookTimeTotal").orElse((short)0);
        this.burnTimeRemaining = nbt.method_10568("burnTimeRemaining").orElse((short)0);
        this.burnTimeTotal = nbt.method_10568("burnTimeTotal").orElse((short)0);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        this.inventory.set(slot, stack);
        method_5431();
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registries) { 
        super.method_11007(nbt, registries);
        class_1262.method_5426(nbt, this.inventory, registries);
        nbt.method_10575("cookTimeRemaining", (short)this.cookTimeRemaining);
        nbt.method_10575("cookTimeTotal", (short)this.cookTimeTotal);
        nbt.method_10575("burnTimeRemaining", (short)this.burnTimeRemaining);
        nbt.method_10575("burnTimeTotal", (short)this.burnTimeTotal);
    }

    public static void tick(class_3218 world, class_2338 pos, class_2680 state, CookingPotBlockEntity blockEntity) {
        var wasBurning = blockEntity.isCooking();

        // Todo: only check this when the inventory actually changed
        var inputRecipe = getRecipeFromInputs(blockEntity, world);
        var activeRecipe = getCurrentRecipe(blockEntity, world);
        var currentOutput = blockEntity.method_5438(CookingPotScreenHandler.OUTPUT_SLOT);
        var currentRecipeResult = inputRecipe == null ? class_1799.field_8037 : inputRecipe.comp_1933().result;

        var canAcceptOutput = blockEntity.canAcceptOutput(currentOutput, currentRecipeResult);

        if (currentRecipeResult == class_1799.field_8037) {
            blockEntity.cookTimeRemaining = 0;
            blockEntity.cookTimeTotal = 0;
        }

        // Only progress or use fuel if we actually can create an output
        if (canAcceptOutput && currentRecipeResult != class_1799.field_8037) {
            var fuelStack = blockEntity.method_5438(CookingPotScreenHandler.FUEL_SLOT);
            if (!blockEntity.hasFuel() && !fuelStack.method_7960()) {
                blockEntity.burnTimeRemaining = world.method_61269().method_61755(fuelStack);
                blockEntity.burnTimeTotal = blockEntity.burnTimeRemaining;
                if (fuelStack.getRecipeRemainder().method_7960()) {
                    fuelStack.method_7934(1);
                }
                else {
                    blockEntity.inventory.set(CookingPotScreenHandler.FUEL_SLOT, fuelStack.getRecipeRemainder());
                }
            }

            if (blockEntity.isCooking() && blockEntity.hasFuel()) {
                blockEntity.cookTimeRemaining--;
                blockEntity.burnTimeRemaining-=5;
            }
        }

        var didUpdate = false;

        // Just finished crafting
        if (wasBurning && !blockEntity.isCooking()) {
            didUpdate = craftRecipe(blockEntity, world);
        }

        var shouldBeCooking = inputRecipe != null;
        var isCooking = blockEntity.isCooking() && activeRecipe == inputRecipe;

        if (shouldBeCooking && !isCooking) {
            // Debug: 2 seconds to craft
            blockEntity.cookTimeRemaining = 40;
            blockEntity.cookTimeTotal = 40;
            setCurrentRecipe(inputRecipe, blockEntity, world);
        }
        else if (!shouldBeCooking && isCooking) {
            blockEntity.cookTimeRemaining = 0;
            setCurrentRecipe(null, blockEntity, world);
        }

        var isLit = state.method_11654(CookingPotBlock.LIT);
        var shouldBeLit = blockEntity.isCooking() && blockEntity.hasFuel() && canAcceptOutput;
        if (isLit != shouldBeLit) {
            world.method_8501(pos, state.method_11657(CookingPotBlock.LIT, shouldBeLit));
            didUpdate = true;
        }

        if (didUpdate) {
            method_31663(world, pos, state);
        }

        blockEntity.propertyDelegate.method_17391(0, blockEntity.burnTimeRemaining);
        blockEntity.propertyDelegate.method_17391(1, blockEntity.burnTimeTotal);
        blockEntity.propertyDelegate.method_17391(2, blockEntity.cookTimeRemaining);
        blockEntity.propertyDelegate.method_17391(3, blockEntity.cookTimeTotal);
    }

    @SuppressWarnings("unchecked")
    private static class_8786<CookingPotRecipe> getRecipeFromInputs(CookingPotBlockEntity blockEntity, class_3218 world) {
        var input = new CookingPotRecipeInput(blockEntity.inventory);
        var recipeEntry = blockEntity.matchGetter.method_42303(input, world).orElse(null);
        return (class_8786<CookingPotRecipe>)recipeEntry;
    }

    private static void setCurrentRecipe(class_8786<CookingPotRecipe> recipe, CookingPotBlockEntity blockEntity, class_3218 world) {
        blockEntity.currentRecipeID = recipe == null ? null : recipe.comp_1932();
    }

    @SuppressWarnings("unchecked")
    private static class_8786<CookingPotRecipe> getCurrentRecipe(CookingPotBlockEntity blockEntity, class_3218 world) {
        var recipe = world.method_64577().method_8130(blockEntity.currentRecipeID).orElse(null);
        if (recipe == null) {
            return null;
        }
        else {
            return (class_8786<CookingPotRecipe>)recipe;
        }
    }

    private boolean canAcceptOutput(class_1799 currentOutput, class_1799 resultItem) {
        return currentOutput.method_7960() || 
                (currentOutput.method_31574(resultItem.method_7909()) && currentOutput.method_7914() > currentOutput.method_7947() + resultItem.method_7947());
    }

    /// Called when crafting bar time is up
    private static boolean craftRecipe(CookingPotBlockEntity blockEntity, class_3218 world) {
        var recipeEntry = getRecipeFromInputs(blockEntity, world);
        if (recipeEntry == null) {
            return false;
        }
        var recipe = recipeEntry.comp_1933();

        if (recipe != null) {
            var resultItem = recipe.result;

            var currentOutput = blockEntity.method_5438(CookingPotScreenHandler.OUTPUT_SLOT);

            if (blockEntity.canAcceptOutput(currentOutput, resultItem)) {
                var finalResult = resultItem.method_7972();
                if (!currentOutput.method_7960()) {
                    finalResult = new class_1799(finalResult.method_7909(), finalResult.method_7947() + currentOutput.method_7947());
                }

                blockEntity.method_5447(CookingPotScreenHandler.OUTPUT_SLOT, finalResult);
                for (var slotIndex : new int[] { 2, 3, 4, 5, 6 }) {
                    var slot = blockEntity.inventory.get(slotIndex);

                    if (!slot.method_7960()) {
                        if (slot.getRecipeRemainder().method_7960()) {
                            slot.method_7934(1);
                        }
                        else {
                            blockEntity.inventory.set(slotIndex, slot.getRecipeRemainder());
                        }
                    }
                }

                setCurrentRecipe(null, blockEntity, world);

                return true;
            }
        }
        return false;
    }

    @Override
    public void method_7683(class_9875 finder) {
        for (class_1799 itemStack : this.inventory) {
            finder.method_61541(itemStack); 
        }
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return (slot == CookingPotScreenHandler.OUTPUT_SLOT) || stack.method_31574(class_1802.field_8550);
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        if (CookingPotScreenHandler.isContainer(stack)) {
            return slot == CookingPotScreenHandler.CONTAINER_SLOT;
        }
        else if (field_11863.method_61269().method_61752(stack)) {
            return slot == CookingPotScreenHandler.FUEL_SLOT;
        }

        return false;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        if (side == class_2350.field_11033) {
            return new int[] { CookingPotScreenHandler.OUTPUT_SLOT, 3, 4, 5, 6 };
        }
        else {
            return new int[] { CookingPotScreenHandler.CONTAINER_SLOT, CookingPotScreenHandler.FUEL_SLOT };
        }
    }
}
