package xen42.canadamod.entities;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_11;
import net.minecraft.class_1352;
import net.minecraft.class_1747;
import net.minecraft.class_1928;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2397;
import net.minecraft.class_2473;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import org.jetbrains.annotations.Nullable;
import xen42.canadamod.CanadaBlocks;
import xen42.canadamod.CanadaMod;

public class BeaverChopTreeGoal extends class_1352 {
    public static Map<class_2397, class_2473> saplingMap = new HashMap();

    private final BeaverEntity beaver;

    @Nullable
    private class_11 pathToTrunk;

    @Nullable
    private class_2473 sapling;

    private boolean isChoppingTree;

    private final int MAX_BREAKING_TICKS = 40;
    private int choppingTicks = 0;

    public BeaverChopTreeGoal(BeaverEntity beaver) {
        this.beaver = beaver;
    }

    public boolean method_6264() {
        if (!beaver.canChopTree()) {
            return false;
        }

        if (!(beaver.method_37908() instanceof class_3218 serverWorld) || !serverWorld.method_64395().method_8355(class_1928.field_19388)) {
            return false;
        }

        if (!this.beaver.isFrenzied() && this.beaver.method_59922().method_43048(method_38848(20)) != 0) {
            return false;
        }

        this.beaver.setChoppingTree(findChoppableTree(5));
        if (this.beaver.getChoppingTreePos() == null) {
            return false;
        }

        pathToTrunk = beaver.method_5942().method_6352(this.beaver.getChoppingTreePos().method_10263(), this.beaver.getChoppingTreePos().method_10264(),
            this.beaver.getChoppingTreePos().method_10260(), 0);
        if (pathToTrunk == null) {
            return false;
        }

        return true;
    }

    @Override
    public boolean method_6266() {
        if (isChoppingTree) return true;

        if (this.beaver.getChoppingTreePos() == null) return false;

        return !this.beaver.method_5942().method_6357() || this.beaver.method_37908().method_8320(this.beaver.getChoppingTreePos()).method_26215();
    }

    @Override
    public void method_6269() {
        this.beaver.method_5942().method_6334(this.pathToTrunk, 1f);
    }

    @Override
    public void method_6270() {
        // In case somebody else broke it
        this.beaver.stopChopping();
        this.sapling = null;
    }

    private class_2338 findChoppableTree(int radius) {
        for (var dx = -radius; dx <= radius; dx++) {
            for (var dz = -radius; dz <= radius; dz++) {
                for (var dy = -1; dy <= 1; dy++) {
                    var trunkPos = beaver.method_24515().method_10069(dx, dy, dz);

                    if (isTreeTrunk(trunkPos)) {
                        return trunkPos;
                    }
                }
            }
        }
        return null;
    }

    private boolean isTreeTrunk(class_2338 pos) {
        var world = beaver.method_37908();
        var trunk = world.method_8320(pos);
        this.sapling = null;

        // If its a log with dirt under it, it may be the start of a tree!
        // From this we move up to make sure it has leaves on the top, else we might be breaking somebody's house
        var dirt = world.method_8320(pos.method_10074());
        if (trunk.method_26164(class_3481.field_15475) && (dirt.method_26164(class_3481.field_29822) || dirt.method_27852(class_2246.field_10219) || dirt.method_27852(class_2246.field_10520))) {
            // Move up to find leaves
            for (int i = 0; i < 8; i++) {
                var topBlockPos = pos.method_10069(0, i, 0);
                var topBlock = world.method_8320(topBlockPos);
                // TODO: also check for tree taps near the base
                if (!noLogsNextToBlock(topBlockPos)) {
                    return false;
                }
                if (isNaturalLeaf(topBlock)) {
                    this.sapling = getSaplingFromLeaf(topBlockPos);
                    return true;
                }
                // Make sure it is a continuous tree
                else if (!topBlock.method_26164(class_3481.field_15475)) {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean isNaturalLeaf(class_2680 state) {
        return state.method_26164(class_3481.field_15503) && state.method_28498(class_2741.field_12514) && !state.method_11654(class_2741.field_12514);
    }

    @Nullable
    private class_2473 getSaplingFromLeaf(class_2338 pos) {
        var blockState = beaver.method_37908().method_8320(pos);
        var leafBlock = (class_2397)blockState.method_26204();

        if (leafBlock == null) {
            return null;
        }

        if (saplingMap.containsKey(leafBlock)) {
            return saplingMap.get(leafBlock);
        }
        else {
            // This is straight goofy ok we need to simulate like 40 leaf drops to PROBABLY get a sapling but even then
            for (int i = 0; i < 60; i++) {
                for (var item : class_2248.method_9562(blockState, (class_3218)beaver.method_37908(), pos, null)) {
                    if (item.method_7909() instanceof class_1747 blockItem && blockItem.method_7711() instanceof class_2473 sapling) {
                        saplingMap.put(leafBlock, sapling);
                        return sapling;
                    }
                }
            }
        }

        return null;
    }

    private boolean noLogsNextToBlock(class_2338 pos) {
        var world = this.beaver.method_37908();
        for (int ddx = -1; ddx <= 1; ddx++) {
            for (int ddz = -1; ddz <= 1; ddz++) {
                if (ddx == 0 && ddz == 0) {
                    continue;
                }
                var block = world.method_8320(pos.method_10069(ddx, 0, ddz));
                if (block.method_26164(class_3481.field_15475) || block.method_27852(CanadaBlocks.TREE_TAP)) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void method_6268() {
        if (isChoppingTree) {
            // Don't let them move away
            this.beaver.method_5942().method_6340();
            this.beaver.method_5988().method_19615(this.beaver.getChoppingTreePos().method_46558());

            if (!this.beaver.method_37908().method_8320(this.beaver.getChoppingTreePos()).method_26164(class_3481.field_15475) || 
                this.beaver.getChoppingTreePos().method_46558().method_1022(this.beaver.method_19538()) > 2f ||
                this.beaver.method_6081() != null) {
                // If something else broke it give up, or if we moved away or got hurts
                this.beaver.stopChopping();
                isChoppingTree = false;
            }
            else {
                // Particles and block breaking effects
                var stage = 10 * (MAX_BREAKING_TICKS - choppingTicks) / MAX_BREAKING_TICKS;

                this.beaver.setChoppingProgress(stage);

                choppingTicks--;

                if (choppingTicks <= 0) {
                    breakTree();
                }

                // Make sure the beaver stays here and faces the tree
                // Null check because maybe just broke it
                if (this.beaver.getChoppingTreePos() != null) {

                    this.beaver.method_5942().method_6340();
                    this.beaver.method_5988().method_19615(this.beaver.getChoppingTreePos().method_46558());
                }
            }
        }
        else if (this.beaver.getChoppingTreePos().method_46558().method_1022(this.beaver.method_19538()) < 1.6f) {
            // Reached the tree, chop it
            this.isChoppingTree = true;
            choppingTicks = MAX_BREAKING_TICKS;
        }
        if (beaver.method_29504()) {
            method_6270();
        }
    }

    private void breakTree() {
        var blockPos = this.beaver.getChoppingTreePos();
        while (this.beaver.method_37908().method_8320(blockPos).method_26164(class_3481.field_15475)) {
            this.beaver.method_37908().method_22352(blockPos, true);
            blockPos = blockPos.method_10084();
        }
        if (sapling != null) {
            this.beaver.method_37908().method_8501(this.beaver.getChoppingTreePos(), sapling.method_9564());
        }
        this.beaver.stopChopping();
        this.beaver.onChopTree();
        this.isChoppingTree = false;
    }
}
 
