package xen42.canadamod.entities;

import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1353;
import net.minecraft.class_1361;
import net.minecraft.class_1371;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1387;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1409;
import net.minecraft.class_1429;
import net.minecraft.class_1496;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3486;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5712;
import net.minecraft.class_6019;
import net.minecraft.class_7094;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import xen42.canadamod.CanadaItems;
import xen42.canadamod.CanadaMod;
import xen42.canadamod.CanadaSounds;

public class MooseEntity extends class_1496 implements class_5354 {
    private static final class_2940<Boolean> LEFT_ANTLER_MISSING = class_2945.method_12791(MooseEntity.class, class_2943.field_13323);
    private static final class_2940<Boolean> RIGHT_ANTLER_MISSING = class_2945.method_12791(MooseEntity.class, class_2943.field_13323);

    public final class_7094 attackAnimationState;
    private int attackAnimationEnd;

    public MooseEntity(class_1299<? extends class_1496> entityType, class_1937 world) {
        super(entityType, world);
        var mobNavigation = (class_1409)this.method_5942();
        mobNavigation.method_6354(true);
        mobNavigation.method_46645(true);
        attackAnimationState = new class_7094();
    }

    private static final class_4048 BABY_BASE_DIMENSIONS = CanadaMod.MOOSE_ENTITY.method_18386().method_18383(0.5F).method_55685(0.665F);

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
		builder.method_56912(LEFT_ANTLER_MISSING, false);
		builder.method_56912(RIGHT_ANTLER_MISSING, false);
    }

    @Override
    protected class_3414 method_6011(class_1282 source) {
        return CanadaSounds.SOUND_MOOSE_HURT;
    }

    @Override
    protected class_3414 method_6002() {
        return CanadaSounds.SOUND_MOOSE_DEATH;
    }

    @Nullable
    protected class_3414 method_5994() {
        return CanadaSounds.SOUND_MOOSE_AMBIENT;
    }

    public boolean isLeftAntlerMissing() {
        return this.method_5841().method_12789(LEFT_ANTLER_MISSING);
    }

    public boolean isRightAntlerMissing() {
        return this.method_5841().method_12789(RIGHT_ANTLER_MISSING);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1371(this));
        this.field_6201.method_6277(1, new class_1374(this, 2.0D, moose -> moose.method_6109() ? class_8103.field_51990 : class_8103.field_51991));
        this.field_6201.method_6277(2, new class_1341(this, 1.0D));
        this.field_6201.method_6277(3, new class_1387(this, 1.2));
        this.field_6201.method_6277(4, new class_1391(this, 1.2D, stack -> this.method_6481(stack), false));
        this.field_6201.method_6277(5, new class_1353(this, 1.1D));
        this.field_6201.method_6277(6, new class_1394(this, 1.0D));
        this.field_6201.method_6277(7, new class_1361(this, class_1657.class, 6.0F));
        this.field_6201.method_6277(8, new class_1376(this));

        this.field_6185.method_6277(1, new class_1399(this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, new class_1400<class_1657>(this, class_1657.class, 10, true, false, this::method_29515));
    }

    public static class_5132.class_5133 createMooseAttributes() {
        return class_1429.method_61457().method_26868(class_5134.field_23716, 25.0f).method_26868(class_5134.field_23719, 0.25f)
            .method_26868(class_5134.field_51578, 2f)
            .method_26868(class_5134.field_23721, 3.0D)
            .method_26867(class_5134.field_51583)
            .method_26868(class_5134.field_23728, 0.6D)
            .method_26868(class_5134.field_47761, 1.5D)
            .method_26868(class_5134.field_23717, 20.0D);
    }

    public void updateAnimations() {
        if (attackAnimationState.method_41327() && field_6012 > attackAnimationEnd) {
            attackAnimationState.method_41325();
        }
    }

    @Override
    public void method_5958(class_3218 world) {
        super.method_5958(world);
        method_29510(world, true);
        tryRegenAntler(true, false);
        tryRegenAntler(false, false);
        tryShedAntler(true, false);
        tryShedAntler(false, false);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        updateAnimations();
    }

    @Override
    public boolean method_6736() {
        // This is horse anger not attacking anger which we override
        return false;
    }

    private void tryRegenAntler(boolean left, boolean force) {
        if (left ? this.isLeftAntlerMissing() : this.isRightAntlerMissing()) {
            // Average length 5 minutes to regen antlers
            if (force || this.field_5974.method_43057() < 1f / (float)(5 * 60 * 20)) {
                this.method_5841().method_12778(left ? LEFT_ANTLER_MISSING : RIGHT_ANTLER_MISSING, false);
                this.method_5783(class_3417.field_15219, 1.0f, (field_5974.method_43057() - field_5974.method_43057()) * 0.2f + 1.0f);
            }
        }
    }

    private void tryShedAntler(boolean left, boolean force) {
        if (this.method_37908().method_8608()) {
            return;
        }

        // Average length 20 minutes to shed antlers
        if (force || this.field_5974.method_43057() < 1f / (float)(20 * 60 * 20)) {
            if (left ? !this.isLeftAntlerMissing() : !this.isRightAntlerMissing()) {
                var yaw = (float)(this.field_6283 * (Math.PI / 180));
                var offset = new class_243(left ? 0.4f : -0.4f, 0f, -1.5f);
                var antlerPos = new class_243(this.method_23317(), this.method_23320(), this.method_23321()).method_1019(offset.method_1024(yaw));

                var item = this.method_5706((class_3218)this.method_37908(), CanadaItems.ANTLERS);
                item.method_33574(antlerPos);
                this.method_5841().method_12778(left ? LEFT_ANTLER_MISSING : RIGHT_ANTLER_MISSING, true);

                this.method_5783(class_3417.field_14675, 1.0f, (field_5974.method_43057() - field_5974.method_43057()) * 0.2f + 1.0f);
            }
        }
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return stack.method_31574(class_1802.field_8158) || stack.method_31573(class_3489.field_15558);
    }

    @Override
    public boolean method_6474(class_1429 other) { 
        if (other != this && other instanceof MooseEntity otherMoose) {
            return method_6734() && otherMoose.method_6734();
        } 
        return false;
    }

    @Override
    protected boolean method_6734() {
        return !this.method_5782() && !this.method_5765() && !this.method_6109() && this.method_6032() >= this.method_6063() && this.method_6479();
    }

    @Override
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return (MooseEntity)CanadaMod.MOOSE_ENTITY.method_5883(world, class_3730.field_16466);
    }

    @Override
    public class_4048 method_55694(class_4050 pose) {
        return method_6109() ? BABY_BASE_DIMENSIONS : super.method_55694(pose);
    }

    @Override
    public void method_6007() {
        if (this.method_5642() != null) {
            if (this.method_5869() || (this.method_5799() && this.field_6960)) {
                this.method_6010(class_3486.field_15517);
            }
        }
        super.method_6007();
    }

    @Override
    public int method_6745(int difference) {
        if (difference > 0) {
            this.playAttackAnimation();
        }
        return super.method_6745(difference);
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) { 
        // If the moose wants to kill something it should not let u do anything
        if (attacking != null || this.attackingPlayer != null || this.method_5968() != null) {
            return class_1269.field_5814;
        }

        var itemStack = player.method_5998(hand);

        // No idea why but its using the wrong hand here
        var mainHandStack = player.method_5998(class_1268.field_5808);
        if (method_6481(mainHandStack)) {
            hand = class_1268.field_5808;
            itemStack = mainHandStack;
        }
        var offHandStack = player.method_5998(class_1268.field_5810);
        if (method_6481(offHandStack)) {
            hand = class_1268.field_5810;
            itemStack = offHandStack;
        }

        var isBreedingItem = method_6481(itemStack);

        var canBreed = this.method_6032() == this.method_6063() && !this.isLeftAntlerMissing() && !this.isRightAntlerMissing() && !method_6109();

        // does healing interaction stuff
        if (isBreedingItem) {
            if (!canBreed) {
                return method_30009(player, itemStack);
            }
            // does breeding
            else if (this.method_5618() == 0 && this.method_6482()) {
                this.method_6476(600);

                if (!this.method_37908().field_9236 ) {
                    this.method_6475(player, hand, itemStack);
                    this.method_6480(player);
                    this.method_61458();
                    return class_1269.field_52422;
                }

                if (this.method_37908().field_9236) {
                    return class_1269.field_21466;
                }
            }
        }

        // If not giving food, make untame guy angry and refuse ur item
        if (!isBreedingItem && !itemStack.method_7960() && !this.method_6727()) {
            this.method_6757();
            return class_1269.field_5812;
        }

        // Not hungry
        if (isBreedingItem) {
            return class_1269.field_5814;
        }

        // Does saddling and stuff
        return super.method_5992(player, hand);
    }

    protected void method_6099(class_3218 world, class_1282 source, boolean causedByPlayer) {
        super.method_6099(world, source, causedByPlayer);
        class_1297 entity = source.method_5529();
        if (entity instanceof class_1548 creeperEntity) {
            if (creeperEntity.method_7008()) {
                class_1799 itemStack = this.getSkull();
                if (!itemStack.method_7960()) {
                    creeperEntity.method_7002();
                    this.method_5775(world, itemStack);
                }
            }
        }

    }

    protected class_1799 getSkull() {
        return new class_1799(CanadaItems.MOOSE_HEAD);
    }

    @Override
    protected boolean method_6742(class_1657 player, class_1799 item) {
        if (!method_6481(item)) {
            return false;
        }

        boolean isHurt = (method_6032() < method_6063());
        if (isHurt) {
            method_6025(2.0F);
        }

        if (isLeftAntlerMissing()) {
            tryRegenAntler(true, true);
        }
        else if (isRightAntlerMissing()) {
            tryRegenAntler(false, true);
        }

        boolean isBaby = method_6109();
        if (isBaby) {
            method_37908().method_8406((class_2394)class_2398.field_11211, method_23322(1.0D), method_23319() + 0.5D, method_23325(1.0D), 0.0D, 0.0D, 0.0D);
            if (!(method_37908()).field_9236) {
                method_5615(10);
            }
        }

        boolean canLove = (method_5618() == 0 && method_6482());
        if (canLove) {
            method_6480(player);
        }

        if (isHurt || canLove || isBaby) {
            if (!method_5701()) {
                class_3414 soundEvent = method_28368();
                if (soundEvent != null) {
                    method_37908().method_43128(null, method_23317(), method_23318(), method_23321(), soundEvent, method_5634(), 1.0F, 1.0F + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2F);
                }
            }

            method_32876(class_5712.field_28735);
            return true;
        }

        return false;
    }

    @Override
    protected class_3414 method_6747() {
        return CanadaSounds.SOUND_MOOSE_ANGRY;
    }

    @Override
    public void method_6757() {
        this.method_56078(this.method_6747());
    }

    @Override
    public boolean method_6727() {
        return super.method_6727() && attacking == null;
    }

    @Override
    public void method_6114(class_1297 target) {
        super.method_6114(target);
        playAttackAnimation();
    }

    @Override
    public boolean method_6121(class_3218 world, class_1297 target) {
        playAttackAnimation();
        return super.method_6121(world, target);
    }

    private void playAttackAnimation() {
        attackAnimationState.method_41322(this.field_6012);
        this.attackAnimationEnd = this.field_6012 + 20;
    }

    private static final class_6019 ANGER_TIME_RANGE = class_4802.method_24505(20, 39);
    private int angerTime; 
    @Nullable
    private UUID angryAt;

    @Nullable
    private class_1309 attacking;

    @Nullable
    private class_1309 attacker;

    @Nullable
    private class_1657 attackingPlayer;

    @Override
    public void method_5980(@Nullable class_1309 target) {        
        if (this.method_65038()) {
            return;
        }

        if (target == null && target != this.method_5968()) {
            this.method_6757();
            this.playAttackAnimation();
        }

        if (target instanceof class_1657 player) {
            setPlayerTarget(player);
        }
        else if (target == null) {
            setPlayerTarget(null);
        }
        
        super.method_5980(target);
    }

    public void method_6722(class_1657 player) {
        if (!this.method_37908().field_9236) {
            player.method_7291(this, this.field_6962);
        }
    }

    @Override
    public float method_17825() {
        return method_6109() ? 0.5F : 1.0F;
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        method_29517(nbt);
        nbt.method_10556("IsLeftAntlerMissing", this.method_5841().method_12789(LEFT_ANTLER_MISSING));
        nbt.method_10556("IsRightAntlerMissing", this.method_5841().method_12789(RIGHT_ANTLER_MISSING));
    }

    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        method_29512(method_37908(), nbt);
        this.method_5841().method_12778(LEFT_ANTLER_MISSING, nbt.method_10577("IsLeftAntlerMissing").orElse(false));
        this.method_5841().method_12778(RIGHT_ANTLER_MISSING, nbt.method_10577("IsRightAntlerMissing").orElse(false));
    }

    public void setPlayerTarget(@Nullable class_1657 attacking) {
        this.attackingPlayer = attacking;
        this.field_6238 = this.field_6012;
    }

    @Override
    public void method_6015(@Nullable class_1309 attacker) {
        if (this.method_65038()) {
            return;
        }

        super.method_6015(attacker);
        this.attacker = attacker;
        method_5980(attacker);
    }

    @Nullable
    public class_1309 method_6065() {
        return this.attacker;
    }

    @Override
    public void method_29509() {
        method_29514(ANGER_TIME_RANGE.method_35008(this.field_5974));
    }

    @Override
    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        if (source.method_5526() instanceof class_1309 && this.field_5974.method_39332(0, 10) == 0) {
            this.tryShedAntler(this.field_5974.method_43056(), true);
        }
        return super.method_64397(world, source, amount);
    }

    @Override
    public void method_48922(class_1282 damageSource) {
        if (damageSource.method_5526() instanceof class_1309 entity) {
            this.method_6015(entity);
        }

        super.method_48922(damageSource);
    }

    @Override
    public void method_6078(class_1282 damageSource) {
        if (!this.method_37908().method_8608() && !this.method_6109()) {
            if (!this.isLeftAntlerMissing()) {
                var item = this.method_5706((class_3218)this.method_37908(), CanadaItems.ANTLERS);
                item.method_33574(this.method_33571());
            }
            if (!this.isRightAntlerMissing()) {
                var item = this.method_5706((class_3218)this.method_37908(), CanadaItems.ANTLERS);
                item.method_33574(this.method_33571());
            }
        }

        super.method_6078(damageSource);
    }

    @Override
    public int method_29507() {
        return this.angerTime;
    }

    @Override
    public UUID method_29508() {
        return this.angryAt;
    }

    @Override
    public void method_29514(int angerTime) {
        this.angerTime = angerTime;
    }

    @Override
    public void method_29513(UUID angryAt) {
        this.angryAt = angryAt;
    }

    @Override
    public class_1799 method_31480() {
        return new class_1799(CanadaItems.MOOSE_SPAWN_EGG);
    }
}
